<?php
/* ========================================================================
 - [modules/public/registry/account.php]
 -      会員登録フォーム
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/01/21] テーブルを fri_friends から fri_invite に変更
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_public.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_public
{
    /**
     * 友達名簿ID
     * @var integer
     */
    var $ref_invite = 0;

    /**
     * 暗号化用の種
     * @var string
     */
    var $seed = '';

    /**
     * 暗号化文字列
     * @var string
     */
    var $key = '';

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->setTemplateFile('public/registry/account.tpl');        

        /* PathInfo引数の設定 */
        $this->setPathInfo('ref_invite');
        $this->Assign('ref_invite', $this->ref_invite);
        $this->setPathInfo('seed',1,'string');
        $this->Assign('seed', $this->seed);
        $this->setPathInfo('key',2,'string');
        $this->Assign('key', $this->key);

        // PathInfo引数が正常に動いているか？
    	if (!$this->check_keyword()){
    	    $this->Assign('unmatch', true);
            return ;
    	}

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'act_account');
        $result = $this->do_query();
        if ($result == RKT_MANIP_VALIDATED){
            header('Location: '.SSL_ACTION.'public/registry/confirm/'.$this->sid.'/'.$this->ref_invite.'/'.$this->seed.'/'.$this->key.'/');
            exit();
        }
    }

    /**
     * キーワードの確認
     *
     * @access private
     * @return boolean 真偽値
     */
    function check_keyword()
    {
    	if (empty($this->seed)){
    		return false;
    	}

    	if (empty($this->key)){
    		return false;
    	}

        $sql=
            'SELECT '.
                'ref_account,'.
                'email '.
            'FROM '.
                DB_PREFIX.'fri_invite '.
            'WHERE '.
                'id ='.$this->ref_invite;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        $email = sql_query::decrypt($result['email']);

    	$seed = md5($result['ref_account'].RKT_SEED);
        $seed = substr($seed,4,6);
    	$key = md5($seed.$email.RKT_SEED);
        
    	if ($key != $this->key){
    		return false;
    	}
    	return true;
    }

    /**
     * 入力されたe-mailがユニークか
     *
     * @access private
     * @param string $email
     * @return boolean 正常時：真
     */
    function is_unique($email)
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'act_account '.
            'WHERE '.
                'avail = '.AVAIL_ENABLE.' AND '.
                "email_hash = '".md5($email)."'";
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        return empty($result['ct']);
    }

    /**
     * 既存パスワードが適正か判定
     *
     * @access private
     * @return boolean 正常時：真
     */
    function is_match()
    {
        $password = $this->objmnp->getRequest('password');
        $confirm  = $this->objmnp->getRequest('confirm');

        return ($password === $confirm);
    }

    /**
     * 入力項目の追加
     *
     * @access private
     * @return void
     */
    function set_input()
    {
        /* 名前：姓 */
        $validate = array(
            'type'=>'string',
            'option'=>array(),
            'required'=>true
        );
        $this->objmnp->setInput('second_name', $validate);

        /* 名前：名 */
        $validate = array(
            'type'=>'string',
            'option'=>array(),
            'required'=>true
        );
        $this->objmnp->setInput('first_name', $validate);

        /* ニックネーム */
        $validate = array(
            'type'=>'string',
            'option'=>array(),
            'required'=>true
        );
        $this->objmnp->setInput('nickname', $validate);

        /* パスワード確認 */
        $validate = array(
            'type'=>'string',
            'option'=>array(),
            'required'=>true
        );
        $this->objmnp->setInput('confirm', $validate);

        /* 利用規約 */
        $validate = array(
            'type'=>'number',
            'option'=>array(),
            'required'=>true
        );
        $this->objmnp->setInput('exclusion', $validate);
    }


    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        // チェックしない項目名
        $skip = array(
            'last_login',
            'modify',
            'regist_date',
            'avail',
            'status',
            'ref_community',
        );
        $this->objmnp->catchInput($skip);
        
        $this->set_input();
        
        // ログイン名のユニークチェック
        if (!$this->is_unique($this->objmnp->getValue('email'))){
            $this->objmnp->setAlert('unique');
        }

        // ログイン名のユニークチェック
        if (!$this->is_match()){
            $this->objmnp->setAlert('confirm');
        }

        return $this->objmnp->doValidate($this);
    }
} // webapp
?>
