<?php
/* ========================================================================
 - [modules/private/show/intro.php]
 -      紹介文一覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/show/intro.tpl');        

        $this->set_profile();
        $this->set_intro();
    }

    /**
     * 友達情報の設定
     *
     * @access private
     * @return void
     */
    function set_profile()
    {
        $sql=
            'SELECT '.
                'act.id as id,'.
                'pro.nickname as nickname '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'act.id = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->Assign('profile', $result);
    }

    /**
     * 紹介文の設定
     *
     * @access private
     * @return void
     */
    function set_intro()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $_SESSION['offset'] = $offset;

        $objpgr = new RKT_pager($this->objdb, $offset, 50);    // クラスの生成
        $sql=
            'SELECT '.
                'ref_friend,'.
                'relation,'.
                'comment '.
            'FROM '.
                DB_PREFIX.'fri_intro '.
            'WHERE '.
                'ref_account = '.$this->account['id'].' '.
            'ORDER BY '.
                'modify';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();
        
        $list = array();
        foreach ($result as $value){
            $list[] = array (
                'id'=>       $value['ref_friend'],
                'relation'=> $value['relation'],
                'comment'=>  $value['comment'],
                'photo'  =>  $this->get_friend($value['ref_friend'])
            );
        }
        
        $this->Assign('intros', $list);
    }

    /**
     * 友達情報の取得
     *
     * @access private
     * @return void
     */
    function get_friend($ref_account)
    {
        $sql=
            'SELECT '.
                'act.id as id,'.
                'pro.nickname as nickname,'.
                'act.friend_number as friend_number,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_profile pro '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'act.id = '.$ref_account;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        if (empty($result)){
            $result = array(
                'id'=> null,
                'name'=> '',
                'friend_number'=>0,
                'src'=>    NOPHOTO_LARGE,
                'width'=>  PHOTO_SMALL_SIZE,
                'height'=> PHOTO_SMALL_SIZE
            );
        }
        $result['src'] = empty($result['src'])?NOPHOTO_SMALL:$result['src'];
        $result['width'] = empty($result['width'])?PHOTO_SMALL_SIZE:$result['width'];
        $result['height'] = empty($result['height'])?PHOTO_SMALL_SIZE:$result['height'];

        return $result;
    }
} // webapp
?>
