<?php
/* ========================================================================
 - [modules/friend/show/recent.php]
 -      プロフィール
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'wap_friend.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_friend
{
    /**
     * ページstatus
     * @var integer
     */
    var $status = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('friend/show/recent.tpl');

        /* PathInfo引数の設定 */
        $this->setPathInfo('status', 1);
        $this->status = empty($this->status)?1:$this->status; 
        $this->Assign('status', $this->status);

        $titles = array(
            '1'=> '最近のレビュー',
            '2'=> '最近の日記',
            '3'=> '最近のトピック',
        );
        $this->baseAssign('title',  $titles[$this->status]);

        if ($this->status == 1){
            $this->set_review();
        } elseif ($this->status == 2){
            $this->set_diary();
        } else {
            $this->set_forum();
        }
    }

    /**
     * 日記の設定
     *
     * @access private
     * @return void
     */
    function set_diary()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_ROWS);    // クラスの生成
        $sql=
            'SELECT '.
                'ent.id as ref_entry,'.
                'act.id as ref_friend,'.
                'pro.nickname as nickname,'.
                'ent.regist_date as modify,'.
                'ent.subject as subject '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'dia_diary dia,'.
                DB_PREFIX.'dia_entry ent '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = dia.ref_account AND '.
                'dia.id = ent.ref_diary AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'dia.ref_account = '.$this->ref_friend.' '.
            'ORDER BY '.
                'ent.regist_date DESC ';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();

        $this->Assign('diarys', $result);
    }

    /**
     * レビューの設定
     *
     * @access private
     * @return void
     */
    function set_review()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_ROWS);    // クラスの生成
        $sql = 
            'SELECT '.
                'itm.id as id,'.
                'itm.name as name,'.
                'rev.modify as modify '.
            'FROM '.
                DB_PREFIX.'rev_item itm,'.
                DB_PREFIX.'rev_review rev '.
            'WHERE '.
                'itm.id = rev.ref_item AND '.
                'rev.ref_account = '.$this->ref_friend.' '.
            'ORDER BY '.
                'rev.modify DESC ';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();

        $this->Assign('reviews', $result);
    }

    /**
     * Myフォーラムの新トピック
     *
     * @access private
     * @return void
     */
    function set_forum()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_ROWS);    // クラスの生成
        /* 友達か？ */
        $where = '';
        if ($this->isFriend()){
            $where = 'OR visibility = '.VISIBILITY_FRIEND.' ';
        }

        $sql=
            'SELECT '.
                'id,'.
                'modify,'.
                'post,'.
                'topic '.
            'FROM '.
                DB_PREFIX.'frm_topic '.
            'WHERE '.
                'ref_account = '.$this->ref_friend.' AND '.
                '(visibility = '.VISIBILITY_PROTECTED.' '.
                $where.') '.
            'ORDER BY '.
                'modify DESC ';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();

        $this->Assign('forums', $result);
    }

} // webapp
?>
