<?php
/* ========================================================================
 - [modules/community/bbs/send.php]
 -      イベント参加者へメッセージ送信
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'sendmail.php';
require_once WEBAPP_LIB_DIR.'wap_community.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_community
{
    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * トピックID
     * @var integer
     */
    var $id = 0;

    /**
     * ページ情報
     * @var string
     */
    var $page = '';

    /**
     * 友達ＩＤ格納用
     * @var array
     */
    var $ref_entrys = array();

    /**
     * トピック情報
     * @var string
     */
    var $topic = '';

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('community/bbs/send.tpl');

        /* PathInfo引数の設定 */
        $this->setPathInfo('id', 1);
        $this->Assign('id', $this->id);
        $this->setPathInfo('page', 2,'string');
        $is_edit = empty($this->page)?'again':$this->page;
        $this->Assign('edit', preg_match('/^again$/',$is_edit));

        /* メンバーではない */
        if (!$this->community['is_member']){
            header('Location: '.HTTP_ACTION.'community/bbs/list/'.$this->sid.'/'.$this->ref_community.'/');
            exit();
        }

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'community/bbs/send/'.$this->sid.'/'.$this->ref_community.'/'.$this->id.'/again/');
            exit();
        }

        $this->set_ref_entrys();
        $this->set_topic();
        $this->set_member();
        
        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb,  DB_PREFIX.'fri_message');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->do_send_message();
            $this->Assign('complete', true);
            unset($_SESSION[DB_PREFIX.'fri_message']);
            unset($_SESSION['ref_entrys']);
        } elseif($result == RKT_MANIP_VALIDATED) {
            $_SESSION['ref_entrys'] = $this->ref_entrys;
            header('Location: '.HTTP_ACTION.'community/bbs/send/'.$this->sid.'/'.$this->ref_community.'/'.$this->id.'/confirm/');
            exit();
        }
    }

    /**
     * トピック一覧の設定
     *
     * @access private
     * @return void
     */
    function set_topic()
    {
        $sql=
            'SELECT '.
                'tpc.id as id,'.
                'tpc.regist_date as regist_date,'.
                'tpc.start_date as start_date,'.
                'tpc.deadline as deadline,'.
                'tpc.start_hour as start_hour,'.
                'tpc.start_minute as start_minute,'.
                'pro.nickname as nickname,'.
                'tpc.ref_account as ref_account,'.
                'tpc.status as status,'.
                'prf.prefecture as prefecture,'.
                'tpc.sub_locale as sub_locale,'.
                'tpc.topic as topic,'.
                'tpc.comment as comment '.
            'FROM '.
                DB_PREFIX.'com_topic tpc '.
                    'LEFT JOIN '.DB_PREFIX.'ara_prefecture prf '.
                    'ON prf.id = tpc.ref_prefecture,'.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = tpc.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'tpc.id = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->topic = array(
            'id'=> $result['id'],
            'regist_date'=> $result['regist_date'],
            'start_date'=> $result['start_date'],
            'deadline'=> (ereg('0000',$result['deadline']))?null:$result['deadline'],
            'start_hour'=> $result['start_hour'],
            'start_minute'=> $result['start_minute'],
            'nickname'=> $result['nickname'],
            'ref_account'=> $result['ref_account'],
            'status'=> $result['status'],
            'prefecture'=> $result['prefecture'],
            'sub_locale'=> $result['sub_locale'],
            'topic'=> $result['topic'],
            'comment'=> $result['comment'],
            'count'=> $this->get_comment_num($result['id']),
            'entrys'=> $this->get_entry_num($result['id'])
        );

        $this->Assign('topic', $this->topic);
    }

    /**
     * 参加数の取得
     *
     * @access private
     * @param integer $ref_topic
     * @return integer
     */
    function get_entry_num($ref_topic)
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'com_entry '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_topic = '.$ref_topic;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        return $result['ct'];
    }

    /**
     * コメント数の取得
     *
     * @access private
     * @param integer $ref_topic
     * @return integer
     */
    function get_comment_num($ref_topic)
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'com_comment '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_topic = '.$ref_topic;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        return $result['ct'];
    }

    /**
     * メッセージ送信相手の設定
     *
     * @access private
     * @return array
     */
    function set_ref_entrys()
    {
        if (!empty($_POST['ref_entrys'])){
            $this->ref_entrys = $_POST['ref_entrys'];
            unset($_SESSION['ref_entrys']);
            return ;
        }

        if (!empty($_SESSION['ref_entrys'])){
            $this->ref_entrys = $_SESSION['ref_entrys'];
            return ;
        }

        $this->ref_entrys = array();
    }

    /**
     * 友達の設定
     *
     * @access private
     * @return void
     */
    function set_member()
    {
        $is_confirm = preg_match('/confirm/',$_SERVER['REQUEST_URI']);
        $sql=
            'SELECT '.
                'act.id as id,'.
                'pro.nickname as nickname,'.
                'act.friend_number as friend_number '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'com_entry ent '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = ent.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'ent.ref_topic = '.$this->id.' AND '.
                'ent.ref_community = '.$this->ref_community .' '.
            'ORDER BY '.
                'ent.modify ';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        
        $list=array();
        $row=0;
        if ($is_confirm){
            foreach ($result as $value){
                if (!empty($this->ref_entrys[$value['id']])){
                    $list[] = array(
                        'id'=>            $value['id'],
                        'nickname'=>      $value['nickname'],
                        'friend_number'=> 1,
                        'friend_number'=> $value['friend_number'],
                    );
                    $row++;
                }
            } // foreach ($result as $value)
        } else {
            foreach ($result as $value){
                $list[] = array(
                    'id'=>            $value['id'],
                    'nickname'=>      $value['nickname'],
                    'checked'=>       !empty($this->ref_entrys[$value['id']]),
                    'friend_number'=> $value['friend_number'],
                );
                $row++;
            }
        } // if ($is_confirm)
        
        $this->Assign('members', $list);
    }

    /**
     * 会員情報の成形
     *
     * @access private
     * @return array
     */
    function shape_member($friends)
    {
        $list = array();
        $row = 0;
        $column = 0;
        foreach ($friends as $value){
            // 改行処理
            if ($column >= 5){
                $column = 0;
                $row++;
            }
            $list[$row][$column] = $value;
            $column++;
        } // foreach ($result as $value)
        
        return $list;
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        if (!empty($_POST['manip'])){
            return RKT_MANIP_COMPLETE;
        }
        $this->objmnp->validate('number','ref_entrys', null, true);

        // 更新しない項目名
        $skip = array(
            'regist_date',
            'modify',
            'ref_account',
            'ref_message',
            'ref_to',
            'ref_from',
            'flag',
            'status',
            'subject',
        );
        $this->objmnp->catchInput($skip);

        return $this->objmnp->doValidate($this);
    }

    /**
     * メッセージの送信
     *
     * @access private
     * @return void
     */
    function do_send_message()
    {
        $sql=
            'SELECT '.
                'nickname '.
            'FROM '.
                DB_PREFIX.'act_profile '.
            'WHERE '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $infos = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $body = 
            'イベントの企画者 '.$infos['nickname'].' さんからのお知らせです。'."\r\n".
            "\r\n".
            '[コミュニティ名]:'.$this->community['community']."\r\n".
            "\r\n".
            '[イベント名]:'.$this->topic['topic']."\r\n".
            "\r\n".
            '[メッセージ]:'."\r\n".
            $_SESSION[DB_PREFIX.'fri_message']['body']."\r\n".
            "\r\n".
            '[イベントのUR]:'."\r\n".
            HTTP_ACTION.'community/bbs/browse/'.$this->ref_community.'/'.$this->id.'/'."\r\n";


        $value = array(
            'modify'=> date('Y-m-d H:i:s'),
            'regist_date'=> date('Y-m-d H:i:s'),
            'ref_account'=> 0,
            'ref_to'=> 0,
            'ref_from'=> $this->account['id'],
            'subject'=> $this->topic['topic'].'のお知らせ',
            'body'=> $body,
        );

        foreach ($this->ref_entrys as $id){
            $id = $this->objdb->quote($id);
            $value['ref_account'] = $id;
            $value['ref_to'] = $id;
            $this->insert_message($value);
            $this->send_mail($id);
        }
    }

    /**
     * メッセージの送信
     *
     * @access private
     * @return integer  データ操作結果
     */
    function insert_message($value)
    {
        $sql =
            'INSERT INTO '.
                DB_PREFIX.'fri_message('.
                    'modify,'.
                    'regist_date,'.
                    'status,'.
                    'ref_account,'.
                    'ref_to,'.
                    'ref_from,'.
                    'flag,'.
                    'subject,'.
                    'body'.
                ') VALUES ('.
                    "'".$value['modify']."',".
                    "'".$value['regist_date']."',".
                    MESSAGE_INBOX.','.
                    $value['ref_account'].','.
                    $value['ref_to'].','.
                    $value['ref_from'].','.
                    MESSAGE_FLAG_UNREAD.','.
                    "'".$value['subject']."',".
                    "'".$value['body']."'".
                ')';
        return $this->objdb->exec($sql);
    }

    /**
     * 自動通知メール
     *
     * @access private
     * @param integer $id
     * @return void
     */
    function send_mail($id)
    {
        $sql=
            'SELECT '.
                'com.id as id,'.
                'act.email as email,'.
                'pro.nickname as nickname,'.
                'frm.nickname as from_name,'.
                'com.community as community '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'act_profile frm,'.
                DB_PREFIX.'com_community com,'.
                DB_PREFIX.'com_names nam '.
            'WHERE '.
                'act.id = nam.ref_account AND '.
                'act.id = pro.ref_account AND '.
                'com.id = nam.ref_community AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'com.avail = '.AVAIL_ENABLE.' AND '.
                'act.id = '.$id.' AND '.
                'frm.ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $infos = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $objmail = new sendmail('topic');

        $objmail->Assign('friend', $infos['from_name']);
        $objmail->Assign('user_name', $infos['nickname']);
        $objmail->Assign('community', $infos['community']);
        $objmail->Assign('topic', $this->topic['topic']);
        $objmail->Assign('url', HTTP_ACTION.'community/bbs/browse/'.$infos['id'].'/'.$this->id.'/');
        $objmail->Assign('url2', HTTP_ACTION.'private/message/list/');

        $to = sql_query::decrypt($infos['email']);
        $objmail->send($to);
    }
} // webapp
?>
