<?php
/* ========================================================================
 - [libs/rkt_upload.php]
 -      画像のアップロード リサイズ機能付
 -      Copyright (c) 2004-2006 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 注意事項:
 -      GIF生成モジュールが使えない場合はImageGifをImagePNGに変更してください。
 - 更新履歴：
 -      [2006/06/06] イメージ処理部分をrkt_imageクラスを使用
 -      [2004/01/24] 作成
 - ======================================================================== */

require_once LIB_DIR.'rkt_image.php';

/**
 * アップロード画像のリサイズ
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_upimage
 * @access public
 * @version 1.1
 */
class RKT_upload
{
    /**
     * DRIVER
     * @access private
     * @var string
     */
    var $driver = BLOB_DRIVER;

    /**
     * インスタンス生成　現在の接続を返す
     *
     * @access public
     * @param string $driver
     * @param string $param
     * @return object
     */
    function &getInstance($driver,$param)
    {
        return RKT_upload::factory($driver,$param);
    }

    /**
     * ファクトリークラスの作成
     *
     * @access public
     * @param string $driver
     * @param string $param
     * @return object オブジェクト
     */
    function &factory($driver,$param)
    {
        include_once LIB_DIR.'rktUpload/upd_'.$driver.'.php';

        $classname = 'UPD_'.$driver;

        @$objupd =& new $classname($param);

        return $objupd;
    }
} // RKT_upimage
?>