<?php
/* ========================================================================
 - [libs/rkt_session.php]
 -      セッション管理クラス
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 更新履歴：
 -      [2006/08/18]    作成
 - ======================================================================== */

require_once LIB_DIR.'rkt_db.php';

/**
 * セッション管理クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_session
 * @access public
 * @version 1.0
 */
class RKT_session
{
    /**
     * データベース接続オブジェクト
     * @access private
     * @var object
     */
    var $objdb = null;

    /**
     * コンストラクタ
     *
     * @access public
     * @return void
     */
    function RKT_session()
    {
        $this->objdb = RKT_db::getInstance();
    }

    /**
     * インスタンス生成　現在の接続を返す
     *
     * @access public
     * @return object
     */
    function &getInstance()
    {
        static $__singleton;

        if (empty($__singleton)) {
            /* PDO データベースハンドルの生成 */
            $__singleton = new RKT_session();
        }
        return $__singleton;
    }
    /**
     * 各ハンドルの設定
     *
     * @access public
     * @return void
     */
    function setSaveHandler()
    {
        $objses = RKT_session::getInstance();

        session_set_save_handler(array(&$objses, 'open'),
                                 array(&$objses, 'close'),
                                 array(&$objses, 'read'),
                                 array(&$objses, 'write'),
                                 array(&$objses, 'destroy'),
                                 array(&$objses, 'gc'));
        register_shutdown_function('session_write_close');
    }

    /**
     * オープン
     *
     * @access public
     * @param string $save_path
     * @param string $session_name
     * @return boolean
     */
    function open($save_path, $session_name)
    {
        return true;
    }

    /**
     * クローズ
     *
     * @access public
     * @return boolean
     */
    function close()
    {
        /*
         * 強制的に100%
         * ini_set('session.gc_divisor', 100);
         * $this->gc(ini_get('session.gc_maxlifetime'));
         */
        return true;
    }

    /**
     * 読み込み
     *
     * @access public
     * @param string $id
     * @return string
     */
    function read($id)
    {
        $id = trim($this->objdb->quote($id), "'");
        $sql=
            'SELECT '.
                'sess_data '.
            'FROM '.
                RKT_TBL_SESSION.' '.
            'WHERE '.
                "id = '".$id."'";
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        if (empty($result['sess_data'])){
            return '';
        }
        return $result['sess_data'];
    }

    /**
     * 書き込み
     *
     * @access public
     * @param string $id
     * @param string $sess_data
     * @return boolean
     */
    function write($id, $sess_data)
    {
        $values = array (
            'id'=>        trim($this->objdb->quote($id), "'"),
            'life_time'=> time(),
            'sess_data'=> trim($this->objdb->quote($sess_data), "'"),
        );

        /* 更新・挿入処理 */
        $result = $this->__update($values);
        if (!$result){
            $result = $this->__insert($values);
        }
        return !empty($result);
    }

    /**
     * 廃棄
     *
     * @access public
     * @param string $id
     * @return void
     */
    function destroy($id)
    {
        $id = trim($this->objdb->quote($id), "'");
        $sql = 
            'DELETE FROM '.
                RKT_TBL_SESSION.' '.
            'WHERE '.
                "id = '".$id."'";
        $result = $this->objdb->exec($sql);

        return !empty($result);
    }

    /**
     * ガーベッジコレクション
     *
     * @access public
     * @param integer $maxlifetime
     * @return void
     *
     * コールされる確立(デフォルト100%)を以下で設定
     * ini_set('session.gc_divisor', 100);
     */
    function gc($maxlifetime)
    {
        $deadline = time() - intval($maxlifetime);
        $sql = 
            'DELETE FROM '.
                RKT_TBL_SESSION.' '.
            'WHERE '.
                'life_time < '.$deadline;
        $result = $this->objdb->exec($sql);

        return !empty($result);
    }

    /**
     * 更新処理
     *
     * @access private
     * @param array $values
     * @return boolean
     */
    function __update($values)
    {
        $sql = 
            'UPDATE '.
                RKT_TBL_SESSION.' '.
            'SET '.
                'life_time = '.$values['life_time'].','.
                "sess_data = '".$values['sess_data']."' ".
            'WHERE '.
                "id = '".$values['id']."'";
        return $this->objdb->exec($sql);
    }

    /**
     * 挿入処理
     *
     * @access private
     * @param array $values
     * @return boolean
     */
    function __insert($values)
    {
        $sql = 
            'INSERT INTO '.
                RKT_TBL_SESSION.' ('.
                    'id,'.
                    'life_time,'.
                    'sess_data'.
                ') VALUES ('.
                    "'".$values['id']."',".
                    $values['life_time'].','.
                    "'".$values['sess_data']."'".
                ')';
        return $this->objdb->exec($sql);
    }
} // RKT_sessionの終了
?>