<?php
/* ========================================================================
 - [libs/rkt_blob.php]
 -      バイナリデータ管理クラス
 -      Copyright (c) 2005 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 更新履歴：
 -      [2005/08/20] 作成
 - ======================================================================== */

/**
 * バイナリデータ管理クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_upimage
 * @access public
 * @version 1.1
 */
class RKT_blob
{
    /**
     * DRIVER
     * @access private
     * @var string
     */
    var $driver = 'db';

    /**
     * インスタンス生成　現在の接続を返す
     *
     * @access public
     * @param string $driver
     * @param string $param
     * @return object
     */
    function &getInstance($driver,$param)
    {
        static $__singleton;
        
        if ($__singleton == null) {
            $objblob = new RKT_blob($driver);
            $__singleton = $objblob->factory($driver,$param);
        }
        return $__singleton;
    }

    /**
     * コンストラクタ
     *
     * @access public
     * @param string $driver
     * @return void
     */
    function RKT_blob($driver='db')
    {        
        $this->driver = $driver;
    }

    /**
     * ファクトリークラスの作成
     *
     * @access public
     * @param string $driver
     * @param string $param
     * @return object オブジェクト
     */
    function &factory($driver,$param)
    {
        include_once LIB_DIR.'rktBlob/blob_'.$driver.'.php';

        $classname = 'BLOB_'.$driver;

        @$objblob =& new $classname($param);

        return $objblob;
    }
} // RKT_image
?>
