<?php
/**
 * Smarty plugin
 * @package Smarty
 * @subpackage plugins
 */


/**
 * Smarty {rkt_seo_pager} function plugin
 *
 * Type:     function<br>
 * Name:     rkt_seo_pager<br>
 * Date:     Nov 26, 2005<br>
 * Purpose:  make an pager links from an array of data<br>
 * Input:<br>
 *         - links = array of link data
 *         - uri = string of uri data
 *         - separator = string of separator
 *
 *
 * Examples:
 * <pre>
 * {rkt_seo_pager links=$links uri=$uri}
 * {rkt_seo_pager links=$links uri='http://example.com/' separator='&nbsp;'}
 * </pre>
 * @author   Yujiro Takahashi <yujiro@rakuto.net>
 * @version  1.0
 * @link none
 * @param array
 * @param Smarty
 * @return string
 */
function smarty_function_rkt_seo_pager($params, &$smarty)
{
    $_html_result = '';
    if (!is_array($params)){
        return $_html_result;
    }
    extract($params);
    $uri = empty($uri)?'':$uri;
    $separator = empty($separator)?'&nbsp;':$separator;

    $pager_func = array(
        'curr'=> 'rkt_seo_pager_focus_page',
        'pager'=> 'rkt_seo_pager_blur_page'
    );    

    $pager = array();
    foreach ($links as $link){
        $pager[] = call_user_func($pager_func[$link['class']], $link, $uri);
    }

    $_html_result = implode($separator,$pager); 

    return $_html_result;
}

/**
 * ݂̃y[WHTML ̐
 *
 * @access private
 * @param array $link N
 * @param string $uri URI
 * @return string
 */
function rkt_seo_pager_focus_page($link, $uri)
{
	return '<strong>'.$link['page'].'</strong>';
}

/**
 * y[WNHTML ̐
 *
 * @access private
 * @param array $link N
 * @param string $uri URI
 * @return string
 */
function rkt_seo_pager_blur_page($link, $uri)
{
    $uri = str_replace('%offset%', $link['offset'], $uri);

	return '<a href="'.$uri.'">'.$link['page'].'</a>';
}

/* vim: set expandtab: */

?>
