// ========================================================================
// http://a-h.parfe.jp/einfach/archives/2006/1213124637.html
// - =======================================================================

function setDefault(){
	$('edit').contentWindow.document.body.innerHTML = $('html').value;
}

var CrossEditor = Class.create();

CrossEditor.prototype = {
	initialize: function(img_path) {
		this.doc = $('edit').contentWindow.document;
		this.doc.designMode = 'on';
		this.img_path = img_path;

		Event.observe(this.doc, 'keyup', function(event){
//			this.makeHTML();
		}.bind(this));
		
		this.createMenu();

		var pallete = new ColorPallete('pallete_button', 'pallete', this);
	},
	createMenu: function(){

		var cmds = ['undo',
		'redo',
		'fontsize',
		'bold',
		'underline',
		'forecolor',
		'removeformat' ];

		cmds.each(function(cmd){
			var menu = document.createElement('li');
			var icon = document.createElement('img');
			icon.src  = this.img_path + cmd + '.gif';
			icon.alt = cmd;
			menu.appendChild(icon);

			if(cmd=='forecolor'){
				menu.id = 'pallete_button';
				$('menu').appendChild(menu);
				return;
			}

			if (cmd=='fontsize'){
				this.createSelect();
			} else {
				var opt = false;
			}

			Event.observe(menu, 'mousedown', function(){
				this.exCom(cmd, opt)
			}.bind(this));
			
			$('menu').appendChild(menu);
			
		}.bind(this));
	},
	exCom: function(cmd, opt){
		try{
			if (cmd=='fontsize'){
				opt = $('fsize').selectedIndex + 1;
			}
			this.doc.execCommand(cmd, false, opt);
		}catch(e){
//			alert(cmd+'は'+e+'です。');

			alert('このブラウザではサポートされていないコマンドです。')
		}
	},
	makeHTML: function(){
		$('html').value = this.doc.body.innerHTML.toString();
	},
	createSelect: function(){
		var menu = document.createElement('li');
		var column  = document.createTextNode(' サイズ:');
		var select = document.createElement('select');

		//		var sizes = $R(1,2,3,4,5,6,7);
		var sizes = [1,2,3,4,5,6,7];
		sizes.each(
			function(size){
				var option = document.createElement('option');
				var label  = document.createTextNode(size);
				option.value = size;
				option.appendChild(label);
				select.appendChild(option);
			}
		);
		select.id = 'fsize';
		select.style.fontSize = '10px';
		menu.appendChild(column);
		menu.appendChild(select);
		$('menu').appendChild(menu);
	}
}


var ColorPallete = Class.create();

ColorPallete.prototype = {
	initialize: function(button, area, editor) {
		this.div = $(area);
		this.div.innerHTML = this.create();
		Event.observe(document, 'keydown', this.hotkey.bind(this), false);
		this.button = $(button);
		Event.observe(button, 'click', this.toggle.bind(this));
		this.editor = editor;
		this.setEvent();
	},
	create: function() {
		var source = '<table><tbody>';
		var color='';
		var hex = new Array('f','c','9','6','3','0')
		for(j=0;j<6;j++){
			for(k=0;k<6;k++){
				for(l=0;l<6;l++){
					var hexColor = hex[j]+hex[j]+hex[k]+hex[k]+hex[l]+hex[l];
					color+='<td style="background-color: #'+hexColor+'"></td>';
				}
			}
			source+='<tr>'+color+'</tr>';
			color='';
		}
		for(i=0;i<6;i++){
			var hexColor = hex[i]+hex[i]+hex[i]+hex[i]+hex[i]+hex[i];
			color+='<td style="background-color: #'+hexColor+'" colspan="6"></td>';
		}
		source+='<tr>'+color+'</tr>';
		source+='</tbody></table>';
		return source;
	},
	show: function(){
		var pallete = this.div.style;
		pallete.top = this.button.offsetTop + 30 + 'px';
		pallete.left = this.button.offsetLeft + 'px';
		pallete.display = 'block';
	},
	hide: function(){
		var pallete = this.div.style;
		pallete.display = 'none';
	},
	toggle: function(){
		if(this.div.style.display != 'block'){
			this.show();
		}else{
			this.hide();
		}
	},
	hotkey: function(event){
		if(event.keyCode == 27){ // 'Esc'
			this.hide();
		}
	},
	setEvent: function(){
		Event.observe(document.body, 'mousedown' ,function(e){
			e = e || window.event;
			var element = e.target || e.srcElement;
			var tag = element.tagName.toLowerCase();
			if(tag == 'td' && element.offsetParent.parentNode.id == 'pallete'){
				var cmd = 'forecolor';
				var opt = element.style.backgroundColor;
				this.editor.exCom(cmd, opt);
				this.editor.makeHTML();
				this.hide();
			}else if(tag == 'body'){
				this.hide();
			}
		}.bind(this));
	}
}

function roundMath(num){
	return Math.round(num * 100) / 100;
}
function log(obj){
	return console.log(obj);
}



/**************************************************************
 *                                                            *
/**************************************************************/
function setInsertBody(str){
	$('edit').contentWindow.document.body.innerHTML = str;
}

function setImages(str){
	$('images').innerHTML = str;
}

function insertImg(src){
	var body = $('edit').contentWindow.document.body.innerHTML.toString();
	body += '<img src="'+ src +'">';

	$('edit').contentWindow.document.body.innerHTML = body;
}

function insertImgLink(href,src){
	var body = $('edit').contentWindow.document.body.innerHTML.toString();
	body += '<a href="'+ href +'">';
	body += '<img src="'+ src +'">';
	body += '</a>';

	$('edit').contentWindow.document.body.innerHTML = body;
}

function saveEdit(){
	$('html').value = $('edit').contentWindow.document.body.innerHTML.toString();
}
