<?php
/* ========================================================================
 - [htdocs/archives.php]
 - 内容：バイナリデータの出力
 - 作成：高橋 裕志郎
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 -      Copyright (C) 2006 `rakuto.net'. All Rights Reserved.
 - 更新履歴：
 -      [2006/09/14] 日記のPDF読み込み追加
 -      [2006/08/21] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once '../sns_config.php';
require_once BASE_DIR.'sns_config.php';
require_once LIB_DIR.'rkt_blob.php';

// ------------------------------------------------
// 実行関数
// 引数         なし
// 戻り値       なし
// ------------------------------------------------
function _main()
{
    /* パスインフォからIDを取得 */
    $path_info = empty($_SERVER[PATH_INFO_KEY])?'':$_SERVER[PATH_INFO_KEY];
    $filename = ACTION_ARCHIVES.$path_info;

    /* BLOB管理オブジェクトの生成 */
    $objblb = RKT_blob::getInstance(BLOB_DRIVER,BLOB_PARAM); 
    $objblb->load($filename);

    /* 画像サイズ変更 */
    if (isset($_GET['width']) && isset($_GET['height'])){
        $width  = intval($_GET['width']);
        $height = intval($_GET['height']);

        /* ファイルの種類が画像か判定 */
        $mime_type = $objblb->getMimeType();
        if (preg_match('/image/i', $mime_type)){
            include_once LIB_DIR.'rkt_image.php';

            $objimg = RKT_image::factory(IMAGE_DRIVER);
            $objimg->setBinary($objblb->getBuffer(), $objblb->getExtension());
            $objimg->resize($width, $height);
            $objimg->output();
            exit();
        }
    } // if (isset($_REQUEST['width']) && isset($_REQUEST['height']))


    $objblb->output();
    exit();
}

_main();    // 実行関数
?>
