<?php
/* ========================================================================
 - [modules/setup/check.php]
 -      各種環境のチェック
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/09/29] モジュール等の読み込み内容を修正
 -      [2006/09/29] データベースを使用する処理を排除
 -      [2006/08/24] 作成
 - ======================================================================== */
 
/* =-=- モジュール等の読み込み -=-= */
require_once '../sns_config.php';
require_once LIB_DIR.'rkt_validate.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp
{
    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objvld = null;

    /**
     * 入力条件データ
     * @var array
     */
    var $conditions = array();

    /**
     * 入力データ
     * @var array
     */
    var $values = array();

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        if (!empty($_GET['complete'])){
            $this->Assign('complete', true);
        }
        
        $this->check_extension();
        $this->check_writable();
    }

    /**
     * テンプレートへ変数を設定
     *
     * @access public
     * @param array|string $tpl_var the template variable name(s)
     * @param mixed $value the value to assign
     */
    function Assign($tpl_var,$value)
    {
        $GLOBALS[$tpl_var] = $value;
    }

    /**
     * モジュールの確認
     *
     * @access private
     * @return void
     **/
    function check_extension()
    {
        $ok = '<strong style="color:blue">OK</strong>';
        $ng = '<strong style="color:red">NG</strong>';

        $result = extension_loaded('gd')?$ok:$ng;
        $this->Assign('gd', $result);

        $result = extension_loaded('mbstring')?$ok:$ng;
        $this->Assign('mbstring', $result);

        $result = extension_loaded('pdo')?$ok:$ng;
        $this->Assign('pdo', $result);

        $result = extension_loaded('sqlite')?$ok:$ng;
        $this->Assign('sqlite', $result);
    }

    /**
     * ファイルの書き込み権限
     *
     * @access private
     * @return void
     **/
    function check_writable()
    {
        $ok = '<strong style="color:blue">OK</strong>';
        $ng = '<strong style="color:red">NG</strong>';

        $result = is_writable(BASE_DIR.'sns_config.php')?$ok:$ng;
        $this->Assign('sns_config', $result);

        $dir = WORK_DIR.'templates_c'.DIRECTORY_SEPARATOR.'webapp'.DIRECTORY_SEPARATOR;
        $result = is_writable($dir)?$ok:$ng;
        $this->Assign('temp_webapp', $result);

        $dir = WORK_DIR.'templates_c'.DIRECTORY_SEPARATOR.'mobapp'.DIRECTORY_SEPARATOR;
        $result = is_writable($dir)?$ok:$ng;
        $this->Assign('temp_mobapp', $result);


        $result = is_writable(ERROR_LOG_FILE)?$ok:$ng;
        $this->Assign('error_log_file', $result);

        $result = is_writable(SNS_DB_FILE)?$ok:$ng;
        $this->Assign('sns_db_file', $result);

        $result = is_writable(BLOB_DB_FILE)?$ok:$ng;
        $this->Assign('blob_db_file', $result);

        $result = is_writable(THEME_DIR)?$ok:$ng;
        $this->Assign('theme_dir', $result);
    }
} // webapp


/**
 * データ操作設定・実行
 *
 * @access private
 * @return integer  データ操作結果
 */
function setValue($key)
{
    $const = strtoupper($key);
    echo empty($GLOBALS['value'][$key])?'':$GLOBALS['value'][$key];
}
$webapp = new webapp();
$webapp->execute();
?>
<html lang="ja">
	<head>
		<meta http-equiv="content-type" content='text/html; charset="utf-8"' />
		<title>rktSNSセットアップ</title>
		<link rel="stylesheet" href="./resource/css/common.css" />
		<link rel="stylesheet" href="./resource/css/admin.css" />
        <style media="screen" type="text/css">
        <!--
    	.next {
            font-size:23px;
    		color: blue;
    	}
        -->
    	</style>

	</head>
	<body>
		<!-- start:ヘッダー -->
		<div id="header">
			<div class="left">
				<a href="./"><img src="./resource/img/header/logo.gif" width="163" height="94" alt="{$smarty.const.WAP_SYSTEM_NAME}" /></a>
			</div>
			<div class="left">
				<div class="search"></div>
			</div>
			<div class="right">
				<div class="sponsor">
					<a href="http://rakuto.net/rktSNS/"><img  src="./resource/img/sponsor/ads.gif" width="468" height="60" alt="広告" /></a>
				</div>
				<div id="headerbar">
				</div>
			</div>
		</div>
		<!-- /finish:ヘッダー -->

		<!-- start:メインコンテンツ -->
		<div id="content">
<!-- start:オペレーション領域 -->
<div id="operation">
    <h1>ステップ１</h1>
	<!-- start:丸角 -->
	<div class="round"> 
		<div class="round1"><span></span></div><div class="round2"><span></span></div>
		<div class="round3"></div><div class="round4"></div><div class="round5"></div> 
	</div>
	<div class="round_content">
		<div class="column"><h2>モジュール・アクセス権限</h2></div>
		<!-- start:アクション -->
		<div class="formlist">
			<form name="edit" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
                <input type="hidden" name="page" value="check" />
				<div class="formrow"><strong>PHPモジュールチェック</strong></div>
				<div class="formrow">
					<label class="column">GD：</label>
					<div>
                        <?php echo $GLOBALS['gd']; ?><br />
                        画像処理ドライバでgdを選択する場合に必要です。<br />
                    </div>
				</div>
				<div class="formrow">
					<label class="column">mbstring：</label>
					<div>
                        <?php echo $GLOBALS['mbstring']; ?>
                    </div>
				</div>
				<div class="formrow">
					<label class="column">PDO：</label>
					<div>
                        <?php echo $GLOBALS['pdo']; ?><br />
                        PHP5以降などでSQLite（pdo_sqliteではない）を使用する際に必要な場合があります。<br />
                    </div>
				</div>
				<div class="formrow">
					<label class="column">SQLite：</label>
					<div>
                        <?php echo $GLOBALS['sqlite']; ?>
                    </div>
				</div>
                
				<div class="formrow"><strong>ファイル・ディレクトリの書き込み権限</strong></div>
				<div class="formrow">
					<label class="column">sns_config.php：</label>
					<div>
                        <?php echo $GLOBALS['sns_config']; ?><br />
                        <?php echo BASE_DIR.'sns_config.php'; ?><br />
                    </div>
				</div>
				<div class="formrow">
					<label class="column">PC用templates_c：</label>
					<div>
                        <?php echo $GLOBALS['temp_webapp']; ?><br />
                        <?php echo WORK_DIR.'templates_c'.DIRECTORY_SEPARATOR.'webapp'.DIRECTORY_SEPARATOR; ?><br />
                    </div>
				</div>
				<div class="formrow">
					<label class="column">モバイル用templates_c：</label>
					<div>
                        <?php echo $GLOBALS['temp_mobapp']; ?><br />
                        <?php echo WORK_DIR.'templates_c'.DIRECTORY_SEPARATOR.'mobapp'.DIRECTORY_SEPARATOR; ?><br />
                    </div>
				</div>
				<div class="formrow">
					<label class="column">エラーログファイル：</label>
					<div>
                        <?php echo $GLOBALS['error_log_file']; ?><br />
                        <?php echo ERROR_LOG_FILE; ?><br />
                    </div>
				</div>
				<div class="formrow">
					<label class="column">SNSデータベース：</label>
					<div>
                        <?php echo $GLOBALS['sns_db_file']; ?><br />
                        <?php echo SNS_DB_FILE; ?><br />
                    </div>
				</div>
				<div class="formrow">
					<label class="column">BLOBデータベース：</label>
					<div>
                        <?php echo $GLOBALS['blob_db_file']; ?><br />
                        <?php echo BLOB_DB_FILE; ?><br />
                    </div>
				</div>
				<div class="formrow">
					<label class="column">テーマ保存先：</label>
					<div>
                        <?php echo $GLOBALS['theme_dir']; ?><br />
                        <?php echo THEME_DIR; ?><br />
                    </div>
				</div>

				<div class="formbutton">
                    <a href="<?php echo $_SERVER['PHP_SELF']; ?>?page=config"><strong class="next">ステップ２へ</strong></a>
				</div>
			</form>

		</div>
		<!-- /finish:アクション -->
	</div>
	<div class="round"> 
		<div class="round5"></div><div class="round4"></div><div class="round3"></div> 
		<div class="round2"><span></span></div><div class="round1"><span></span></div>
	</div>
	<!-- /finish:丸角 -->

</div>
<!-- /finish:オペレーション領域 -->
<br />

		</div>
		<!-- /finish:メインコンテンツ -->

		<!-- start:フッター -->
		<div id="footer"></div>
		<!-- /finish:フッター -->
	</body>
</html>