<?php
/* ========================================================================
 - [modules/public/login/reissue.php]
 -      パスワードの再発行
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 -  更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'sendmail.php';
require_once WEBAPP_LIB_DIR.'wap_public.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@stepone.tv>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_public
{
    /**
     * メールアドレス
     * @var string
     */
    var $email = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->setTemplateFile('public/login/reissue.tpl');

        $this->setSafety('email', '_REQUEST', 'email');
        $this->Assign('value', array('email'=>$this->email));
        
        if (empty($_REQUEST['send'])){
            return ;
        }

    	if (!empty($this->email)){
            if ($this->send_mail()){
                $this->Assign('send', true);
            } else {
                $this->Assign('alert', array('alert'=>true));
            }
        } else {
            $this->Assign('alert', array('email'=>true));        
        } // if (!empty($_REQUEST['send']))
    }

    /**
     * パスワードの更新
     *
     * @access private
     * @return integer  データ操作結果
     */
    function update_password($id)
    {
        $password = strtolower(md5(time()));
        $password = substr($password, 9, 6);

        $sql=
            'UPDATE '.
                DB_PREFIX.'act_account '.
            'SET '.
                "password = '".md5($password)."' ".
            'WHERE '.
                'id = '.$id;
        $this->objdb->exec($sql);
        return $password;
    }

    /**
     * メール送信実行
     *
     * @access private
     * @return integer  送信結果
     */
    function send_mail()
    {
        $sql = 
            'SELECT '.
                'act.id as id,'.
                'pro.nickname as nickname,'.
                'act.email as email '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                "act.email_hash = '".md5($this->email)."'";
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        if (empty($result)){
            return false;
        }

        $password = $this->update_password($result['id']);

        $objmail = new sendmail('reissue');
    
        $objmail->Assign('user_name', $result['nickname']);
        $objmail->Assign('password',  $password);

        $crypt = RKT_crypt::getInstance();
        $to = $crypt->decrypt($result['email']);
    
        return $objmail->send($to);
    }
} // webapp
?>
