<?php
/* ========================================================================
 - [modules/public/json/local.php]
 -      市区町村リスト生成
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'PEAR/Services/JSON.php';
require_once WEBAPP_LIB_DIR.'wap_public.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_public
{
    /**
     * ターゲット
     * @var string
     */
    var $target = '';

    /**
     * 都道府県ID
     * @var integer
     */
    var $ref_prefecture = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        /* PathInfo引数の設定 */
        $this->setPathInfo('target', 0, 'string');
        $this->target = ereg('ref_prefecture', $this->target)?'ref_prefecture':'ref_hometown';

        /* URL引数の取得 */
        $this->setSafety('ref_prefecture');
        $this->ref_prefecture = empty($this->ref_prefecture)?1:$this->ref_prefecture;

        $json = new Services_JSON();

        header('Content-Type: text/html; charset=utf-8');
        echo $json->encode($this->get_local());
        exit();
    }

    /**
     * 市区町村情報の取得
     *
     * @access private
     * @return void
     */
    function get_local()
    {
        $sql=
            'SELECT '.
                'id,'.
                'local '.
            'FROM '.
                DB_PREFIX.'ara_local '.
            'WHERE '.
                'ref_prefecture = '.$this->ref_prefecture.' '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        $list[] = array(
                'label'=> '市区町村',
                'value'=> ''
            );

        foreach ($result as $value){
            $list[] = array(
                    'label'=> $value['local'],
                    'value'=> $value['id']
                );
        }
        return $list;
    }
} // webapp
?>
