<?php
/* ========================================================================
 - [modules/private/message/send.php]
 -      メッセージを送る
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * メッセージID
     * @var integer
     */
    var $id = null;

    /**
     * 表示対象アカウントID
     * @var integer
     */
    var $ref_account = 0;

    /**
     * 返信対象メッセージID
     * @var integer
     */
    var $ref_message = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/message/send.tpl');        

        /* URL引数の取得 */
        $this->setSafety('id');
        $this->Assign('id', $this->id);
        $this->setSafety('ref_message');
        $this->Assign('ref_message', $this->ref_message);

        if (!$this->set_account()){
            header('Location: '.HTTP_ACTION.'private/message/list/');
            exit();
        }
                
        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'private/message/send/again/'.WAP_URI_SEPARATOR.'id='.$this->id.'&ref_message='.$this->ref_message);
            exit();
        }

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb,  DB_PREFIX.'fri_message');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->do_send_message();
            $this->update_flag();
            header('Location: '.HTTP_ACTION.'private/message/list/'.$this->objmnp->getValue('status').'/');
            exit();
        } elseif($result == RKT_MANIP_VALIDATED) {
            header('Location: '.HTTP_ACTION.'private/message/send/confirm/'.WAP_URI_SEPARATOR.'id='.$this->id.'&ref_message='.$this->ref_message);
            exit();
        }

        /* 削除 */
        if ($this->delete_message()){
            header('Location: '.HTTP_ACTION.'private/message/list/');
            exit();
        }

        $this->set_profile();
        $this->set_photo();
        $this->set_default_message();
    }

    /**
     * 表示対象アカウントIDの設定
     *
     * @access private
     * @return void
     */
    function set_account()
    {
        if (empty($this->id)){
            $sql=
                'SELECT '.
                    'ref_from as ref_account '.
                'FROM '.
                    DB_PREFIX.'fri_message '.
                'WHERE '.
                    'ref_account = '.$this->account['id'].' AND '.
                    'id = '.$this->ref_message;
        } else {
            $sql=
                'SELECT '.
                    'ref_to as ref_account '.
                'FROM '.
                    DB_PREFIX.'fri_message '.
                'WHERE '.
                    'ref_account = '.$this->account['id'].' AND '.
                    'id = '.$this->id;
        }
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->ref_account = $result['ref_account'];
        
        return !empty($result['ref_account']);
    }

    /**
     * デフォルトメッセージ
     *
     * @access private
     * @return void
     */
    function set_default_message()
    {
        $sql=
            'SELECT '.
                'subject,'.
                'body '.
            'FROM '.
                DB_PREFIX.'fri_message '.
            'WHERE '.
                'ref_account = '.$this->account['id'].' AND '.
                'id = '.$this->ref_message;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $body = '';
        $buff = explode("\r\n",$result['body']);
        foreach ($buff as $line){
            $body .= '&gt; '.$line."\r\n";
        }
        
        $default = array(
            'subject'=> 'Re: '.$result['subject'],
            'body'=> $body,
        );

        $this->Assign('default', $default);
    }

    /**
     * 友達情報の設定
     *
     * @access private
     * @return void
     */
    function set_profile()
    {
        $sql=
            'SELECT '.
                'act.id as id,'.
                'pro.nickname as nickname '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'act.id = '.$this->ref_account;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->Assign('profile', $result);
    }

    /**
     * 写真の設定
     *
     * @access private
     * @return void
     */
    function set_photo()
    {
        $sql=
            'SELECT '.
                'id,'.
                'subject,'.
                'filename as src,'.
                'width,'.
                'height '.
            'FROM '.
                DB_PREFIX.'act_photo '.
            'WHERE '.
                'status = '.STATUS_PHOTO_MAIN.' AND '.
                'ref_account = '.$this->ref_account;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        if (empty($result)){
            $result = array(
                'id'=> null,
                'subject'=> 'no photo',
                'src'=>    'resource/img/common/nophoto.gif',
                'width'=>  PHOTO_LARGE_SIZE,
                'height'=> PHOTO_LARGE_SIZE
            );
        }

        $this->Assign('photo',$result);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        $statuses = array(
            'manip'=> MESSAGE_SENT,
            'draft'=> MESSAGE_DRAFT,
            'validate'=> MESSAGE_DRAFT
        );
        $status = empty($_POST['manip'])?'validate':'manip';
        $status = empty($_POST['draft'])?$status:'draft';

        // 新規登録以外の処理
        if (!empty($this->id)){
            $this->objmnp->setCurID($this->id);
        } else {
            $this->objmnp->setValue('ref_account', $this->account['id']);
            $this->objmnp->setValue('regist_date', date('Y-m-d H:i:s'));
        }

        // 直接入力
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('status', $statuses[$status]);
        $this->objmnp->setValue('ref_to',  $this->ref_account);
        $this->objmnp->setValue('ref_from',$this->account['id']);
        $this->objmnp->setValue('flag', MESSAGE_FLAG_READ);

        // 更新しない項目名
        $skip = array(
            'ref_account',
            'regist_date',
        );
        return $this->objmnp->execute($this,$skip);
    }

    /**
     * メッセージの送信
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_send_message()
    {
        if ($this->objmnp->getValue('status') != MESSAGE_SENT){
            return false;
        }
        $value = array(
            'modify'=> $this->objmnp->getValue('modify'),
            'regist_date'=> $this->objmnp->getValue('regist_date'),
            'ref_account'=> $this->objmnp->getValue('ref_to'),
            'ref_to'=> $this->objmnp->getValue('ref_to'),
            'ref_from'=> $this->objmnp->getValue('ref_from'),
            'subject'=> $this->objmnp->getValue('subject'),
            'body'=> $this->objmnp->getValue('body'),
        );

        $sql =
            'INSERT INTO '.
                DB_PREFIX.'fri_message('.
                    'modify,'.
                    'regist_date,'.
                    'status,'.
                    'ref_account,'.
                    'ref_to,'.
                    'ref_from,'.
                    'flag,'.
                    'subject,'.
                    'body'.
                ') VALUES ('.
                    "'".$value['modify']."',".
                    "'".$value['regist_date']."',".
                    MESSAGE_INBOX.','.
                    $value['ref_account'].','.
                    $value['ref_to'].','.
                    $value['ref_from'].','.
                    MESSAGE_FLAG_UNREAD.','.
                    "'".$value['subject']."',".
                    "'".$value['body']."'".
                ')';
        return $this->objdb->exec($sql);
    }

    /**
     * メッセージフラグの更新
     *
     * @access private
     * @return integer  データ操作結果
     */
    function update_flag()
    {
        $ref_message = $this->objmnp->getValue('ref_message');
        if (empty($ref_message)){
            return false;
        }

        $sql =
            'UPDATE '.
                DB_PREFIX.'fri_message '.
            ' SET '.
                'flag='.MESSAGE_FLAG_RETURN.' '.
            ' WHERE '.
                'ref_account ='.$this->account['id'].' AND '.
                'id = '.$ref_message;
        return $this->objdb->exec($sql);
    }

    /**
     * メッセージの削除
     *
     * @access private
     * @return integer  データ操作結果
     */
    function delete_message()
    {
        if (empty($_GET['delete'])){
            return false;
        }

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'fri_message '.
            'WHERE '.
                'id ='.$this->id .' AND '.
                'ref_account ='.$this->account['id'];
        return $this->objdb->exec($sql);
    }

} // webapp
?>
