<?php
/* ========================================================================
 - [modules/community/bbs/browse.php]
 -      トピック参照
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/28] コメント一覧にユーザー画像追加
 -      [2006/08/27] 非公開＆メンバーではない処理の修正
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'wap_community.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_community
{
    /**
     * トピックID
     * @var integer
     */
    var $id = 0;

    /**
     * コメント削除ID
     * @var integer
     */
    var $delete = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('community/bbs/browse.tpl');
        $this->addJavas('common.js');

        /* PathInfo引数の設定 */
        $this->setPathInfo('id', 1);
        $this->Assign('id', $this->id);
        $this->setSafety('delete');

        /* 非公開でメンバーではない */
        if (!$this->get_visibility()){
            header('Location: '.HTTP_ACTION.'community/bbs/list/'.$this->ref_community.'/');
            exit();
        }

        if ($this->delete_comment()){
            header('Location: '.HTTP_ACTION.'community/bbs/browse/'.$this->ref_community.'/'.$this->id.'/');
            exit();
        }
        
        $this->set_topic();
        $this->set_comment();
        
        $this->entry_button();
    }

    /**
     * 表示の設定
     *
     * @access private
     * @return void
     */
    function get_visibility()
    {
        $visibility = true;
        /* 非公開 */
        if ($this->community['visibility'] == VISIBILITY_HIDDEN){
            $visibility = $this->community['is_member'];
        }
        return $visibility;
    }

    /**
     * トピック一覧の設定
     *
     * @access private
     * @return void
     */
    function set_topic()
    {
        $sql=
            'SELECT '.
                'tpc.id as id,'.
                'tpc.regist_date as regist_date,'.
                'tpc.start_date as start_date,'.
                'tpc.deadline as deadline,'.
                'tpc.start_hour as start_hour,'.
                'tpc.start_minute as start_minute,'.
                'pro.nickname as nickname,'.
                'tpc.ref_account as ref_account,'.
                'tpc.status as status,'.
                'tpc.ref_prefecture as ref_prefecture,'.
                'tpc.sub_locale as sub_locale,'.
                'tpc.topic as topic,'.
                'tpc.comment as comment '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'com_topic tpc '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = tpc.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'tpc.id = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $topic = array(
            'id'=> $result['id'],
            'regist_date'=> $result['regist_date'],
            'start_date'=> $result['start_date'],
            'deadline'=> (ereg('0000',$result['deadline']))?null:$result['deadline'],
            'start_hour'=> $result['start_hour'],
            'start_minute'=> $result['start_minute'],
            'nickname'=> $result['nickname'],
            'ref_account'=> $result['ref_account'],
            'status'=> $result['status'],
            'prefecture'=> $this->get_prefecture($result['ref_prefecture']),
            'sub_locale'=> $result['sub_locale'],
            'topic'=> $result['topic'],
            'comment'=> $result['comment'],
            'pictures'=> $this->get_picture($result['id'],STATUS_PICTURE_TOPIC),
            'count'=> $this->get_comment_num($result['id']),
            'entrys'=> $this->get_entry_num($result['id'])
        );

        $this->Assign('topic', $topic);
    }

    /**
     * 都道府県の取得
     *
     * @access private
     * @param integer $id
     * @return string
     */
    function get_prefecture($id)
    {
        $sql=
            'SELECT '.
                'prefecture '.
            'FROM '.
                DB_PREFIX.'ara_prefecture '.
            'WHERE '.
                'id = '.$id;
        $stmt = $this->objdb->prepare($sql);
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        return $result['prefecture'];
    }

    /**
     * 添付画像の取得
     *
     * @access private
     * @param integer $ref_topic
     * @param integer $status
     * @return mixed
     */
    function get_picture($ref_relation, $status)
    {
        $sql=
            'SELECT '.
                'id,'.
                'filename as href,'.
                'thumbnail as src,'.
                't_width as width,'.
                't_height as height '.
            'FROM '.
                DB_PREFIX.'com_picture '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'status = '.$status.' AND '.
                'ref_relation = '.$ref_relation;
        $stmt = $this->objdb->prepare($sql);
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        return $result;
    }

    /**
     * コメント数の取得
     *
     * @access private
     * @param integer $ref_topic
     * @return integer
     */
    function get_comment_num($ref_topic)
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'com_comment '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_topic = '.$ref_topic;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        return $result['ct'];
    }

    /**
     * 参加数の取得
     *
     * @access private
     * @param integer $ref_topic
     * @return integer
     */
    function get_entry_num($ref_topic)
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'com_entry '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_topic = '.$ref_topic;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        return $result['ct'];
    }

    /**
     * コメント一覧の設定
     *
     * @access private
     * @return void
     */
    function set_comment()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $_SESSION['offset'] = $offset;

        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_COMMENT);    // クラスの生成
        $sql=
            'SELECT '.
                'cmt.id as id,'.
                'pro.nickname as nickname,'.
                'cmt.ref_account as ref_account,'.
                'cmt.regist_date as regist_date,'.
                'cmt.comment as comment,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'com_comment cmt '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = cmt.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'cmt.ref_community = '.$this->ref_community.' AND '.
                'cmt.ref_topic = '.$this->id.' '.
            'ORDER BY '.
                'cmt.regist_date DESC';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();
        if (empty($result)){
            return ;
        }
        $list = array();
        foreach ($result as $value){
            $value['pictures'] = $this->get_picture($value['id'],STATUS_PICTURE_COMMENT);

            $list[] = $value;
        }

        $this->Assign('comment', $list);
    }

    /**
     * イベント参加ボタン
     *
     * @access private
     * @return integer  データ操作結果
     */
    function entry_button()
    {
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'com_entry '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_topic = '.$this->id.' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 

        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
                
        $this->Assign('entry_button', empty($result['id']));
    }

    /**
     * コメントの削除
     *
     * @access private
     * @return boolean  真偽値
     */
    function delete_comment()
    {
        if (empty($this->delete)){
            return false;
        }
        $sql=
            'SELECT '.
                'ref_account '.
            'FROM '.
                DB_PREFIX.'com_comment '.
            'WHERE '.
                'id ='.$this->delete;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        if (!$this->admin){
            if ($result['ref_account'] != $this->account['id']){
                return false;
            }
        } // if (!$this->admin)

        $this->delete_picture();
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'com_comment '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_topic = '.$this->id.' AND '.
                'id ='.$this->delete;
        return $this->objdb->exec($sql);
    }

    /**
     * 添付画像の削除
     *
     * @access public
     * @return boolean
     */
    function delete_picture()
    {
        $sql=
            'SELECT '.
                'id,'.
                'filename,'.
                'thumbnail '.
            'FROM '.
                DB_PREFIX.'com_picture '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'status = '.STATUS_PICTURE_COMMENT.' AND '.
                'ref_relation = '.$this->delete;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        include_once LIB_DIR.'rkt_blob.php';
        $objblb = RKT_blob::getInstance(BLOB_DRIVER,BLOB_PARAM);
        foreach ($result as $value){
            $objblb->unlink($value['filename']);
            $objblb->unlink($value['thumbnail']);
        }

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'com_picture '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'status = '.STATUS_PICTURE_COMMENT.' AND '.
                'ref_relation = '.$this->delete;
        return $this->objdb->exec($sql);
    }
} // webapp
?>
