<?php
/* ========================================================================
 - [modules/admin/design/theme.php]
 -      デザインテーマ編集
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/09/16] 背景色の追加
 -      [2006/08/07] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'PEAR/Archive/Zip.php';
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'wap_admin.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_admin
{
    /**
     * テーマID
     * @var integer
     */
    var $id = null;

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN));

        $this->setTemplateFile('admin/design/theme.tpl');        
        $this->addCss('colorPicker/colorPicker.css');
        $this->addJavas('prototype.js');
        $this->addJavas('scriptaculous/scriptaculous.js');
        $this->addJavas('YUI/yahoo.color.js');
        $this->addJavas('colorPicker/colorPicker.js');

        // URL引数の取得
        $this->setSafety('id');
        $this->Assign('id', $this->id);

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'des_theme');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->id = $this->objmnp->getCurID();
            $this->upload();
            $this->makedir();
            header('Location: '.HTTP_ACTION.'admin/design/list/complete/');
            exit();
        }

        $this->set_color_picker();
    }

    /**
     * 親カテゴリの設定
     *
     * @access private
     * @return void
     */
    function set_color_picker()
    {
        $img = BASE_URL.'resource/js/YUI/img/';

        $init = 
            'Event.observe(window, "load", initHandler);'.
            'function initHandler() {'.
                'new Control.ColorPicker("ccp_round", { IMAGE_BASE : "'.$img.'" });'.
                'new Control.ColorPicker("ccp_box", { IMAGE_BASE : "'.$img.'" });'.
                'new Control.ColorPicker("ccp_border", { IMAGE_BASE : "'.$img.'" });'.
                'new Control.ColorPicker("ccp_text", { IMAGE_BASE : "'.$img.'" });'.
                'new Control.ColorPicker("ccp_column", { IMAGE_BASE : "'.$img.'" });'.
                'new Control.ColorPicker("ccp_button", { IMAGE_BASE : "'.$img.'" });'.
                'new Control.ColorPicker("ccp_focus", { IMAGE_BASE : "'.$img.'" });'.
                'new Control.ColorPicker("ccp_header", { IMAGE_BASE : "'.$img.'" });'.
                'new Control.ColorPicker("ccp_background", { IMAGE_BASE : "'.$img.'" });'.
            '}';
        $this->baseAssign('javascript', $init);
    }

    /**
     * アップロードの処理
     *
     * @access private
     * @return void
     **/
    function makedir()
    {
        if (file_exists(THEME_DIR.$this->id.DIRECTORY_SEPARATOR)){
            return false;
        }
        mkdir(THEME_DIR.$this->id);
    }

    /**
     * アップロードの処理
     *
     * @access private
     * @return void
     **/
    function upload()
    {
        $key = 'zipfile';
        if (!isSet($_FILES[$key])) {
            return false;
        }
        
        /* ファイルの種類がZIPか判定 */
        if (!preg_match("/zip/i", $_FILES[$key]['type'])){
            return false;
        }

        $path = THEME_DIR.$this->id.DIRECTORY_SEPARATOR;
        $path = preg_replace('/\\\/','/',$path);
        $objzip = new Archive_Zip($_FILES[$key]['tmp_name']);
        $objzip->extract(
            array(
                'add_path'=> $path,
            )
        );
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        // 新規登録以外の処理
        if (!empty($this->id)){
            $this->objmnp->setCurID($this->id);
        } else {
            $this->objmnp->setValue('regist_date', date('Y-m-d H:i:s'));
        }

        // 直接入力
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        
        // 更新しない項目名
        $skip = array(
            'regist_date',
        );
        $this->objmnp->catchInput($skip);

        return $this->objmnp->doManip($this);
    }
} // webapp
?>
