<?php
/* ========================================================================
 - [webapp/libs/sql_query.php]
 -      sql_queryクラス
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/24] sql_query::now()を追加 現在の時刻を取得
 -      [2006/07/19] 作成
 - ======================================================================== */

require_once LIB_DIR.'rkt_crypt.php';

/**
 * sql_queryクラス
 *
 * @author 高橋 裕志郎 <yujiro@stepone.tv>
 * @package sql_query
 * @access public
 * @version 1.0
 */
class sql_query
{
    /**
     * コンストラクタ
     *
     * @access public
     */
    function sql_query()
    {
    }

    /**
     * 初期データの復号化
     *
     * @access public
     * @param string $value
     * @return string
     */
    function decrypt($value)
    {
        $crypt = RKT_crypt::getInstance();
        return empty($value)?'':$crypt->decrypt($value);
    }

    /**
     * 入力データの暗号化
     *
     * @access public
     * @param string $value
     * @return string
     */
    function encrypt($value)
    {
        $crypt = RKT_crypt::getInstance();
        return empty($value)?'':$crypt->encrypt($value);
    }

    /**
     * 入力データのhash化
     *
     * @access public
     * @param string $value
     * @return string
     */
    function hash($value)
    {
        return empty($value)?'':md5($value);
    }

    /**
     * 現在の時刻のフォーマット
     *
     * @access public
     * @param string $value
     * @return string
     */
    function now()
    {
        $formats = array(
            'mysql'=>  'now()',
            'sqlite'=> "date('now')",
            'pgsql'=>  'now()',
        );

        return $formats[WAP_DB_DRIVER];
    }

    /**
     * 年齢取得のフォーマット
     *
     * @access public
     * @param string $value
     * @return string
     */
    function age($column)
    {
        $formats = array(
            'mysql'=>  'YEAR(DATE_SUB(now(),INTERVAL to_days('.$column.') DAY))',
            'sqlite'=> "((julianday('now') - julianday(".$column.")) * 0.00273785)",
            'pgsql'=>  "date_part('year', age(".$column."))",
        );

        return $formats[WAP_DB_DRIVER];
    }

    /**
     * 日付型の方法
     *
     * @access public
     * @param string $value
     * @return string
     */
    function toDate($column)
    {
        $formats = array(
            'mysql'=>  "DATE_FORMAT(".$column.",'%Y-%m-%d')",
            'sqlite'=> 'date('.$column.')',
            'pgsql'=>  "to_char(".$column.",'YYYY-MM-DD')",
        );

        return $formats[WAP_DB_DRIVER];
    }

    /**
     * 日付フォーマットの方法
     *
     * $format の変換指定子は strftime() 関数を参照
     *
     * @access public
     * @param string $column
     * @param string $format
     * @return string
     */
    function dateFormat($column,$format)
    {
        $func = array('sql_query', '__format_'.WAP_DB_DRIVER);
        $format = call_user_func($func, $format);

        $formats = array(
            'mysql'=>  "DATE_FORMAT(".$column.",'".$format."')",
            'sqlite'=> "strftime('".$format."', ".$column.")",
            'pgsql'=>  "to_char(".$column.", ".$format.")",
        );

        return $formats[WAP_DB_DRIVER];
    }

    /**
     * 入力データのhash化
     *
     * @access public
     * @param string $value
     * @return string
     */
    function getAge($date)
    {
        if (empty($date)){
            return $date;
        }
        include_once LIB_DIR.'rkt_calendar.php';

        $dates = RKT_calendar::splitDate($date);
        $dates['year']  = intval($dates['year']);
        $dates['month'] = intval($dates['month']);
        $dates['day']   = intval($dates['day']);

        $year   = intval(date('Y'));
        $now_md = intval(date('md'));

        $born_md = sprintf('%d%02d',$dates['month'], $dates['day']);
        $born_md = intval($born_md);

        $age = $year - $dates['year'];
        $age = ($now_md >= $born_md)?$age:$age-1;

        return $age;
    }

    /**
     * 日付フォーマットをMySql用に変換
     *
     * @access private
     * @param string $format
     * @return string
     */
    function __format_mysql($format)
    {
        $format = preg_replace('/%M/','%i', $format);
        return $format;
    }

    /**
     * 日付フォーマットをSQLite用に変換
     *
     * @access private
     * @param string $format
     * @return string
     */
    function __format_sqlite($format)
    {
        return $format;
    }

    /**
     * 日付フォーマットをPosqgreSQL用に変換
     *
     * @access private
     * @param string $format
     * @return string
     */
    function __format_pgsql($format)
    {
        $format = preg_replace('/%Y/','YYYY', $format);
        $format = preg_replace('/%m/','MM', $format);
        $format = preg_replace('/%d/','DD', $format);

        $format = preg_replace('/%H/','HH24', $format);
        $format = preg_replace('/%M/','MI', $format);
        $format = preg_replace('/%S/','SS', $format);

        return $format;
    }
}
// sql_queryの終了
?>
