<?php
/* ========================================================================
 - [modules/private/show/calendar.php]
 -      カレンダー
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * タイプ
     * @var integer
     */
    var $type = 0;

    /**
     * オフセットの復活
     * @var integer
     */
    var $back = 0;

    /**
     * 誕生日格納用
     * @var array
     */
    var $birthdays = array();

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/show/calendar.tpl');

        /* PathInfo引数の設定 */
        $this->setPathInfo('type');
        $this->type = empty($this->type)?1:$this->type; 
        $this->Assign('type', $this->type);

        $this->setSafety('back');
        
        $titles = array(
            1=> 'スケジュール',
            2=> 'イベント',
            3=> '誕生日',
        );
        $this->Assign('main_title', $titles[$this->type]);


        if ($this->type == 1){        
            $this->set_schedule();
        } elseif ($this->type == 2){
            $this->set_event();
        } else {
            $this->birthdays = array();
            $this->set_birthday();

            $this->Assign('list', $this->birthdays);
        }        
    }

    /**
     * スケジュールリストの設定
     *
     * @access private
     * @return void
     **/
    function set_schedule()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        if (!empty($this->back)){
            $offset = $_SESSION['offset'];
        }
        $_SESSION['offset'] = $offset;

        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_ROWS);    // クラスの生成
        $now  = sql_query::now();
        $sql = 
            'SELECT '.
                'id,'.
                'start_date as date,'.
                'end_date,'.
                'schedule,'.
                'comment '.
            'FROM '.
                DB_PREFIX.'cal_schedule '.
            'WHERE '.
                'ref_account = '.$this->account['id'].' AND '.
                'end_date >= '.$now.' '.
            'ORDER BY '.
                'start_date';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();
        $this->Assign('list', $result);
    }

    /**
     * イベントリストの設定
     *
     * @access private
     * @return void
     **/
    function set_event()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        if (!empty($this->back)){
            $offset = $_SESSION['offset'];
        }
        $_SESSION['offset'] = $offset;

        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_ROWS);    // クラスの生成

        $now  = sql_query::now();
        $sql=
            'SELECT '.
                'tpc.id as id,'.
                'tpc.ref_community as ref_community,'.
                'tpc.topic as topic,'.
                'tpc.start_date as date '.
            'FROM '.
                DB_PREFIX.'com_names nam,'.
                DB_PREFIX.'com_topic tpc '.
            'WHERE '.
                'nam.ref_community = tpc.ref_community AND '.
                'tpc.status = '.STATUS_TOPIC_EVENT.' AND '.
                'nam.ref_account = '.$this->account['id'].' AND '.
                '(nam.status = '.STATUS_COMMUNITY_ADMIN.' OR '.
                 'nam.status = '.STATUS_COMMUNITY_MEMBER.' OR '.
                 'nam.status = '.STATUS_COMMUNITY_CHANGE.') AND '.
                'tpc.start_date >= '.$now.' '.
            'ORDER BY '.
                'tpc.start_date';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();
        $this->Assign('list', $result);
    }

    /**
     * 誕生日リストの設定
     *
     * @access private
     * @return void
     **/
    function set_birthday()
    {
        $month = date('m');
        $next = intval($month);
        $next = ($next == 12)?'01':sprintf('%02d',$next+1);
        $month_format = sql_query::dateFormat('pro.birthday','%m'); 
        $sql=
            'SELECT '.
                'act.id as id,'.
                'pro.nickname as nickname,'.
                'pro.birthday as date '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'fri_friends fri '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = fri.ref_friend AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'fri.avail = '.AVAIL_ENABLE.' AND '.
                'fri.status = '.STATUS_FRIEND_CONNECT.' AND '.
                'fri.ref_account = '.$this->account['id'] .' AND '.
                '('.
                    $month_format." = '".$month."' OR ".
                    $month_format." = '".$next."' ".
                ')'.
            'ORDER BY '.
                'pro.birthday';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        if (empty($result)){
            return ;
        }

        foreach ($result as $value){
            $this->birthdays[] = $value;
        }

        $page = array(
            'infos'=> array('cur_page'=>1,'max_page'=>1),
            'links'=>  array()
        );
        $this->Assign('page', $page);
    }
} // webapp
?>
