<?php
/* ========================================================================
 - [modules/private/home/invite.php]
 -      友達を紹介フォーム
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/29] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'sendmail.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * 友達ID
     * @var object
     */
    var $id = null;

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/home/invite.tpl');

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'private/home/invite/'.$this->sid.'/again/');
            exit();
        }

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb,  DB_PREFIX.'fri_friends');
        $result = $this->do_query();

        if ($result == RKT_MANIP_COMPLETE){
            $this->invitation_mail();
            header('Location: '.HTTP_ACTION.'private/home/invite/'.$this->sid.'/complete/');
            exit();
        } elseif($result == RKT_MANIP_VALIDATED) {
            header('Location: '.HTTP_ACTION.'private/home/invite/'.$this->sid.'/confirm/');
            exit();
        }
    }

    /**
     * 入力されたメールの人が会員か？
     *
     * @access private
     * @return boolean 正常時：真
     */
    function is_member()
    {
        if (empty($_POST['email'])){
            return false;
        }

        $email_hash = sql_query::hash(@$_POST['email']);
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'act_account '.
            'WHERE '.
                'avail = '.AVAIL_ENABLE.' AND '.
                "email_hash = '".$email_hash."'";
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        return !empty($result['ct']);
    }

    /**
     * IDの取得と設定
     *
     * @access private
     * @return void
     */
    function get_curid()
    {
        if (empty($_SESSION[DB_PREFIX.'fri_friends']['email'])){
            return 0;
        }
        $email_hash = sql_query::hash($_SESSION[DB_PREFIX.'fri_friends']['email']);
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'fri_friends '.
            'WHERE '.
                'avail = '.AVAIL_ENABLE.' AND '.
                'ref_account = '.$this->account['id'].' AND '.
                "email_hash ='".$email_hash."'";
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        return empty($result['id'])?null:$result['id'];
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        /* 直接入力 */
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('avail', AVAIL_ENABLE);
        $this->objmnp->setValue('status', STATUS_FRIEND_INVITE);
        $this->objmnp->setValue('invite', 0);
        $this->objmnp->setValue('ref_account', $this->account['id']);

        $is_manip  = preg_match('/manip/',$_SERVER['REQUEST_URI']);
        if (empty($is_manip)){
            // メールの人が会員か？
            if ($this->is_member()){
                $this->objmnp->setAlert('member');
            }
            /* 招待メール */
            $this->objmnp->setInput('email', array('type'=>'email', 'required'=>true));

        } else {
            $this->objmnp->setCurID($this->get_curid());
        } // if (empty($is_manip))


        /* 入力データの加工設定 */
        $func = array('sql_query', 'hash');
        $this->objmnp->setInputEffect('email_hash', array('func'=>$func, 'key'=>'email'));

        $func = array('sql_query', 'encrypt');
        $this->objmnp->setInputEffect('email', array('func'=>$func));

        // 更新しない項目名
        $skip = array(
            'ref_friend',
            'email_hash',
            'ref_community',
        );
        return $this->objmnp->execute($this,$skip);
    }

    /**
     * メール本文の作成・取得
     *
     * @access private
     * @return void
     */
    function invitation_mail()
    {
        $crypt = RKT_crypt::getInstance();
        $id = $this->objmnp->getCurID();
        $sql=
            'SELECT '.
                'act.first_name as first_name,'.
                'act.second_name as second_name,'.
                'fri.email as email,'.
                'fri.comment as comment '.
            'FROM '.
                DB_PREFIX.'act_profile act,'.
                DB_PREFIX.'fri_friends fri '.
            'WHERE '.
                'fri.id = '.$id. ' AND '.
                'fri.avail = '.AVAIL_ENABLE.' AND '.
                'act.ref_account = '.$this->account['id'] . ' AND '.
                'fri.ref_account = act.ref_account';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $second_name = $crypt->decrypt($result['second_name']);
        $first_name  = $crypt->decrypt($result['first_name']);
        
        $name= trim($second_name).' '.trim($first_name);
        
        $to = $crypt->decrypt($result['email']);
    	$subject = $name.'さんから'.WAP_SYSTEM_NAME.'の招待状が届いています';

    	$seed = md5($this->account['id'].RKT_SEED);
        $seed = substr($seed,4,6);
    	$key  = md5($seed.$to.RKT_SEED);
    	$url  = SSL_ACTION.'public/registry/account/'.$id.'/'.$seed.'/'.$key.'/';


        $objmail = new sendmail('invitation');
        
        $objmail->Assign('user_name', $name);
        $objmail->Assign('email', $to);
        $objmail->Assign('url',   $url);
        $objmail->Assign('comment', $result['comment']);
        
        $res = $objmail->send($to, $subject);
    }
} // webapp
?>
