<?php
/* ========================================================================
 - [libs/rkt_db.php]
 -      データベース接続
 -      Copyright (c) 2003-2006 Yujiro Takahashi
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/
 - 更新履歴：
 -      [2006/09/05] RKT_db::explodeQuery()のエラーを修正
 -      [2006/08/20] RKT_db::getInstance()の名前を統一 {以前Instance()}
 -      [2005/01/21] RKT_db::parseSql() EXPLAINに対応
 -      [2005/01/08] PDO用に大幅修正（下位互換なし）
 -      [2004/02/20] headerの出力エラーを解消
 -      [2003/12/18] version 0.1
 -      [2003/12/10] 作成
 - ======================================================================== */

require_once LIB_DIR.'rktPDO/rkt_pdo.php';

/**
 * データベースクラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_db
 * @access public
 * @version 2.0.05.1.21
 */
class RKT_db
{
    /**
     * DB接続オブジェクト
     * @access private
     * @var object
     */
    var $dbh;
    
    /**
     * インスタンス生成　現在の接続を返す
     *
     * @access public
     * @return object
     */
    function &getInstance($dsn=RKT_DSN)
    {
        static $__singleton;
        
        if (empty($__singleton)) {
            $objdb = new RKT_db($dsn);
            $__singleton = $objdb->getDbHandle();

            if (RKT_DB_DRIVER == 'sqlite'){
                $__singleton->beginTransaction();
            }
			register_shutdown_function(array('RKT_db', 'shutDown'));
        }
        return $__singleton;
    }

    /**
     * コンストラクタ
     *
     * @access public
     * @return void
     */
    function RKT_db($dsn=RKT_DSN)
    {
        /* PDO データベースハンドルの生成 */
        $this->dbh = RKT_pdo::factory($dsn, RKT_DB_USER, RKT_DB_PASSWD);

        /* エラーモードの設定（例外処理を有効） */
        $this->dbh->setAttribute(PDO_ATTR_ERRMODE, PDO_ERRMODE_EXCEPTION);

        if (RKT_DB_DRIVER == 'sqlite'){
            $this->dbh->beginTransaction();
        }
    }

    /**
     * シャットダウンファンクション
     *
     * @access public
     * @return void
     */
    function shutDown()
    {
        if (RKT_DB_DRIVER != 'sqlite'){
            return ;
        }
        $objdb = RKT_db::getInstance();
        $objdb->commit();
    }

    /**
     * メンバ変数DB接続ハンドルの吐き出し
     *
     * @access public
     * @return object DB接続ハンドル
     */
    function &getDbHandle()
    {
        return $this->dbh;
    }

    /**
     * SELECT句のSQL文を解析する
     *
     * @access public
     * @param string $query クエリ文字列
     * @return array
     */
    function parseSql($sql)
    {
        $parse_sql = array();
        $sql = preg_replace( "/;/i", "", $sql, 1);
        $sql = preg_replace( "/EXPLAIN/i", "\$parse_sql['explain']=1;", $sql, 1);
        $sql = preg_replace( "/SELECT/i", "\$parse_sql['field']=\"", $sql, 1);
        $sql = preg_replace( "/FROM/i", "\";\$parse_sql['table']=\"", $sql, 1);
        $sql = preg_replace( "/WHERE/i", "\";\$parse_sql['where']=\"", $sql, 1);
        $sql = preg_replace( "/ORDER BY/i", "\";\$parse_sql['order']=\"", $sql, 1);
        $sql = preg_replace( "/GROUP BY/i", "\";\$parse_sql['group']=\"", $sql, 1);
        $sql = preg_replace( "/LIMIT/i", "\";\$parse_sql['limit']=\"", $sql, 1);
        $sql = preg_replace( "/OFFSET/i", "\";\$parse_sql['offset']=\"", $sql, 1);
        $sql = preg_replace( "/PRAGMA/i", "\$parse_sql['pragma']=\"", $sql, 1);
        $sql .= "\";";

        @eval($sql);
        
        return $parse_sql;
    }

    /**
     * 操作系のクエリ内容か判定
     *
     * @access public
     * @param string $query クエリ文字列
     * @return boolean
     */
    function isManip($query)
    {
        $manips = 'CREATE|DROP|INSERT|UPDATE|DELETE|'.
                  'ROLLBACK|COPY|VACUUM|REPLACE|'.
                  'ATTACH|DETACH|CONFLICT';
        if (preg_match('/'.$manips.'/is', $query)) {
            return true;
        }
        return false;
    }

    /**
     * SQLite用にクエリを解析し配列を返す
     *
     * @access public
     * @param string $query クエリ文字列
     * @return array 解析結果の配列
     */
    function explodeQuery($query)
    {
        $manips = 'CREATE|DROP|INSERT|UPDATE|DELETE|'.
                  'ROLLBACK|COPY|VACUUM|REPLACE|'.
                  'ATTACH|DETACH|CONFLICT';
        $query = preg_replace('/--.+\n/i', '', $query);
        $query = preg_replace('/\/\*.+\*\//is', '', $query);
        $query = preg_replace('/\\\"/i', '%dqt%', $query);
        $func = array('RKT_db','__remove_semicolon');
        $query = preg_replace_callback('/".+"/is', $func, $query);

        $querys = explode(';', $query);
        $is_trigger = false;
        $result = array();
        $count = count($querys);
    
        for ($row=0; $row<$count; $row++){
            $query = trim($querys[$row]);
            if ($is_trigger){       // トリガークエリ
                if (preg_match('/END/i', $query)){
                    $trigger .= $query.';';
                    $is_trigger = false;
                    $trigger = preg_replace('/(%dqt%)/i', '\"', $trigger);
                    $result[] = preg_replace('/%semi%/i', ';', $trigger);
                } else {
                    $trigger .= $query.';';
                }
            } else {                // 通常のクエリ
                if (preg_match('/CREATE TRIGGER/i', $query)){
                    $is_trigger = true;
                    $trigger = $query.';';
                } else if (!preg_match('/^(BEGIN|END|COMMIT)\s/i', $query)
                    && preg_match('/'.$manips.'/i', $query)){
                    $temp = preg_replace('/(%dqt%)/i', '\"', $query);
                    $result[] = preg_replace('/%semi%/i', ';', $temp);
                }
            } // if ($is_trigger)
        } // for ($row=0; $row<$count; $row++)

        return ($result);
    }

    /**
     * ファイルからクエリを読み込んで実行する
     *
     * @access public
     * @param string $filename ファイル名
     * @return array 実行結果情報
     */
    function readQuery($filename)
    {
        /* ファイルの読み込み */
        $fp = @fopen($filename, 'r');
        if (!$fp){
            return '';
        }
        $query = '';
        $fsize = @filesize($filename);
        if ($fsize) {
            $query = fread($fp, $fsize);
        } else {
            while (!feof($fp)){
                $query .= fread($fp, 1024);
            }
        }
        fclose($fp);

        /* クエリを解析し配列に */
        $objdb = RKT_db::getInstance();
        $querys = RKT_db::explodeQuery($query);

        /* クエリを配列毎に実行 */
        $count = 0;
        $affected = 0;
        $message = '';
        foreach ($querys as $query){
            $result = $objdb->query($query);
            $count += 1;
        } // foreach ($querys as $query)

        $results = array();
        $results['count'] = count($querys);

        return ($results);
    }

    /**
     * セミコロンを置き換える(preg_replace_callback)
     *
     * @access private
     * @param string $matches マッチ文字の格納配列
     * @return string 置き換えた文字
     */
    function __remove_semicolon($matches)
    {
        return preg_replace("/;/", '%semi%', $matches[0]);
    }
} // RKT_dbの終了
?>