<?php
/**
 * Smarty plugin
 * @package Smarty
 * @subpackage plugins
 */


/**
 * Smarty {rkt_hidden} function plugin
 *
 * Type:     function<br>
 * Name:     rkt_hidden<br>
 * Date:     Aug 31, 2006<br>
 * Purpose:  make an pager links from an array of data<br>
 * Input:<br>
 *         - links = array of link data
 *         - request = string of request data
 *         - separator = string of separator
 *
 *
 * Examples:
 * <pre>
 * {rkt_hidden values=$values}
 * </pre>
 * @author   Yujiro Takahashi <yujiro@rakuto.net>
 * @version  1.0
 * @link none
 * @param array
 * @param Smarty
 * @return string
 */
function smarty_function_rkt_hidden($params, &$smarty)
{
    extract($params);

    $result = array();
    foreach ($values as $name=>$value){
        if (is_array($values)){
            rkt_hidden_array($result, $value, $name);
        } else {
            $result[] = '<input type="hidden" name="'.$name.'" value="'.$value.'" />'."\r\n";
        }
    }

    return implode('',$result);
}

/**
 * ݂̃y[WHTML ̐
 *
 * @access private
 * @param mix $value
 * @param string $name
 * @return string
 */
function rkt_hidden_array(&$result,$value,$name)
{
    if (!is_array($value)){
        $result[] = '<input type="hidden" name="'.$name.'" value="'.$value.'" />'."\r\n";
        return ;
    }

    foreach ($value as $key=>$row){
        $key = $name.'['.$key.']';
        rkt_hidden_array($result, $row, $key);
    }
}
/* vim: set expandtab: */

?>
