<?php
/* ========================================================================
 - [execute/dia_rss.php]
 -      RSSリーダークラス
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/29] 設定ファイル名の変更に伴う修正
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
define('EXECUTE_DIR', dirname(__FILE__) . DIRECTORY_SEPARATOR);

/* =-=- モジュール等の読み込み -=-= */
require_once EXECUTE_DIR.'../sns_config.php';
require_once LIB_DIR.'PEAR/XML/RSS.php';
require_once LIB_DIR.'rkt_db.php';

/**
 * RSSリーダークラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package dia_rss
 * @access public
 * @version 1.1
 */
class dia_rss
{
    /**
     * DB接続オジェクト
     * @var object
     */
    var $objdb = null;

    /**
     * コンストラクタ
     *
     * @access public
     */
    function dia_rss()
    {
        $this->objdb = RKT_db::getInstance();
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $sql=
            'SELECT '.
                'id,'.
                'ref_account,'.
                'visibility,'.
                'rss '.
            'FROM '.
                DB_PREFIX.'dia_diary '.
            'WHERE '.
                "rss != '' AND ".
                'visibility != '.VISIBILITY_HIDDEN.' ';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        
        while ($result = $stmt->fetch(PDO_FETCH_ASSOC)){
            $this->read_rss($result);
        }
    }

    /**
     * RSSの読み込み
     *
     * @access public
     * @pram array $diary
     * @return void
     **/
    function read_rss($diary)
    {
        $objrss =& new XML_RSS($diary['rss']);
        $objrss->parse();      // ファイルのパース処理

        $modify = date('Y-m-d H:i:s');
        foreach ($objrss->getItems() as $item){
            $timestamp = empty($item['dc:date'])?$item['pubdate']:@$item['dc:date'];
            $subject = mb_convert_encoding($item['title'], ENCODE_TYPE, 'auto');
            $body = strip_tags($item['description']);
            $body = mb_convert_encoding($body, ENCODE_TYPE, 'auto');
            
            $values = array(
                'modify'=>      $modify,
                'ref_diary'=>   $diary['id'],
                'regist_date'=> date('Y-m-d H:i:s',strtotime($timestamp)),
                'ref_account'=> $diary['ref_account'],
                'visibility'=>  $diary['visibility'],
                'link'=>        $this->objdb->quote($item['link']),
                'subject'=>     $this->objdb->quote($subject),
                'body'=>        $this->objdb->quote($body),
            );
            $this->__insert($values);
        }
    }

    /**
     * 挿入処理
     *
     * @access private
     * @param array $values
     * @return boolean
     */
    function __insert($values)
    {
        $sql = 
            'INSERT INTO '.
                DB_PREFIX.'dia_entry ('.
                    'modify,'.
                    'ref_diary,'.
                    'regist_date,'.
                    'ref_account,'.
                    'visibility,'.
                    'link,'.
                    'subject,'.
                    'body'.
                ') VALUES ('.
                    "'".$values['modify']."',".
                    $values['ref_diary'].','.
                    "'".$values['regist_date']."',".
                    $values['ref_account'].','.
                    $values['visibility'].','.
                    "'".$values['link']."',".
                    "'".$values['subject']."',".
                    "'".$values['body']."'".
                ')';
        return $this->objdb->exec($sql);
    }
}
// dia_rssの終了

$objrsr = new dia_rss();
$objrsr->execute();
?>
