<?php
/* ========================================================================
 - [execute/dia_rss.php]
 -      日記メール投稿
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/26] 作成
 - ======================================================================== */

define('EXECUTE_DIR', dirname(__FILE__) . DIRECTORY_SEPARATOR);

/* =-=- モジュール等の読み込み -=-= */
require_once EXECUTE_DIR.'../sns_config.php';
require_once LIB_DIR.'PEAR/Net/POP3.php';
require_once LIB_DIR.'PEAR/Mail/mimeDecode.php';
require_once LIB_DIR.'rkt_db.php';
require_once LIB_DIR.'rkt_blob.php';
require_once LIB_DIR.'rkt_image.php';
require_once LIB_DIR.'rkt_validate.php';

/**
 * dia_importクラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package enty_import
 * @access public
 * @version 1.0
 */
class dia_import
{
    /**
     * 記事ID
     * @var integer
     */
    var $ref_entry = 0;

    /**
     * 日記情報
     * @var array
     */
    var $diary = array();

    /**
     * 携帯アドレス
     * @var string
     */
    var $cellular = '';

    /**
     * 件名
     * @var string
     */
    var $subject = '';

    /**
     * 本文
     * @var string
     */
    var $body = '';

    /**
     * 添付ファイルの種類
     * @var string
     */
    var $attach_format = '';

    /**
     * 添付ファイル
     * @var binary
     */
    var $attach = null;

    /**
     * DB接続オジェクト
     * @var object
     */
    var $objdb = null;

    /**
     * ファイルオジェクト
     * @var object
     */
    var $objfile = null;

    /**
     * 画像処理オジェクト
     * @var object
     */
    var $objimg = null;

    /**
     * コンストラクタ
     *
     * @access public
     */
    function dia_import()
    {
        $this->objdb = RKT_db::getInstance();
        $this->objfile = new RKT_blob(); 
        $this->objimg = RKT_image::factory(IMAGE_DRIVER);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        if (POP3_HOST != ''){
    		$this->read_pop3();
        }
        if (MAIL_BOX_DIR != ''){
            $this->read_mailbox(MAIL_BOX_DIR);
        }
    }

    /**
     * メールボックスからの読み込み
     *
     * @access private
     * @param string $dir
     * @return void
     **/
    function read_mailbox($dir)
    {
        if (!is_dir($dir)){
            return false;
        }
    
        $files = array();
        $handle  = opendir($dir);
        if (!is_resource($handle)) {
            return false;
        }

        while (false !== ($file = readdir($handle))) {
            if ($file != '.' && $file != '..') {
                $files[] = $file;
            }
        } // while (false !== ($filename = readdir($dh)))
        closedir($handle);

        foreach ($files as $file){
            if (!is_dir($dir.$file)){
                $this->attach = array();
                $this->attach_format = array();

    	        // メール中身を取得
           		ob_start();
                @readfile($dir.$file);
		        $msg = ob_get_contents();
		        ob_end_clean();

    	        // メールソースの解析
    			$this->parse($msg);
    			if ($this->set_diary()) {
        			if ($this->manip()){
                        unlink($dir.$file);
                    }
                } else {
                    unlink($dir.$file);
                }

                unset($this->attach);
                unset($this->attach_format);
            }
	    } // foreach ($files as $file)
    }

    /**
     * POP3からの読み込み
     *
     * @access private
     * @return boolean
     */
    function read_pop3()
    {
	    $pop3 =& new Net_POP3();		// オブジェクトの作成
	    $pop3->connect(POP3_HOST);		// 接続

	    /* ログイン */
	    $result = $pop3->login(POP3_ACCOUNT,POP3_PASSWORD,true);
		if (PEAR::isError($result)){
	        $pop3->disconnect();    /* POP3との接続を終了 */
	        return false;
	    }

	    $num = $pop3->numMsg();             // メッセージ数の取得
	    for ($row=1;$row<=$num;$row++){
            $this->attach = array();
            $this->attach_format = array();

	        //メールソースの解析
			$msg = $pop3->getMsg($row);
			$this->parse($msg);
			if ($this->set_diary()) {
    			if ($this->manip()) {
                    $pop3->deleteMsg($row);     // メッセージの削除
                }
            } else {
                $pop3->deleteMsg($row);     // メッセージの削除
            }

            unset($this->attach);
            unset($this->attach_format);
	    } // for ($row=1;$row<=$num;$row++)

	    /* POP3との接続を終了 */
	    $pop3->disconnect();

	    return true;
    }

    /**
     * メールメッセージの解析
     *
     * @access private
     * @return boolean
     */
    function parse($msg)
    {
		$params = array(
			'include_bodies'=> true,
			'decode_bodies'=>  true,
			'decode_headers'=> true,
		);

        $objdcdr = new Mail_mimeDecode($msg);
        $objmail = $objdcdr->decode($params);

		$this->cellular = $objmail->headers['return-path'];
		$this->cellular = preg_replace('/<|>/i', '', $this->cellular);
		$this->subject  = mb_convert_encoding($objmail->headers['subject'], ENCODE_TYPE, 'ISO-2022-JP');
        $this->body     = '';

	    /* 添付ファイルがある場合 */
	    $num = count($objmail->parts);
	    for ($row=0;$row<$num;$row++){
	        if ($objmail->parts[$row]->ctype_primary == 'text'){
	            $this->body .= mb_convert_encoding($objmail->parts[$row]->body, ENCODE_TYPE, 'ISO-2022-JP');
	        } elseif ($objmail->parts[$row]->ctype_primary == 'image'){
				$this->attach[] = $objmail->parts[$row]->body;
                $this->attach_format[] = $this->shape_format($objmail->parts[$row]->ctype_secondary);
	        }
	    } // for ($row=0;$row<$num;$row++)

	    /* 添付ファイルがない場合 */
	    if (!$num){
	        if ($objmail->ctype_primary == 'text'){
	            $this->body .= mb_convert_encoding($objmail->body, ENCODE_TYPE, 'ISO-2022-JP');
	        } else if ($objmail->ctype_primary == 'image'){
				$this->attach[] = $objmail->body;
                $this->attach_format[] = $this->shape_format($objmail->ctype_secondary);
	        }
	    } // if (!$num)
    }

    /**
     * フォーマットの整形
     *
     * @access private
     * @param string $format
     * @return integer  データ操作結果
     */
    function shape_format($format)
    {
        $format = strtolower($format);
        return preg_replace('/jpeg/i', 'jpg', $format);
    }

    /**
     * 日記情報の設定
     *
     * @access private
     * @return boolean
     */
    function set_diary()
    {
		if (!RKT_validate::email($this->cellular)){
			return false;
		}
        $sql=
            'SELECT '.
                'act.id as ref_account,'.
                'dia.id as id,'.
                'dia.id as visibility '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'dia_diary dia '.
            'WHERE '.
                'act.id = dia.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
				"act.cellular_hash='".md5($this->cellular)."'";
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $this->diary = $stmt->fetch(PDO_FETCH_ASSOC);
        if (empty($this->diary['ref_account'])){
            return false;
        }
        return true;
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return boolean
     */
	function manip()
	{
        $this->ref_entry = 0;
        $now = date('Y-m-d H:i:s');
        $sql = 
            'INSERT INTO '.
                DB_PREFIX.'dia_entry('.
                    'modify,'.
                    'ref_diary,'.
                    'regist_date,'.
                    'ref_account,'.
                    'visibility,'.
                    'link,'.
                    'subject,'.
                    'body'.
                ') VALUES ('.
                    "'".$now."',".
                    $this->diary['id'].','.
                    "'".$now."',".
                    $this->diary['ref_account'].','.
                    "'".$this->diary['visibility']."',".
                    'NULL,'.
                    "'".$this->objdb->quote(strip_tags($this->subject))."',".
                    "'".$this->objdb->quote(strip_tags($this->body))."'".
                ')';
        $result = $this->objdb->exec($sql);
        if ($result > 0){
            $this->ref_entry = $this->objdb->lastInsertId();
        }
		if (empty($this->ref_entry)){
            return false;
        }
        $this->objfile->setUID($this->diary['ref_account']);

		$maxrow = count($this->attach_format);
		for ($row=0; $row<$maxrow; $row++) {
            $this->save_picture($row);
		}
        return true;
	}

    /**
     * 画像の保存処理
     *
     * @access public
     * @param integer $row
     * @return boolean
     */
    function save_picture($row)
    {
        $dir = ARCHIVES_MEMBER_PATH.$this->diary['ref_account'].'/';
        $temp = md5($this->diary['ref_account'].time());
        $filename = substr($temp, rand(0,25), 6);
        $filename = $filename.'.'.$this->attach_format[$row];

        $large_name = $dir.'large/'.$filename;
        $small_name = $dir.'small/'.$filename;

        /* 大きいサイズの画像 */
        $this->objimg->setBinary($this->attach[$row], $this->attach_format[$row]);
        $this->objimg->resize(PHOTO_MAX_SIZE, PHOTO_MAX_SIZE);
        $large = $this->objimg->getInfo();

        $this->objfile->setBuffer($this->objimg->getBinary());
        $this->objfile->save(DOCUMENT_DIR.$large_name);

        /* 小さいサイズの画像 */
        $this->objimg->setBinary($this->attach[$row], $this->attach_format[$row]);
        $this->objimg->resize(PHOTO_SMALL_SIZE, PHOTO_SMALL_SIZE);
        $small = $this->objimg->getInfo();

        $this->objfile->setBuffer($this->objimg->getBinary());
        $this->objfile->save(DOCUMENT_DIR.$small_name);

        $values = array(
            'title'=>       $filename,
            'filename'=>    $large_name,
            'width'=>       $large['width'],
            'height'=>      $large['height'],
            'thumbnail'=>   $small_name,
            't_width'=>     $small['width'],
            't_height'=>    $small['height'],
        );

        $this->insert_picture($values);

        return true;
    }

    /**
     * 添付画像を新規登録
     *
     * @access private
     * @param array $values
     * @return boolean  真偽値
     */
    function insert_picture($values)
    {
        $sql =
            'INSERT INTO '.
                DB_PREFIX.'dia_picture('.
                    'modify,'.
                    'ref_entry,'.
                    'ref_account,'.
                    'title,'.
                    'filename,'.
                    'width,'.
                    'height,'.
                    'thumbnail,'.
                    't_width,'.
                    't_height'.
                ') VALUES ('.
                    "'".date('Y-m-d H:i:s')."',".
                    $this->ref_entry.','.
                    $this->diary['ref_account'].','.
                    "'".$values['title']."',".
                    "'".$values['filename']."',".
                    $values['width'].','.
                    $values['height'].','.
                    "'".$values['thumbnail']."',".
                    $values['t_width'].','.
                    $values['t_height'].
                ')';
        return $this->objdb->exec($sql);
    }

} // dia_import

$objimp = new dia_import();
$objimp->execute();
?>
