<?php
/* ========================================================================
 - [execute/act_daily.php]
 -      日次処理：デイリー配信
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/09/26] wap_config.php読み込み追加
 -      [2006/08/29] 設定ファイル名の変更に伴う修正
 -      [2006/08/20] 作成
 - ======================================================================== */

define('EXECUTE_DIR', dirname(__FILE__) . DIRECTORY_SEPARATOR);

/* =-=- モジュール等の読み込み -=-= */
require_once EXECUTE_DIR.'../sns_config.php';
require_once BASE_DIR.'webapp'.DIRECTORY_SEPARATOR.'wap_config.php';

require_once LIB_DIR.'rkt_db.php';
require_once WEBAPP_LIB_DIR.'sendmail.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';

/**
 * 日次処理：デイリー配信クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package SOL_account
 * @access public
 * @version 1.1
 */
class act_daily
{
    /**
     * 曜日番号
     * @var integer
     */
    var $day = 0;

    /**
     * 今日の日付
     * @var string
     */
    var $now = '';

    /**
     * 情報取得日数限度格納
     * @var array
     */
    var $limit = array();

    /**
     * 取得範囲日数
     * @var string
     */
    var $date = '';

    /**
     * 会員ID
     * @var integer
     */
    var $ref_account = 0;

    /**
     * DB接続オジェクト
     * @var object
     */
    var $objdb = null;

    /**
     * メールオブジェクト
     * @var object
     */
    var $objmail = null;

    /**
     * コンストラクタ
     *
     * @access public
     */
    function act_daily()
    {
        $this->objdb = RKT_db::getInstance();
        $this->objmail = new sendmail('daily');
        
        // 月:1 と 木:4 の情報取得日数
        $weekly = array(1=>345600, 4=>259200); // 4日間と3日間
        $timestamp = time();
        $this->day = date('w', $timestamp);
        $this->now = date('Y/m/d', $timestamp);

        $this->limit = array(
            NEWS_STOP=>   '',
            NEWS_DAILY=>  date('Ymd', $timestamp - 86400),
            NEWS_WEEKLY=> date('Ymd', $timestamp - $weekly[$this->day]),
        );
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        // 曜日別実行マップ
        $action = array(
            0=> array(NEWS_STOP=>false, NEWS_DAILY=>true, NEWS_WEEKLY=>false),
            1=> array(NEWS_STOP=>false, NEWS_DAILY=>true, NEWS_WEEKLY=>true),
            2=> array(NEWS_STOP=>false, NEWS_DAILY=>true, NEWS_WEEKLY=>false),
            3=> array(NEWS_STOP=>false, NEWS_DAILY=>true, NEWS_WEEKLY=>false),
            4=> array(NEWS_STOP=>false, NEWS_DAILY=>true, NEWS_WEEKLY=>true),
            5=> array(NEWS_STOP=>false, NEWS_DAILY=>true, NEWS_WEEKLY=>false),
            6=> array(NEWS_STOP=>false, NEWS_DAILY=>true, NEWS_WEEKLY=>false),
        );        

        $sql=
            'SELECT '.
                'id,'.
                'news '.
            'FROM '.
                DB_PREFIX.'act_account '.
            'WHERE '.
                'avail = '.AVAIL_ENABLE;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        foreach ($result as $value){
            $this->ref_account = $value['id'];
            $this->date = $this->limit[$value['news']];

            if ($action[$this->day][$value['news']]){
                $this->send_mail();
            }
            $this->news = $value['news'];
        }
    }

    /**
     * ニュースの配信
     *
     * @access private
     * @param integer $ref_account
     * @return void
     **/
    function send_mail()
    {
        $sql=
            'SELECT '.
                'act.email as email,'.
                'pro.nickname as nickname '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = '.$this->ref_account;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $infos = $stmt->fetch(PDO_FETCH_ASSOC);
        
        $email = sql_query::decrypt($infos['email']);

        $this->objmail->Assign('user_name', $infos['nickname']);
        $this->objmail->Assign('now', $this->now);
        $this->objmail->Assign('http', HTTP_ACTION);
        $this->objmail->Assign('url', BASE_URL);
        $this->objmail->Assign('action', BLOG_ACTION);

        $this->set_topic();
        $this->set_fblog();
        $this->set_comment();
        $this->set_tb();

        $this->objmail->send($email);
    }

    /**
     * コミュニティ掲示板の設定
     *
     * @access private
     * @return void
     */
    function set_topic()
    {
        $date = dateFormat('com.modify','%m月 %d日 ');
        $format = dateFormat('com.modify','%Y%m%d');

        $sql=
            'SELECT '.
                'com.id as ref_community,'.
                'com.community as community,'.
                'tpc.id as ref_topic,'.
                'tpc.topic as topic,'.
                $date.' as modify,'.
                'count(com.id) as ct '.
            'FROM '.
                DB_PREFIX.'com_community com,'.
                DB_PREFIX.'com_names nam,'.
                DB_PREFIX.'com_topic tpc,'.
                DB_PREFIX.'com_comment com '.
            'WHERE '.
                'com.id = nam.ref_community AND '.
                'com.id = tpc.ref_community AND '.
                'tpc.id = com.ref_topic AND '.
                'com.avail = '.AVAIL_ENABLE.' AND '.
                'nam.ref_account = '.$this->accounts['id'].' AND '.
                $format." >= '".$this->date."' AND ".
                'nam.status != '.STATUS_COMMUNITY_REFUSAL.' AND '.
                'nam.status != '.STATUS_COMMUNITY_REQUEST.' '.
            'GROUP BY '.
                'com.id,'.
                'tpc.id,'.
                'nam.id '.
            'ORDER BY '.
                'com.modify DESC '.
            'LIMIT 5';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        if (empty($result)){
            return ;
        }

        $this->objmail->Assign('topics', $result);
    }

    /**
     * 友達日記の設定
     *
     * @access private
     * @return void
     */
    function set_fdiary()
    {
        $date = dateFormat('ent.regist_date','%m月 %d日 ');
        $format = dateFormat('ent.regist_date','%Y%m%d');
        $sql=
            'SELECT '.
                'ent.id as ref_entry,'.
                'act.id as ref_friend,'.
                'pro.nickname as nickname,'.
                $date.' as modify,'.
                'ent.subject as subject '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'dia_diary dia,'.
                DB_PREFIX.'dia_entry ent,'.
                DB_PREFIX.'fri_friends fri '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id != '.$this->accounts['id'] .' AND '.
                'act.id = dia.ref_account AND '.
                'dia.id = ent.ref_diary AND '.
                $format." >= '".$this->date."' AND ".
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'fri.avail = '.AVAIL_ENABLE.' AND '.
                'fri.status = '.STATUS_FRIEND_CONNECT.' AND '.
                '('.
                    '(fri.ref_account = act.id OR '.
                    'fri.ref_friend = act.id) AND '.
                    '(fri.ref_account = '.$this->accounts['id'] .' OR '.
                    'fri.ref_friend = '.$this->accounts['id'].')'.
                ') '.
            'ORDER BY '.
                'ent.regist_date DESC '.
            'LIMIT 5';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        if (empty($result)){
            return ;
        }

        $this->objmail->Assign('fdiarys', $result);
    }

    /**
     * 日記コメントの設定
     *
     * @access private
     * @return void
     */
    function set_comment()
    {
        $date = dateFormat('com.modify','%m月 %d日 ');
        $format = dateFormat('com.modify','%Y%m%d');
        $sql=
            'SELECT '.
                'ent.id as ref_entry,'.
                'act.id as ref_friend,'.
                'pro.nickname as nickname,'.
                $date.' as modify,'.
                'count(com.id) as ct,'.
                'ent.subject as subject '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'dia_diary dia,'.
                DB_PREFIX.'dia_entry ent,'.
                DB_PREFIX.'dia_comment com '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = dia.ref_account AND '.
                'dia.id = ent.ref_diary AND '.
                'ent.id = com.ref_entry AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                $format." >= '".$this->date."' AND ".
                'dia.ref_account = '.$this->accounts['id'].' '.
            'GROUP BY '.
                'act.id,'.
                'dia.id,'.
                'ent.id '.
            'ORDER BY '.
                'com.modify DESC '.
            'LIMIT 5';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        if (empty($result)){
            return ;
        }

        $this->objmail->Assign('comments', $result);
    }
} // act_daily

$actday = new act_daily();
$actday->execute();
?>
