<?php
/**
 * インストール画面(1)クラス
 *
 * インストール画面(1)を実現するためのクラス
 *
 * @package   simpleblog
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2009 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( 'install_base.inc' );

  /**
   * ユーティリティファンクションクラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_util.php' );

  class page01 extends install_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * チェック情報格納用変数
     * @access private
     * @var    array
     */
    private $checklist;
    /**
     * チェック結果格納用変数
     * @access private
     * @var    array
     */
    private $checkresult;
    /**
     * エラー発生状況格納用変数
     * @access private
     * @var    boolean
     */
    private $errStatus;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 前画面のCageが「install」でない or 前画面のActが「install」 and 「page01」 and 「page02」でない場合、
      // インストーラトップに飛ばす
      $tmp_cage = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage' ) );
      $tmp_act  = $this->obj_sess->sessLoad( 'lastact'  );
      if ( $tmp_cage != 'simpleblog.install' or  ( $tmp_act != 'install' and  $tmp_act != 'page01' and  $tmp_act != 'page02' ) )
      {
        $this->obj_util->redirectTo( 'install', 'simpleblog.install' );
        return false;
      } // end of if

      // チェック対象をセットする
      // 他にチェック対象があれば、この配列に加えてください。
      // path: チェック対象となるパス / stat: あるべき状態（writable: 書込可 / readable: 読込可）
      // readableを指定したとき、その対象が書込可の場合はNGとなります
      $this->checklist = array(
                                array(
                                       'path' => RISOLUTO_CONF
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_DOCROOT . '/js/'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/menu/'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/install/'
                                     , 'stat' => 'writable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/install/sql/DEFAULT_DSN_create.sql'
                                     , 'stat' => 'readable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/install/sql/DEFAULT_DSN_data.sql'
                                     , 'stat' => 'readable'
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'simpleblog/install/sql/DEFAULT_DSN_drop.sql'
                                     , 'stat' => 'readable'
                                     )
                              );

      // チェックメソッドを呼び出し、結果を整形
      foreach( $this->checklist as $dat )
      {
        $tmp_result = $this->obj_util->statChecker( $dat );
        if ( $tmp_result[ 'result' ] == 'NG' )
        {
          $this->errStatus = 'NG';
        } // end of if
        $this->checkresult[] = $tmp_result;
      } // end of foreach

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // ヘッダ情報をセット
      $html_header[ 'robots' ] = 'NOINDEX,NOFOLLOW';
      $html_header[ 'css'    ] = array( './css/common.css' );
      $html_header[ 'title'  ] = 'インストーラ(1)';

      // アサイン
      $this->smarty->assign ( 'header',    $html_header       );
      $this->smarty->assign ( 'checklist', $this->checkresult );
      $this->smarty->assign ( 'err',       $this->errStatus   );

      // 表示
      $this->smarty->display( 'page01.tpl' );

      return true;

    } // end of function:view()

  } // end of class:page01
?>
