/**
 * @(#)LineNoRowHeader.java
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 * RID-3 : Line No Row Header
 * @author  Intelligent Technology Inc.
 * @version 1.00 2002/04/30
 * @see 
 */
package	jp.co.nri.rid.table;

/* JAVA */
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

import	jp.co.iti.fagot.util.*;

/**
 * sԍ\pe[u
 */

public class LineNoRowHeader extends JTable{
	public LineNoRowHeader(JTable source){
		setModel(new LineNoTableModel(source));
		setAutoResizeMode(AUTO_RESIZE_OFF);
		
		TableCellRenderer renderer = new LineNoRenderer();
		int width = renderer.getTableCellRendererComponent(this ,"99999" ,false ,false ,0 ,0).getPreferredSize().width;
		getColumnModel().getColumn(0).setPreferredWidth(width);
		setRowHeight(24);
		
		try{
			setDefaultRenderer(Class.forName("java.lang.Object") ,renderer);
		}catch(ClassNotFoundException e){ e.printStackTrace(); }
	}
	
	public void resizeandrepaint(){	resizeAndRepaint(); }
	
	private class LineNoTableModel extends AbstractTableModel{
		private	JTable	mySource;
		private	int		myRowCount = 0;
		
		public LineNoTableModel(JTable source){ mySource = source; }
		
		/**
		 * AbstractTableModel̃I[o[ChBZ̕ҏWۂԂB
		 * @param	rowIndex	sCfbNXB
		 * @param	columnIndex	CfbNXB
		 * @return	falseԂB
		 * @since	1.00
		 */
		public boolean isCellEditable(int rowIndex ,int columnIndex){ return false; }
		
		/**
		 * AbstractTableModel̃I[o[ChBsԂB
		 * @return	sB
		 * @since	1.00
		 */
		public int getRowCount(){
			int count = mySource.getRowCount();
			if(myRowCount != count){
				myRowCount = count;
			}
			return myRowCount;
		}
		
		/**
		 * AbstractTableModel̃I[o[ChBJB
		 * @param	column	CfbNXB
		 * @return	JB
		 * @since	1.00
		 */
		public String getColumnName(int column){ return null; }
		
		/**
		 * AbstractTableModel̃I[o[ChBJB
		 * @return	JB
		 * @since	1.00
		 */
		public int getColumnCount(){ return 1; }
		
		/**
		 * AbstractTableModel̃I[o[ChBZl𓾂B
		 * @param	row		sCfbNXB
		 * @param	column	CfbNXB
		 * @return	ZlB
		 * @since	1.00
		 */
		public Object getValueAt(int row ,int column){
			return String.valueOf(row+1);
		}
		
		/**
		 * AbstractTableModel̃I[o[ChBZlݒ肷B
		 * @param	aValue	ZlB
		 * @param	row		sCfbNXB
		 * @param	column	CfbNXB
		 * @since	1.00
		 */
		public void setValueAt(Object aValue ,int row ,int column){}
	}
	
	/**
	 * TableCellRenderer
	 * @since	1.00
	 */
	private class LineNoRenderer implements TableCellRenderer{
		public Component getTableCellRendererComponent(JTable table ,Object value ,boolean isSelected ,boolean hasFocus ,int row ,int column){
			JPanel panel = new JPanel(new BorderLayout());
			panel.add(new JLabel((String)value) ,BorderLayout.EAST);
			
			return panel;
		}
	}
}
