package jp.co.nri.rid.search;

/* misc */
import java.util.Enumeration;
import java.util.Vector;

/* Rid */
import jp.co.nri.Rid;
import jp.co.nri.rid.xml.elementBooster;


/**
 * TCgvWv
 */
class SPTableModelStatistics extends SPTableModel{
    /** SCCS ID */
    private static final String SCCSID = "@(#)SPTableModelStatistics.java";

    /** RCS ID */
    private static final String RCSID =
	"$Id: SPTableModelStatistics.java,v 1.3 2003-07-03 19:09:11+09 nsmr Exp $";

    /**
     * TCg|[g̑ΏۂƂȂ郆jbg
     *
     * {hLg, jbg, TCYvZtO, \tO} ̔z
     */
    final Object[][] STAT_TARGET_UNITS = {
	{Rid.DOCUMENT_SITE, "ZoneUnit"},
	{Rid.DOCUMENT_SITE, "PageUnit", BTRUE, BTRUE},
	{Rid.DOCUMENT_SITE, "UrlUnit"},
	{Rid.DOCUMENT_DOCUMENT, "DocumentUnit", BTRUE, BTRUE},
	{Rid.DOCUMENT_RESOURCE, "ResourceUnit", BTRUE, BTRUE}
    };

    /** \̍ۂ̃Cfg */
    static final String INDENT = "   ";

    /**
     * RXgN^:
     */
    SPTableModelStatistics() {
        target = SPTableModel.STATISTICS;
        count = -1;

        resultVector = new Vector();

        /** 1 s̃f[^܂ޕ̔z */
        String[] rowStrings;

        int[] columnIDs = SPColumnNames.get(target);
        if (columnIDs == null){
            return;
        }

        for (int i = 0; i < STAT_TARGET_UNITS.length; i++) {
            if (STAT_TARGET_UNITS[i] == null){
                continue;
            }
            if (STAT_TARGET_UNITS[i].length <= 1){
                continue;
            }

            String unitName = (String)STAT_TARGET_UNITS[i][1];

            /* unitName ɊY郆jbgׂĎ擾 */
            elementBooster[] elements =
                getElementsFromDocument(unitName,
                                        (String)STAT_TARGET_UNITS[i][0]);

            int unitCount = 0;
            if (elements != null) {
                unitCount = elements.length;
                /* "_top" ][̕ */
                if (unitName.equals("ZoneUnit") && unitCount >= 1) {
                    unitCount--;
                }
            }

            int totalSize = 0;
            /* vTCYvZ */
            if (STAT_TARGET_UNITS[i].length >= 3 &&
                ((Boolean)STAT_TARGET_UNITS[i][2]).booleanValue()) {
                totalSize = getTotalSize(elements);
            }

            rowStrings = new String[columnIDs.length];
            SPResource r = SPResourceHash.get(unitName);
            if (r != null) {
                unitName = r.displayStr;
            }

            for (int j = 0; j < columnIDs.length; j++) {
                if (columnIDs[j] == SPColumnNames.UNIT) {
                    rowStrings[j] = unitName;
                } else if (columnIDs[j] == SPColumnNames.COUNT) {
                    rowStrings[j] = String.valueOf(unitCount);
                } else if (columnIDs[j] == SPColumnNames.TOTAL) {
                    rowStrings[j] = String.valueOf(totalSize);
                } else {
                    rowStrings[j] = null;
                }
            }

            /* ʂ̕\ */
            resultVector.add(new SPElementAndStrings(rowStrings));

            /* vf̏ꍇ́At@C^CvƂ̏WvsȂȂ */
            if (elements == null) {
                continue;
            }

            /* t@C^CvƂ̏Wv */
            if (STAT_TARGET_UNITS[i].length >= 4 &&
                ((Boolean)STAT_TARGET_UNITS[i][3]).booleanValue()) {
                SPFileTypeHash fileTypeHash = new SPFileTypeHash(elements);
                Enumeration e = fileTypeHash.keys();
                while (e.hasMoreElements()) {
                    String fileType = (String)e.nextElement();
                    /* "not exist" ͌ */
                    if (fileType.equals("not exist")) {
                        continue;
                    }
                    unitCount = fileTypeHash.getCount(fileType);
                    if (unitCount > 0) {
                        rowStrings = new String[columnIDs.length];
                        unitName = INDENT + "(" + fileType + ")";
                        totalSize = fileTypeHash.getSize(fileType);
                        for (int j = 0; j < columnIDs.length; j++) {
                            if (columnIDs[j] == SPColumnNames.UNIT) {
                                rowStrings[j] = unitName;
                            } else if (columnIDs[j] == SPColumnNames.COUNT) {
                                rowStrings[j] = String.valueOf(unitCount);
                            } else if (columnIDs[j] == SPColumnNames.TOTAL) {
                                rowStrings[j] = String.valueOf(totalSize);
                            } else {
                                rowStrings[j] = null;
                            }
                        }
                        resultVector.add(new SPElementAndStrings(rowStrings));
                    }
                }

                /* 񂵂ɂꂽ "not exist"A
                 * resultVector ̍Ōɒǉ
                 */
                unitCount = fileTypeHash.getCount("not exist");
                if (unitCount > 0) {
                    rowStrings = new String[columnIDs.length];
                    unitName = INDENT + "(not exist)";
                    for (int j = 0; j < columnIDs.length; j++) {
                        if (columnIDs[j] == SPColumnNames.UNIT) {
                            rowStrings[j] = unitName;
                        } else if (columnIDs[j] == SPColumnNames.COUNT) {
                            rowStrings[j] = String.valueOf(unitCount);
                        } else {
                            rowStrings[j] = null;
                        }
                    }
                    resultVector.add(new SPElementAndStrings(rowStrings));
                }
            }/* if (STAT_TARGET_UNITS[i].length >= 4 &&
                ((Boolean)STAT_TARGET_UNITS[i][3]).booleanValue()) */
        } /* for (int i = 0; i < STAT_TARGET_UNITS.length; i++) */
    } /* RXgN^ */


    /**
     * vTCY̌vZ
     * @param elements WvGg̔z
     * @return vTCY [oCg]
     */
    public int getTotalSize(elementBooster[] elements) {
        int totalSize = 0;

        if (elements == null) {
            return totalSize;
        }

        for (int i = 0; i < elements.length; i++) {
            String exist = elements[i].attribute("Exist");

            /* ݂ȂGg̓JEgȂ */
            if (exist == null) {
                continue;
            }
            if (!exist.equals("true")) {
                continue;
            }
		
            String size = elements[i].attribute("Size");
            if (size != null) {
                int sizeInt;
                try {
                    sizeInt = Integer.parseInt(size);
                } catch (NumberFormatException e) {
                    sizeInt = 0;
                }
                totalSize += sizeInt;
            }
        }
        return totalSize;
    } /* getTotalSize */
} /* class SPTableModelStatistics */
