package jp.co.nri.rid.search;

/* misc */
import java.util.Vector;
import java.awt.Color;

/* Rid */
import jp.co.nri.Rid;
import jp.co.nri.rid.xml.elementBooster;


/**
 * DetailInfo ̉
 */
class SPTableModelDetailInfo extends SPTableModel{
    /** SCCS ID */
    private static final String SCCSID = "@(#)SPTableModelDetailInfo.java";

    /** RCS ID */
    private static final String RCSID =
	"$Id: SPTableModelDetailInfo.java,v 1.12 2003-07-18 17:48:29+09 nsmr Exp $";

    /** ZɔwiFݒ肷ۂ̐F */
    // static final String CELL_BACKGROUND = "DDF0FF";
    static final String CELL_BACKGROUND = "F4F7F9";

    /** ZɔwiFݒ肷ۂ̐F */
    static final Color BACKGROUND_COLOR = hexToColor(CELL_BACKGROUND);


    /**
     * RXgN^:
     */
    SPTableModelDetailInfo(int target) {
        this.target = target;

        /*  */
        count = 0;

        /* ʕێ Vector  */
        resultVector = new Vector();

        /* 1s̕\ێz */
        String[] rowStrings;

        /* 1s̔wiFێz */
        Color[] rowColors;

        /* 1Z̔wiFێ */
        Color cellBackground;

        /* s̔wiFݒ肷邩ۂێtO */
        boolean backgroundFlag = true;

        /* DOCUMENT_SITE  PaegUnit ׂĎ擾 */
        elementBooster[] pageUnits =
            getElementsFromDocument("PageUnit", Rid.DOCUMENT_SITE);

        /* PageUnit ݂Ȃ */
        if (pageUnits.length <= 0) {
            return;
        }

        int[] columnIDs = SPColumnNames.get(target);

        for (int i = 0; i < pageUnits.length; i++) {
            if (pageUnits[i].isNull()) {
                continue;
            }

            /* DetailInfo Ȃ PageUnit ͖ */
            elementBooster detailInfo = pageUnits[i].child("DetailInfo");
            if (detailInfo == null) {
                continue;
            }

            /* qȂ DetailInfo  ͖ */
            elementBooster[] detailChildren = detailInfo.children();
            if (detailChildren == null) {
                continue;
            }

            rowColors = new Color[columnIDs.length];
            rowStrings = new String[columnIDs.length];

            /* t@C\ */
            if (pageUnits[i].attribute("File") != null) {
                rowStrings =
                    addStringToRowStrings(rowStrings, target,
                                          SPColumnNames.FILE,
                                          pageUnits[i].attribute("File"));
            } else {
                rowStrings = addStringToRowStrings(rowStrings, target,
                                                   SPColumnNames.FILE, "");
            }

            for (int j = 0; j < detailChildren.length; j++) {
                /* ݂̌ΏۂŁAׂGgȊO͖ */
                if (!isTargetElement(target, detailChildren[j])) {
                    continue;
                }

                /* ݒڂĂt@C 2 ڈȍ~ detailChildren 
                   ̏ꍇA1 ڂ detailChildren łłɃt@C͕\
                   ̂ŁAł "File" ̃J͉\Ȃ */
                if (rowStrings == null) {
                    rowColors = new Color[columnIDs.length];
                    rowStrings = new String[columnIDs.length];

                    /* I File J "" ɂȂƁAelementBooster
                        File Agr[g\Ă܂ */
                    rowStrings = addStringToRowStrings(rowStrings, target,
                                                       SPColumnNames.FILE, "");
                }

                if (target == META) {
                    rowStrings =
                        metaInfoAnalyze(rowStrings, detailChildren[j]);
                    resultVector.add(new SPElementAndStrings(pageUnits[i],
                                                             rowStrings));
                    rowStrings = null;
                    count++;
                    continue;
                }

                if (target == STYLESHEET) {
                    rowStrings =
                        stylesheetAnalyze(rowStrings, detailChildren[j]);
                    resultVector.add(new SPElementAndStrings(pageUnits[i],
                                                             rowStrings));
                    rowStrings = null;
                    count++;
                    continue;
                }

                if (target == SCRIPT) {
                    rowStrings =
                        scriptAnalyze(rowStrings, detailChildren[j]);
                    resultVector.add(new SPElementAndStrings(pageUnits[i],
                                                             rowStrings));
                    rowStrings = null;
                    count++;
                    continue;
                }

                if (target != FORM) {
                    continue;
                }
                /* ȉ̏ form ɑ΂ */

                if (backgroundFlag) {
                    cellBackground = BACKGROUND_COLOR;
                    backgroundFlag = false;
                } else {
                    cellBackground = null;
                    backgroundFlag = true;
                }

                /* DetailInfo ̒ڂ̎qƂ input nꍇ */
                if (detailChildren[j].tagname().equals("button") ||
                    detailChildren[j].tagname().equals("input") ||
                    detailChildren[j].tagname().equals("textarea")) {
                    rowStrings = addStringToRowStrings(rowStrings, target,
                                                       SPColumnNames.FORM_NAME,
                                                       "(n/a)");
                    rowStrings = addElementToRowStrings(rowStrings,
                                                        detailChildren[j]);
                    rowColors = setColorToRow(rowColors, cellBackground);
                    resultVector.add(new SPElementAndStrings(pageUnits[i],
                                                             rowStrings,
                                                             rowColors));
                    rowStrings = null;
                    rowColors = null;
                    count++;

                    continue;
                }

                /* DetailInfo ̒ڂ̎qƂ select ꍇ */
                if (detailChildren[j].tagname().equals("select")) {
                    rowStrings = addStringToRowStrings(rowStrings, target,
                                                       SPColumnNames.FORM_NAME,
                                                       "(n/a)");
                    rowStrings = addElementToRowStrings(rowStrings,
                                                        detailChildren[j]);
                    rowColors = setColorToRow(rowColors, cellBackground);
                    resultVector.add(new SPElementAndStrings(pageUnits[i],
                                                             rowStrings,
                                                             rowColors));
                    rowStrings = null;
                    rowColors = null;
                    count++;
                    /* select Ɉ͂܂ꂽ option  */
                    elementBooster[] options = detailChildren[j].children();
                    for (int m = 0; m < options.length; m++) {
                        if (options[m].tagname().equals("option")) {
                            rowStrings = addElementToRowStrings(rowStrings,
                                                                options[m]);
                            rowColors = setColorToRow(rowColors,
                                                      cellBackground);
                            resultVector.add(new
                                SPElementAndStrings(pageUnits[i], rowStrings,
                                                    rowColors));
                            rowStrings = null;
                            rowColors = null;
                            count++;
                        }
                    }
                    continue;
                } /* if (detailChildren[j].tagname().equals("select")) */

                /* DetailInfo ̒ڂ̎q form ̏ꍇ */
                /* eAgr[g̕\ */
                if (detailChildren[j].attribute("name") != null) {
                    rowStrings =
                        addStringToRowStrings(rowStrings, target,
                                              SPColumnNames.FORM_NAME,
                                              detailChildren[j].attribute("name"));
                }
                if (detailChildren[j].attribute("action") != null) {
                    rowStrings =
                        addStringToRowStrings(rowStrings, target,
                                              SPColumnNames.ACTION, 
                                              detailChildren[j].attribute("action"));
                }
                if (detailChildren[j].attribute("method") != null) {
                    rowStrings =
                        addStringToRowStrings(rowStrings, target,
                                              SPColumnNames.METHOD,
                                              detailChildren[j].attribute("method"));
                }

                /* form ̎qB\ */
                elementBooster[] inputs = detailChildren[j].children();

                /* input nȂ form ̏ꍇ */
                if (inputs == null) {
                    rowStrings =
                        addStringToRowStrings(rowStrings, target,
                                              SPColumnNames.INPUT_NAME,
                                              "(n/a)");
                    rowColors = setColorToRow(rowColors, cellBackground);
                    resultVector.add(new SPElementAndStrings(pageUnits[i],
                                                             rowStrings,
                                                             rowColors));
                    rowStrings = null;
                    rowColors = null;
                    count++;
                    continue;
                }
                
                for (int k = 0; k < inputs.length; k++) {
                    rowStrings = addElementToRowStrings(rowStrings, inputs[k]);
                    rowColors = setColorToRow(rowColors, cellBackground);
                    resultVector.add(new SPElementAndStrings(pageUnits[i],
                                                             rowStrings,
                                                             rowColors)); 
                    rowStrings = null;
                    rowColors = null;
                    count++;

                    /* select Ɉ͂܂ꂽ option  */
                    if (inputs[k].tagname().equals("select")) {
                        elementBooster[] options = inputs[k].children();
                        for (int m = 0; m < options.length; m++) {
                            if (options[m].tagname().equals("option")) {
                                rowStrings =
                                    addElementToRowStrings(rowStrings,
                                                           options[m]);
                                rowColors = setColorToRow(rowColors,
                                                          cellBackground);
                                resultVector.add(new
                                    SPElementAndStrings(pageUnits[i],
                                                        rowStrings,
                                                        rowColors));
                                rowStrings = null;
                                rowColors = null;
                                count++;
                            }
                        }
                    }
                } /* for (int k = 0; k < inputs.length; k++)  */
            } /* for (int j = 0; j < detailChildren.length; j++) */
            
            /* DetailInfo  form / input ȂꍇA܂
               DetailInfo ̍Ō̍ڂAform / input ȊOꍇ́A
               rowStrings  resultVector  add Ɏ̂Ă */

        } /* for (int i = 0; i < pageUnits.length; i++) */
    } /* RXgN^ */


    /**
     * DetailInfo ̃GgA
     * w肳ꂽΏێɈׂ̂ۂԂ
     *
     * @param target Ώۂ̎ʖ
     * @param element DetailInfo ̃Gg
     * @return ׂGg̏ꍇ true
     */
    private boolean isTargetElement(int target, elementBooster element) {
        if (target == FORM) {
            /* "form detail" [hŁA
               form ł input ł textarea ł select ł button ł
               Ȃvf͖ */
            if (element.tagname().equals("button"))   { return true; }
            if (element.tagname().equals("form"))     { return true; }
            if (element.tagname().equals("input"))    { return true; }
            if (element.tagname().equals("select"))   { return true; }
            if (element.tagname().equals("textarea")) { return true; }
            return false;
        }

        if (target == META) {
            /* "meta detail" [hŁAmeta ȊO̗vf͖ */
            if (element.tagname().equals("meta")) { return true;}
            return false;
        }

        if (target == STYLESHEET) {
            if (element.tagname().equals("style")) {
                return true;
            }
            if (element.tagname().equals("link")) {
                String rel = element.attribute("rel");
                if (rel == null) {
                    return false;
                }
                if (rel.equalsIgnoreCase("stylesheet")){
                    return true;
                }
                return false;
            }
            return false;
        }

        if (target == SCRIPT) {
            if (element.tagname().equals("script")) { return true;}
            return false;
        }

        return false;
    } /* isTargetElement */


    /**
     * meta ^OɊ܂܂f[^̉
     * @param rowStrings ͌ʂi[z
     * @param element ͑Ώۂ meta Gg
     */
    private String[] metaInfoAnalyze(String[] rowStrings,
                                      elementBooster element) {
        /* eAgr[g̕\ */
        if (element.attribute("name") != null) {
            rowStrings = addStringToRowStrings(rowStrings, target,
                                               SPColumnNames.META_NAME,
                                               element.attribute("name"));
        }
        if (element.attribute("http-equiv") != null) {
            rowStrings =
                addStringToRowStrings(rowStrings, target,
                                      SPColumnNames.HTTP_EQUIV,
                                      element.attribute("http-equiv"));
        }
        if (element.attribute("content") != null) {
            rowStrings =
                addStringToRowStrings(rowStrings, target,
                                      SPColumnNames.CONTENT, 
                                      element.attribute("content"));
        }
        return rowStrings;
    } /* metaInfoAnalyze */


    /**
     * link or style ^OɊ܂܂f[^̉
     */
    private String[] stylesheetAnalyze(String[] rowStrings,
                                       elementBooster element) {
        if (element.tagname().equals("style")) {
            /* style ^Ȍꍇ́Atype Agr[g\ */
            if (element.attribute("type") != null) {
                return addStringToRowStrings(rowStrings, target,
                                             SPColumnNames.TYPE,
                                             element.attribute("type"));
            }
            return addStringToRowStrings(rowStrings, target,
                                         SPColumnNames.TYPE, "(n/a)");
        }

        if (element.tagname().equals("link")) {
            /* link ^Ȍꍇ́Ahref ܂ src  Agr[g\ */
            if (element.attribute("rel") != null) {
                if (element.attribute("rel").equalsIgnoreCase("stylesheet")) {
                    if (element.attribute("href") != null) {
                        return
                            addStringToRowStrings(rowStrings, target,
                                                  SPColumnNames.LINK,
                                                  element.attribute("href"));
                    }
                    if (element.attribute("src") != null) {
                        return addStringToRowStrings(rowStrings, target,
                                                     SPColumnNames.LINK,
                                                     element.attribute("src"));
                    }
                    return addStringToRowStrings(rowStrings, target,
                                                 SPColumnNames.LINK,
                                                 "(n/a)");
                }

            }
        }

        return rowStrings;
    } /* stylesheetAnalyze */


    /**
     * script ^OɊ܂܂f[^̉
     */
    private String[] scriptAnalyze(String[] rowStrings,
                                   elementBooster element) {
        if (element.attribute("language") != null) {
            rowStrings = addStringToRowStrings(rowStrings, target,
                                               SPColumnNames.LANGUAGE,
                                               element.attribute("language"));
        } else {
            rowStrings = addStringToRowStrings(rowStrings, target,
                                               SPColumnNames.LANGUAGE,
                                               "(n/a)");
        }

        if (element.attribute("type") != null) {
            rowStrings = addStringToRowStrings(rowStrings, target,
                                               SPColumnNames.TYPE,
                                               element.attribute("type"));
        }
        if (element.attribute("charset") != null) {
            rowStrings = addStringToRowStrings(rowStrings, target,
                                               SPColumnNames.CHARSET,
                                               element.attribute("charset"));
        }
        if (element.attribute("src") != null) {
            rowStrings = addStringToRowStrings(rowStrings, target,
                                               SPColumnNames.SOURCE,
                                               element.attribute("src"));
        }

        return rowStrings;
    } /* scriptAnalyze */
    

    /**
     * form vf rowStrings ɒǉ
     * @param rowStrings ǉ rowStrings
     * @param element ǉ element
     */
    String[] addElementToRowStrings(String[] rowStrings,
                                    elementBooster element){
        String tagName = element.tagname();

        if (rowStrings == null) {
            int[] columnIDs = SPColumnNames.get(target);
            if (columnIDs == null) {
                return rowStrings;
            }
            rowStrings = new String[columnIDs.length];
            rowStrings = addStringToRowStrings(rowStrings, target,
                                               SPColumnNames.FILE, "");
        }

        /* option ^Ȍꍇ́A"Input Name" ɂ select ̖O\
           ߁Ał͉\Ȃ*/
        if (!tagName.equals("option")) {
            if (element.attribute("name") != null) {
                rowStrings = addStringToRowStrings(rowStrings, target,
                                                   SPColumnNames.INPUT_NAME,
                                                   element.attribute("name"));
            }
        }

        /* input, button ̃^Ȍꍇ́A
         *  "Input Type"  type Agr[g\
         */
        String elementType = element.attribute("type");
        if (elementType == null) {
            rowStrings = addStringToRowStrings(rowStrings, target,
                                               SPColumnNames.INPUT_TYPE,
                                               tagName);
        } else if (elementType.equals("")) {
            rowStrings = addStringToRowStrings(rowStrings, target,
                                               SPColumnNames.INPUT_TYPE,
                                               tagName);
        } else {
            rowStrings =
                addStringToRowStrings(rowStrings, target,
                                      SPColumnNames.INPUT_TYPE,
                                      tagName + " (" + elementType + ")");
        }

        if (element.attribute("value") != null) {
            rowStrings = addStringToRowStrings(rowStrings, target,
                                               SPColumnNames.VALUE,
                                               element.attribute("value"));
        }

        /* checked Agr[ĝ input (`FbN{bNXA
           WI{^) ́Achecked Agr[g\ */
        if (element.attribute("checked") != null) {
            rowStrings = addStringToRowStrings(rowStrings, target,
                                               SPColumnNames.CHECKED,
                                               element.attribute("checked"));
        }

        /* 摜{^̏ꍇ src Agr[g\ */
        if (element.attribute("src") != null) {
            rowStrings = addStringToRowStrings(rowStrings, target,
                                               SPColumnNames.SOURCE,
                                               element.attribute("src"));
        }

        /* option ^Ȍꍇ́Aselected Agr[g\ */
        if (element.attribute("selected") != null) {
            rowStrings = addStringToRowStrings(rowStrings, target,
                                               SPColumnNames.CHECKED,
                                               element.attribute("selected"));
        }

        return rowStrings;
    } /* addElementToRowStrings */


    Color[] addColorToRowColors(Color[] rowColors, int columnID, Color color) {
        int columnIndex = SPColumnNames.getColumnIndex(target, columnID);
        if (columnIndex < 0 || rowColors.length <= columnIndex) {
            return rowColors;
        }
        rowColors[columnIndex] = color;
        return rowColors;
    } /* addColorToRowColors */


    Color[] setColorToRow(Color[] rowColors, Color color) {

        if (rowColors == null) {
            int[] columnIDs = SPColumnNames.get(target);
            if (columnIDs == null) {
                return rowColors;
            }
            rowColors = new Color[columnIDs.length];
        }

        rowColors = addColorToRowColors(rowColors, SPColumnNames.FORM_NAME,
                                        color);
        rowColors = addColorToRowColors(rowColors, SPColumnNames.ACTION,
                                        color);
        rowColors = addColorToRowColors(rowColors, SPColumnNames.METHOD,
                                        color);
        rowColors = addColorToRowColors(rowColors, SPColumnNames.INPUT_NAME,
                                        color);
        rowColors = addColorToRowColors(rowColors, SPColumnNames.INPUT_TYPE,
                                        color);
        rowColors = addColorToRowColors(rowColors, SPColumnNames.VALUE,
                                        color);
        rowColors = addColorToRowColors(rowColors, SPColumnNames.CHECKED,
                                        color);
        rowColors = addColorToRowColors(rowColors, SPColumnNames.SOURCE,
                                        color);
        return rowColors;
    } /* setColorToRow */


    /**
     * 16iŕ\ꂽ Color ɕϊ
     * @param str 16 i 6 ŕ\ꂽ
     * @return str \F
     */
    static Color hexToColor(String str) {
        if (str == null) {
            return Color.WHITE;
        }

        if (str.length() != 6) {
            return Color.WHITE;
        }

        int r, g, b;
        try {
            r = Integer.parseInt(str.substring(0, 2), 16);
            g = Integer.parseInt(str.substring(2, 4), 16);
            b = Integer.parseInt(str.substring(4, 6), 16);
            return new Color(r, g, b);
        } catch (NumberFormatException e) {
            return Color.WHITE;
        }
    } /* hexToColor */
} /* class SPTableModelDetailInfo */
