package jp.co.nri.rid.search;

import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;


/**
 * $B8!:w7k2LI=<(%F!<%V%k$NNs%b%G%k(B
 */
class SPTableColumnModel extends DefaultTableColumnModel {
    /** SCCS ID */
    private static final String SCCSID = "@(#)SPTableColumnModel.java";

    /** RCS ID */
    private static final String RCSID =
	"$Id: SPTableColumnModel.java,v 1.21 2003-07-03 19:09:11+09 nsmr Exp $";

    /** $BFCDj$N%+%i%`$NI}(B ($B%T%/%;%k(B) */
    private static final int[][] WIDTH_ARRAY = {
        {SPColumnNames.ACTION,     125}, /* "Action" */
        {SPColumnNames.CONTENT,    300}, /* "Content" */
        {SPColumnNames.FILE,       175}, /* "File" */
        {SPColumnNames.HTTP_EQUIV, 125}, /* "Http-equiv" */
        {SPColumnNames.INPUT_TYPE, 100}, /* "Input Type" */
        {SPColumnNames.LANGUAGE,   100}, /* "Language" */
        {SPColumnNames.LINK,       100}, /* "Link" */
        {SPColumnNames.METHOD,      50}, /* "Method" */
        {SPColumnNames.SOURCE,     125}, /* "Source" */
        {SPColumnNames.TITLE,      175}, /* "Title" */
        {SPColumnNames.TYPE,       100}  /* "Type" */
    };

    /** $B$=$NB>3F%+%i%`$NI}(B ($B%T%/%;%k(B) */
    static final int DEFAULT_COLUMN_WIDTH = 75;

    /** WIDTH_ARRAY $B$NG[Ns2=(B */
    static int[] initialWidths;

    /** $B3F(B target $B$4$H$N(B adjustedWidths $B$rJ];}$9$kG[Ns(B */
    private static int[][] columnWidthArray;

    /**
     * $B8!:w7k2LI=<(%F!<%V%k$G!"1&4s$;$9$k%+%i%`$N%+%i%`L>(B
     * $B%=!<%H$N:]$K!"@0?tCM$H$7$F07$&$+H=CG$9$k$N$K$b;H$&(B
     */
    static final int[] INTEGER_COLUMNS = {
        SPColumnNames.HASH,      /* "#" */
        SPColumnNames.HEIGHT,    /* "Height" */
        SPColumnNames.HTML_ONLY, /* "HTML only" */
        SPColumnNames.COUNT,     /* "Count" */
        SPColumnNames.RESOURCES, /* "Resources" */
        SPColumnNames.SIZE,      /* "Size" */
        SPColumnNames.TOTAL,     /* "Total [Byte]" */
        SPColumnNames.WIDTH      /* "Width" */
    };

    /** $B8!:w%?!<%2%C%HL>(B */
    private int target;

    /**
     * $B%3%s%9%H%i%/%?(B
     * @param target $B8!:wBP>]$N<1JLL>(B
     */
    SPTableColumnModel(int target) {
	super();
	this.target = target;

        if (columnWidthArray == null) {
            columnWidthArray = new int[SPTableModel.NUMTARGETS][];
        }

        /* initialWidths $B$N=i4|2=(B */
        if (initialWidths == null) {
            initDefaultColumnWidths();
        }

        int[] columnIDs = SPColumnNames.get(target);
	if (columnIDs == null) {
	    return;
	}

        /* adjustedWidths might be null */
        int[] adjustedWidths = getAdjustedWidths();

        SPCellRenderer cellRenderer = new SPCellRenderer(target);

	/* $BNs$NDI2C(B */
	for (int i = 0; i < columnIDs.length; i++) {
	    TableColumn tableColumn = new TableColumn(i);
            int columnID = columnIDs[i];
            String columnHeaderValue = SPColumnNames.toString(columnID);
	    tableColumn.setHeaderValue(columnHeaderValue);

	    /* $B%+%i%`$NI}$N@_Dj(B */
            if (adjustedWidths == null) {
                setDefaultColumnWidth(tableColumn, columnID);
            } else if (i < 0 || adjustedWidths.length <= i) {
                setDefaultColumnWidth(tableColumn, columnID);
	    } else {
                tableColumn.setPreferredWidth(adjustedWidths[i]);
	    }

            tableColumn.setHeaderRenderer(new SPHeaderRenderer());

            /* form $B2r@O$N>l9g$OGX7J?'$D$-(B renderer $B$r;HMQ(B */
            if (target == SPTableModel.FORM) {
                tableColumn.setCellRenderer(cellRenderer);
            }
	    addColumn(tableColumn);
	}

	addColumnModelListener(new SPColumnModelListener());
    } /* $B%3%s%9%H%i%/%?(B */


    private void initDefaultColumnWidths() {
        initialWidths = new int[SPColumnNames.NUMCOLUMNS];

        for (int i = 0; i < SPColumnNames.NUMCOLUMNS; i++) {
            initialWidths[i] = DEFAULT_COLUMN_WIDTH;
        }

        for (int i = 0; i < WIDTH_ARRAY.length; i++) {
            if (WIDTH_ARRAY[i] == null) {
                continue;
            }
            if (WIDTH_ARRAY[i].length < 2) {
                continue;
            }
            initialWidths[WIDTH_ARRAY[i][0]] = WIDTH_ARRAY[i][1];
        }
    } /* initDefaultColumnWidths */


    /* $B%+%i%`$NI}$r!"=i4|CM$K@_Dj$9$k(B */
    private void setDefaultColumnWidth(TableColumn tableColumn, int columnID){
        if (columnID < 0 || initialWidths.length <= columnID) {
            tableColumn.setPreferredWidth(DEFAULT_COLUMN_WIDTH);
            return;
        }
        tableColumn.setPreferredWidth(initialWidths[columnID]);
    } /* setDefaultColumnWidth */


    public boolean getColumnSelectionAllowed() {
        return true;
    }


    /**
     * $B8=:_$N8!:wBP>]$N%+%i%`I}$rJ];}$9$kG[Ns$rJV$9(B
     * 
     * @return $B%+%i%`L>$r%-!<$K!"%+%i%`I}$rCM$K;}$D%O%C%7%e%F!<%V%k(B
     */
    int[] getAdjustedWidths() {
        if (target < 0 || SPTableModel.NUMTARGETS < target) {
            return null;
        }
        return columnWidthArray[target];
    } /* getAdjustedWidths */


    static boolean isIntegerColumn(int columnID) {
        for (int i = 0; i < INTEGER_COLUMNS.length; i++) {
            if (INTEGER_COLUMNS[i] == columnID) {
                return true;
            }
        }
        return false;
    } /* isIntegerColumn */


    /**
     * $B8=:_$N8!:wBP>]$N%+%i%`I}$rJ];}$9$kG[Ns$r!"M?$($i$l$?G[Ns$GCV$-49$($k(B
     * 
     * @param newWidths $B%+%i%`I}$rJ];}$9$kG[Ns(B
     */
    void setAdjustedWidths(int[] newWidths) {
        if (target < 0 || SPTableModel.NUMTARGETS < target) {
            return;
        }
        columnWidthArray[target] = newWidths;
    } /* setAdjustedWidths */
} /* class SPTableColumnModel */
