/*
 * @(#)Mapper.java
 *
 * RID-X : Mapper
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/02/15
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 */

package jp.co.nri.rid.mapper;


import org.w3c.dom.*;
import jp.co.nri.rid.error.RidException;


/**
 * Mapper
 */
public class Mapper {

    //
    private static String pr_errorString;   // G[bZ[W

/**
  * RXgN^
  *
  */
    public Mapper() {
        //NA
        pr_errorString = "";
    }



/******************************************************************************/



/**
  * (Mapper_Type1)
  *
  *   Mapt@CɋLqꂽeƂ
@*   Inputt@C̎w肳ꂽ^OɁAw肳ꂽƒlǉ
  *
  * @param  String      in_file         INPUTt@C   (HTML`)
  * @param  String      map_file        MAPt@C     (XML `)
  * @param  Document    data_doc        DATADocument  (XML `)
  * @param  String      out_file        OUTPUTt@C  (HTML`)
  *
  * @return boolean     true() / false (s)
@*--------------------------------------------------------------------------
  *
  *  #InputFile
  *   
  *   <a name="top"> gbvy[W </a>
  *
  *  #MapFile
  *
  *   <MapAttr srcTag="a" srcKey="name" dataTag="PageData" dataKey="name">
  *       <MapAttrData inTag="URL" outAttr="hrer"/>
  *   </MapAttr>
  *
  *   srcTag  : inputFilẽ^O
  *   srcKey  : inputFilȇL[
  *   dataTag : dataFilẽ^O
  *   dataKey : dataFilȇL[
  *   inTag   : dataFilẽf[^^O
  *   outAttr : inputFileɒǉ鑮
  *
  *       L[FsrcKey̒ldataKey̒l
  *
  *  #DataFile
  *
  *   <PageData name="top">
  *     <URL>../topFrame.html</URL>
  *   </PageData>
  *
  *  #OutputFile
  *   
  *   <a name="top" hrer="../topFrame.html"> gbvy[W </a>
  */
    public boolean Type1(String in_file, String map_file, Document data_doc, String out_file)  throws RidException {

        boolean ret;

        MapperType1 mt1 = new MapperType1();
        ret  = mt1.Type1(in_file, map_file,  data_doc,  out_file);
 
        return ret;
    }

/**
  * (Mapper_Type1@DOM)
@*
  *   Mapt@CɋLqꂽeƂ
@*   Input XMLɎw肳ꂽ^OɁAw肳ꂽƒlǉ
  *   InputXmlĈŁAVKXML𐶐Ȃ
  *
  * @param  Element     in_Element      INPUT XML̃[gGg
  * @param  String      map_file        MAPt@C     (XML `)
  * @param  Element     data_Element    DATA XML̃[gGg
  *
  * @return boolean     true() / false (s)
  *----------------------------------------------------------------------------
  *
  *  #InputFile
  *   
  *   <a name="top"> gbvy[W </a>
  *
  *  #MapFile
  *
  *   <MapAttr srcTag="a" srcKey="name" dataTag="PageData" dataKey="name">
  *       <MapAttrData inTag="URL" outAttr="hrer"/>
  *   </MapAttr>
  *
  *   srcTag  : inputFilẽ^O
  *   srcKey  : inputFilȇL[
  *   dataTag : dataFilẽ^O
  *   dataKey : dataFilȇL[
  *   inTag   : dataFilẽf[^^O
  *   outAttr : inputFileɒǉ鑮
  *
  *       L[FsrcKey̒ldataKey̒l
  *
  *  #DataFile
  *
  *   <PageData name="top">
  *     <URL>../topFrame.html</URL>
  *   </PageData>
  
  */
    public boolean Type1Xml(Element in_Element, String map_file, Element data_Element) throws RidException {

        boolean ret;
        MapperType1 mt1 = new MapperType1();
        ret  = mt1.Type1Xml(in_Element, map_file, data_Element);
        return ret;
    }

/**
  * (Mapper_Type2)
  *
  * ev[gt@CiHTML)<Rid_Tmp>^O
@* DATAhLg̒lɒuāAw肳ꂽt@Cɏo͂
  *
  * @param  String      in_file         INPUTt@C   (HTML`)
  * @param  Document@  data_doc        DATAhLg(XML `)
  * @param  String      out_file        OUTPUTt@C  (HTML`)
  *
  * @return boolean     true() / false (s)
  */
    public boolean Type2(String in_file, Document data_doc, String out_file)  throws RidException {

        boolean ret;
        MapperType2 mt2 = new MapperType2();
        ret  = mt2.Type2(in_file,  data_doc, out_file);
        return ret;
   }

    public boolean TypeScript(String in_file, Document data_doc, String out_file)  throws RidException {

        boolean ret;
        MapperType2 mt2 = new MapperType2();
        ret  = mt2.TypeScript(in_file,  data_doc, out_file);
        return ret;
   }

/**
  * (Mapper_Type3)
  *
  * ev[gt@CiHTML)<MapRepeat>^O
@* DATAhLg̒lɒuāAw肳ꂽt@Cɏo͂
  * <MapRepeat>---</MapRepeat>JԂ\
  *
  * @param  String      in_file         INPUTt@C   (HTML`)
  * @param  Document@  data_doc        DATAhLg(XML `)
  * @param  String      out_file        OUTPUTt@C  (HTML`)
  *
  * @return boolean     true() / false (s)
  */
    public boolean Type3(String in_file,  Document data_doc, String out_file) throws RidException {
        boolean ret;

        MapperType3 mt3 = new MapperType3();
        ret  = mt3.Type3(in_file,  data_doc, out_file);
        return ret;
    }

/**
  * G[bZ[W̐ݒ
  *
  * @param  String      errorString     G[bZ[W
  * @return void
  */
    private void setErrorString(String errorString) {
        pr_errorString = errorString;
    }

/**
  * G[bZ[W̎擾
  *
  * @return String      G[bZ[W
  */
    public String getErrorString() {
        return pr_errorString;
    }

}