/**
 * @(#)RImporter.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : Common Panel
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/08/09
 */
package jp.co.nri.rid.importer;

import java.io.*;
//import java.util.*;
//import java.io.IOException;

// W3C DOM
import	org.w3c.dom.*;

import	jp.co.nri.Rid;
import	jp.co.nri.rid.xml.*;
import	jp.co.nri.rid.table.editor.filter.*;
import	jp.co.iti.fagot.doc.DocManager;
import jp.co.nri.rid.error.*;
//import	jp.co.nri.rid.analyzer.*;

/* ITI */
import	jp.co.iti.fagot.ZApp;
import	jp.co.iti.fagot.util.*;

/**
 * hLgC|[gC|[^
 */

public class RDocumentImporter extends RImporter{
	protected static final String KEY		= "import.document";
	protected static final String KEY_DIR	= "rid.docs.dir";
	public RDocumentImporter() throws RidException{	super(KEY);	}
	protected	String	getPageType(){ return null; }
	
	/**
	 * C|[gȂB
	 * @since	1.00
	 */
	public void Import() throws RidException{
		String		projectdir	= ZInstance.prop().getProperty(Rid.PJ_DIR);
		ZResource	res			= ZApp.getTheApp().getResource();
		String		dir			= null;
		try{ 		dir			= projectdir + File.separator + res.getString(KEY_DIR); }
		catch(NullPointerException e){ throw new RidException(new RidMessage().Error(ERR_NotFoundResourceKeyI,KEY_DIR)); }
		Import(dir);
	}
	
	protected elementBooster topelement(){
		documentBooster document = new documentBooster((Document)ZInstance.map().get(Rid.DOCUMENT_DOCUMENT));
		return document.root().child(ZONEUNIT);
	}
	protected	String			getExtensionKey(){ return "import.document.extensions"; }
	protected	elementBooster	extensionNewUnit(elementBooster unit) throws RidException {	return unit; }
}
