/*
 * @(#)GenerateRefresht.java
 *
 * RID-X    : w^ŋTOPփtbVHTML𐶐
 *
 * @author    Intelligent Technology Inc.
 * @version   1.01 2001/12/21
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 */
package jp.co.nri.rid.generator;

import java.io.*;
import java.util.*;
import org.w3c.dom.*;


import jp.co.nri.rid.mapper.*;
import jp.co.nri.rid.error.*;
import jp.co.nri.rid.snapshot.*;


/**
 * tbVHTML𐶐
 */
public class GenerateRefresh extends GenerateParser {

/**
  * ftHgRXgN^
  */
    public GenerateRefresh() {
    }


/**
  * tbV̐
  *
  * @param  String        templateDir     ev[gt@CDir
  * @param  String        outDir          oDir
  * @param  String        html_name       tbVHTMLt@C
  * @return boolean true() / false (s)
  */
    public boolean generateRefresh(String templateDir, String outDir, String html_name) throws RidException, Exception {

        boolean ret = false;
        xcopy xc = new xcopy();
        RidMessage ridMsg = new RidMessage();

        // ev[gt@C
        String template = templateDir + File.separator + puTemplRefresh;
        if (!xc.fileExists(template)) {
            throw new RidException(ridMsg.Error("E4001", template));
        }

        //o̓t@C
        String out = outDir + File.separator + puOutRefresh;

        //f[^̐
        Document temp_data = generateRefreshData(html_name + puOutFrame);

        //HTML̐
        Mapper mapper = new Mapper();
        if( !mapper.Type2(template, temp_data, out)) {
            throw new RidException(ridMsg.Error("E4002",mapper.getErrorString()));
        }
        return true;
    }

/**
  * tbṼf[^
  *
  * @param  String      refresh_page       y[W̖O
  * @return Document    tbṼhg
  */
    private Document generateRefreshData(String refresh_page) throws Exception {

        String refresh_html;

        refresh_html = "<meta http-equiv=\"refresh\" content=\"0;URL=" + refresh_page + "\">";

        XmlUtil xu = new XmlUtil();
        Document doc = new org.apache.xerces.dom.DocumentImpl();
        Element topElem = doc.createElement(puRootTag);
        doc.appendChild(topElem);
        xu.createOrSetTextValue(topElem, "refresh", refresh_html);
        return doc;

    }
}
