/*
 * @(#)GenerateProduct.java
 *
 * RID-X    : Generator w
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/03/01
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 */
package jp.co.nri.rid.generator;



import java.io.*;
import java.util.*;
import org.w3c.dom.*;

import jp.co.nri.Ridual;
import jp.co.nri.rid.mapper.*;
import jp.co.nri.rid.snapshot.xcopy;
import jp.co.nri.rid.snapshot.erase;
import jp.co.nri.rid.error.*;

import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;
/**
 * Rid w
 */
public class GenerateProduct extends GenerateParser {

    /** rid.template.dirvpeB  **/
    final static public String RID_TEMPLATE_DIR = "rid.template.dir";
    /** rid.parts.dirvpeB  **/
    final static public String RID_PARTS_DIR    = "rid.parts.dir";
    /** rid.team.dirvpeB  **/
    final static public String RID_TEAM_DIR     = "rid.team.dir";
    /** rid.html.dirvpeB  **/
//    final static public String RID_HTML_DIR     = "rid.html.dir";
    /** rid.pagesvg.dirvpeB  **/
    final static public String RID_PAGESVG_DIR  = "rid.pagesvg.dir";

    /** TOP@URL  **/
    protected String pr_url;
    /** ev[gfBNg  **/
    protected String pr_templateDir;
    /** ev[g(p[c)fBNg  **/
    protected String pr_partsDir;
    /** o̓fBNg  **/
    protected String pr_outDir;
    /** htmlfBNg  **/
    protected String pr_htmlDir;
    /** SVGfBNg   **/
    protected String pr_svgDir;


/**
  * ftHgRXgN^
  */
    public GenerateProduct() {
        pr_url = "";                        // TOP@URL
        pr_templateDir = "";                // ev[gfBNg
        pr_partsDir    = "";                // ev[g(p[c)fBNg
        pr_outDir      = "";                // o̓fBNg
        pr_htmlDir     = "";                // htmlfBNg
        pr_svgDir      = "";                // SVGfBNg
    }


/**
  * w
  *
  * @param  Document    doc             hLg
  * @param  String      project_dir     vWFNgfBNg
  * @return boolean     true()/false(s)
  */
    public boolean generate(Document doc, String project_dir) throws RidException, Exception {

        boolean ret = false;
        RidMessage ridMsg = new RidMessage();

        //fBNg̎擾
        getDir(project_dir);

        //w̃fBNg̓e폜
        erase del = new erase();
        ret = del.directory(pr_outDir);
        if(!ret)  ZDebug.trace(ridMsg.Warning("W4003", pr_outDir));

        //document̉
        ProjectInfo  project_info = new ProjectInfo();
        project_info = documentParser(doc, "", parentPath(pr_outDir, pr_htmlDir));

        //w̐
        ret = generateProduct(project_info);

        return ret;
    }


/**
  * URL̎擾
  *
  * @return String      TOP URL
  */
    public String getUrl() {
        return pr_url;
    }


/**
  * TOP URL̎擾
  *
  * @return String      TOP URL
    public String getTopUrl(Document doc, String project_dir) throws RidException, Exception  {

        String url = "";

        //fBNg̎擾
        getDir(project_dir);

        //document̉
        ProjectInfo  project_info = new ProjectInfo();
        project_info = documentParser(doc, "", parentPath(pr_outDir, pr_htmlDir));

        ZoneInfo zone_info = project_info.zone;
        if (zone_info.page_lst.size() != 0) {
          PageInfo page_info = (PageInfo)zone_info.page_lst.elementAt(0);
          url = pr_outDir + File.separator + page_info.file + puOutFrame;
        } else {
          url = pr_outDir + File.separator + puBlank + puOutFrame;
        }
        return url;
    }
  */

/**
  * TOP URL̐ݒ
  *
  * @param  String      url             TOP URLw
  * @return void
  */
    private void setUrl(String url) {
        pr_url = url;
    }


/**
  * fBNg̎擾
  *
  * @param  String      project_dir   vWFNgfBNg
  * @return void
  */
    private void getDir(String project_dir) {

        ZResource res = ZApp.getTheApp().getResource();
                                         
        String template_dir = res.getString(RID_TEMPLATE_DIR);          // ev[gfBNg
        String parts_dir    = res.getString(RID_PARTS_DIR);             // ev[gfBNgip[cj
        String out_dir      = res.getString(RID_TEAM_DIR);              // o̓fBNg
//        String html_dir     = res.getString(RID_HTML_DIR);              // htmlfBNg
        String svg_dir      = res.getString(RID_PAGESVG_DIR);           // SVGfBNg

        pr_templateDir = project_dir + File.separator + template_dir;   // ev[gfBNg
        pr_outDir      = project_dir + File.separator + out_dir;        // o̓fBNg
//        pr_htmlDir     = project_dir + File.separator + html_dir;     // htmlfBNg
        pr_htmlDir     = Ridual.getHtmlDir();						    // htmlfBNg
        pr_partsDir    = project_dir + File.separator + parts_dir;      // ev[gfBNg
        pr_svgDir      = project_dir + File.separator + svg_dir;        // SVGfBNg
    }


/**
  * w̐
  *
  * @param  Document    doc             hLg
  * @return boolean     trueij/ falseisj
  */
    private boolean generateProduct(ProjectInfo project_info) throws Exception  {

        boolean ret = false;

        //Top Zone
        ZoneInfo zone_info = project_info.zone;

        String refresh;

        ret = productZone(zone_info, null);
        if (ret) {
            if (zone_info.page_lst.size() != 0) {
                //TOP URL
                PageInfo page_info = (PageInfo)zone_info.page_lst.elementAt(0);
                setUrl(page_info.url);
                refresh = page_info.name;
            } else {
                setUrl(pr_outDir + File.separator + puBlank + puOutFrame);
                refresh = puBlank;
            }
            
            //wp̃tbV쐬 
            GenerateRefresh gr = new GenerateRefresh();
            ret = gr.generateRefresh(pr_templateDir, pr_outDir, refresh);
        }
        return ret;
    }

/**
  * w@iZONE)
  *
  * @param  ZoneInfo    zone            Zone
  * @param  ZoneInfo    parent          Zone̐e
  * @return boolean     trueij/ falseisj
  */
    private boolean productZone(ZoneInfo zone, ZoneInfo parent) throws Exception {

        boolean ret = false;

        //fBNg̍쐬 ZonẽgbvȊO
        if (!zone.top) {
            xcopy xc = new xcopy();
            xc.makeDir(pr_outDir + File.separator + zone.file); 
        }

        //Page
        if (zone.page_lst.size() > 0) {
            //ZoneɃy[W݂
            for ( int i = 0; i < zone.page_lst.size(); i++ ) {
                PageInfo page_info = (PageInfo)zone.page_lst.elementAt(i);
                ret = productPage(zone, page_info);
                if (!ret) return false;
            }
        } else {
            //y[W݂Ȃꍇ́ABlankt[쐬
            productFrame( zone, null);
        }

        //Zone
        for ( int n = 0; n < zone.zone_lst.size(); n++ ) {
            ZoneInfo zone_info = (ZoneInfo)zone.zone_lst.elementAt(n);
            ret = productZone(zone_info, zone);
            if (!ret) return false;
        }

        // ir
        GenerateNavibar gn = new GenerateNavibar();
        ret = gn.generate(GenerateNavibar.PRODUCT, pr_templateDir, pr_outDir, zone, parent);
        return ret;
    }

/**
  * w@(PAGE)
  *
  * @param  String      zone_name       ZoneifBNgj
  * @param  PageInfo    page_info       y[W
  * @return boolean     trueij/ falseisj
  */
    private boolean productPage(ZoneInfo zone, PageInfo page) throws RidException, Exception {

        boolean ret = false;

        // t[̍쐬
        productFrame(zone, page);

        // |`G̐
        generateProductSample(page);

        // y[W̐
        generateProductInfo(page);

        // y[W̐(ł́Ay[WȂ)
        //GeneratePage gp = new GeneratePage();
        //gp.generate(pr_htmlDir, pr_templateDir, pr_partsDir, zone, page);

        return true;
    }


/**
  * w(t[)̐
  *
  * @param  String      zone_name       ZoneifBNgj
  * @param  PageInfo    page_info       y[W
  * @return boolean     trueij/ falseisj
  */
    private boolean productFrame(ZoneInfo zone, PageInfo page) throws RidException, Exception  {
        boolean ret = false;
        xcopy xc = new xcopy();
        RidMessage ridMsg = new RidMessage();

        // _frameProduct.htmlL
        String template = pr_templateDir + File.separator + puTemplProFrame;
        if ( !xc.fileExists(template) ){
            throw new RidException(ridMsg.Error("E4001", template));
        }

        // _frame_map.xmlL
        String map = pr_templateDir + File.separator + puMapFrame;
        if ( !xc.fileExists(map) ) {
            throw new RidException(ridMsg.Error("E4001", map));
        }

        // o̓t@C
        String out;
        if (page != null) {
            out = pr_outDir + File.separator + page.file + puOutFrame;
            page.url = out;
        } else {
            if (zone.top){
                out = pr_outDir + File.separator + puBlank + puOutFrame;
            } else {
                out = pr_outDir + File.separator + zone.file + File.separator + puBlank + puOutFrame;
            }
        }

        //Map Data̐
        Document map_data = generateFrameMapData(zone.name, page);


        // t[HTML@(Mapper=Template + Map + MapData)
        Mapper mapper = new Mapper();
        if( !mapper.Type1(template, map, map_data, out)) {
            throw new RidException(ridMsg.Error("E4002","Mapper" + mapper.getErrorString()));
        }

        return true;
    }

/**
  * f[^̐it[j
  *
  * @param  String      zone_name       Zone
  * @param  PageInfo    page_info       y[W
  * @return Document    hg
  */
    private Document generateFrameMapData(String zone_name, PageInfo page) throws Exception {

        XmlUtil xu = new XmlUtil();
        Element page_elem;
//        Attr attr;

        // hg
        Document doc = new org.apache.xerces.dom.DocumentImpl();
        Element topElem = doc.createElement(puRootTag);
        doc.appendChild(topElem);

        // ir
        String navi = zone_name + puTemplNavi;
        page_elem = xu.createSubElement(topElem, puMapFrameData);
		page_elem.setAttribute(puMapFrameDataKey, "navi");
//        attr = xu.createOrGetAttribute(page_elem, puMapFrameDataKey);
//        xu.createOrSetTextValue((Node)attr, "navi");
        xu.createOrSetTextValue(page_elem, puMapFrameInTag, navi);

        if (page != null) {
            // |`G
            String sample = page.name + puTemplSample;
            page_elem = xu.createSubElement(topElem, puMapFrameData);
			page_elem.setAttribute(puMapFrameDataKey, "sample");
//            attr = xu.createOrGetAttribute(page_elem, puMapFrameDataKey);
//            xu.createOrSetTextValue((Node)attr, "sample");
            xu.createOrSetTextValue(page_elem, puMapFrameInTag, sample);

            // y[W
            String info = page.name + puTemplInfo;
            page_elem = xu.createSubElement(topElem, puMapFrameData);

			page_elem.setAttribute(puMapFrameDataKey, "info");
//            attr = xu.createOrGetAttribute(page_elem, puMapFrameDataKey);
//            xu.createOrSetTextValue((Node)attr, "info");
            xu.createOrSetTextValue(page_elem, puMapFrameInTag, info);

            // C
            String html_file = replaceWebFileSeparator(page.path + File.separator + page.file);
            page_elem = xu.createSubElement(topElem, puMapFrameData);
			page_elem.setAttribute(puMapFrameDataKey, "main");
//            attr = xu.createOrGetAttribute(page_elem, puMapFrameDataKey);
//            xu.createOrSetTextValue((Node)attr, "main");
            xu.createOrSetTextValue(page_elem, puMapFrameInTag, html_file);
        }
        return doc;
    }


/**
  * w(y[W)̐
  *
  * @param  PageInfo    page            y[W
  * @return boolean     trueij/ falseisj
  */
    private boolean generateProductInfo(PageInfo page) throws RidException, Exception {

        boolean ret = false;
        xcopy xc = new xcopy();
        RidMessage ridMsg = new RidMessage();

        //ev[gt@C
        String template = pr_templateDir + File.separator + puTemplInfo;
        if ( !xc.fileExists(template) ) {
            throw new RidException(ridMsg.Error("E4001",template));
        }

        //o̓t@C
        String out = pr_outDir + File.separator + page.file + puOutInfo;

        // Map Data̐
        Document temp_data = generateInfoData(page);

        //XmlUtil xu = new XmlUtil();
        //xu.writeDocment2XMLFile(new File(".", "mapperType2.xml"), temp_data);

        // y[WHTML
        Mapper mapper = new Mapper();
        if(!mapper.Type2(template, temp_data, out)){
            throw new RidException(ridMsg.Error("E4002",mapper.getErrorString()));
        }
        return true;
    }



/**
  * f[^̐iy[Wj
  *
  * @param  PageInfo    page            y[W
  * @return Document    hLg
  */
    private Document generateInfoData(PageInfo page_info) throws Exception {

        XmlUtil xu = new XmlUtil();
        Document doc = new org.apache.xerces.dom.DocumentImpl();
        Element topElem = doc.createElement(puRootTag);
        doc.appendChild(topElem);

        // So
        for ( int i = 0; i < page_info.attr_lst.size(); i++ ) {
            Attribute attr = (Attribute)page_info.attr_lst.elementAt(i);
            xu.createOrSetTextValue(topElem, attr.name, attr.value);
        }
        return doc;
    }


/**
  * w(Sample)̐
  *
  * @param  PageInfo    page            y[W
  * @return boolean     trueij/ falseisj
  */
    private boolean generateProductSample(PageInfo page) throws RidException, Exception {

        boolean ret = false;
        xcopy xc = new xcopy();
        RidMessage ridMsg = new RidMessage();

        // SVGt@CL
        if (!page.svg.equals("")) {
            // SVGt@Cw肳ĂꍇAt@CRs[
            String in  = pr_svgDir + File.separator + page.svg;
            String out = pr_outDir + File.separator + page.file + puOutSvg;
            ret = xc.file(in, out);
        } else if (!page.doc.equals("")) {
            // DOCt@Cw肳ĂꍇAt@CRs[
            String docfile = Document2SampleFile(page.doc);
            String in  = pr_svgDir + File.separator + docfile;
            String out = pr_outDir + File.separator + page.file + "_" + docfile;
            ret = xc.file(in, out);
        }

        // _Sample.html̗Lf
        String template = pr_templateDir + File.separator + puTemplSample;
        if ( !xc.fileExists(template) ) {
          throw new RidException(ridMsg.Error("E4001",template));
        }

        // o̓t@C
        String out = pr_outDir + File.separator + page.file + puOutSample;

        // Map Data̐
        Document temp_data = generateSampleData(page);

        // |`GHTML
        Mapper mapper = new Mapper();
        if ( !mapper.Type2(template, temp_data, out) ) {
          throw new RidException(ridMsg.Error("E4002",mapper.getErrorString()));
        }

        return true;
    }


/**
  * f[^̐iSamplej
  *
  * @param  PageInfo    page            y[W
  * @return Document    hLg
  */
    private Document generateSampleData(PageInfo page) throws Exception {

        XmlUtil xu = new XmlUtil();
        Document doc = new org.apache.xerces.dom.DocumentImpl();
        Element topElem = doc.createElement(puRootTag);
        doc.appendChild(topElem);

        xu.createOrSetTextValue(topElem, "Title", page.name + puTemplSample);

        //SVG̗L
        if (!page.svg.equals("")) {
            //SVGt@C
            xu.createOrSetTextValue(topElem, "sample", 
              "<embed src=\"" + page.name + puOutSvg + 
              "\" height=\"300\" width=\"400\" type=\"image/svg-xml\" pluginspage=\"http://www.adobe.com/svg/viewer/install/\">");
        } else if (!page.doc.equals("")) {
            //DOCt@C
            String docfile = Document2SampleFile(page.doc);

	    /* 2002/12/19
	       t3-nishimura@nri.co.jp added */
	    String docWithoutPath = trimPath(page.file + "_" + docfile);

            xu.createOrSetTextValue(topElem, "sample", 
	    /* 2002/12/19
	       t3-nishimura@nri.co.jp replaced */
		//"<a href=\"" + page.file + "_" + docfile + "\" target=\"_blank\">" + page.file + "_" + docfile + "</a>");
		"<a href=\"" + docWithoutPath + "\" target=\"_blank\">" + docWithoutPath + "</a>");
        } else {
            //SVG/DOCt@CȂ
            xu.createOrSetTextValue(topElem, "sample", "<br><br><br><center> Now Thinking!</center>");
        }
       return doc;
    }

/**
  * PageUnitDoc琻wɃRs[hLgt@C߂iSamplej
  *
  * @param  String      docAttr         Doc
  * @return String      Rs[hLgt@C߂
  *
  *   hLgҏWp
  *     command.doc.app.n   = AvP[V
  *     command.doc.cmd.n   = AvP[VR}h
  *     command.doc.ext.n   = gq
  *     command.doc.view.n  = wpgq(ȗ)
  */
    private String Document2SampleFile(String docAttr) throws Exception {

        String filename = docAttr;
        String command;

        // gq擾
        String ext = getDocfileExt(docAttr);

        //\[Xt@CuEUR}h̃Xgݒ肷
        ZResource res = ZApp.getTheApp().getResource();

        for ( int i = 1; ; i++ ) {
            command = "command.doc.ext." + Integer.toString(i);
            String  doc_ext = res.getString(command);
            // gq̎w肪ꍇI
            if ( isNullString(doc_ext) ) break;

            // DOC̃t@CƓgq̏ꍇ

            // DOC̃t@CƊgqT
            if (doc_ext.equalsIgnoreCase(ext)) {
                // DOC̃t@CƓgq̏ꍇ

                // wpgq擾
                command = "command.doc.view." + Integer.toString(i);
                String  doc_view = res.getString(command);

                // null͏ȗ("")
                if ( !isNullString(doc_view) ) {
                    filename = getDocfileName(docAttr) + "." + doc_view;
                }
                break;
            } 
        }
        return filename;
  }

/**
  * hLgt@Cgq߂iSamplej
  *
  * @param  String      docAttr         Doc
  * @return String      gq
  */
    private String getDocfileExt(String filename) throws Exception {

        String ext="";

        int pos = filename.indexOf(".");

        if (pos != -1) {
            ext = filename.substring(pos+1);
        }
        return ext;
    }
/**
  * hLgt@Ct@C߂iSamplej
  *
  * @param  String      docAttr         Doc
  * @return String      t@C
  */
    private String getDocfileName(String filename) throws Exception {

        String name=filename;

        int pos = filename.indexOf(".");

        if (pos != -1) {
            name = filename.substring(0,pos);
        }
        return name;
    }


    /**
     * t@CpXƂ菜ĕԂ
     *
     * @param fileName pX菜t@C
     * @return pX菜ꂽt@C
     * @author t3-nishimura@nri.co.jp
     */
    private String trimPath(String fileName){

	int pos = fileName.lastIndexOf("/");
	if (pos == fileName.length()) {
	    return "";
	}
	return fileName.substring(pos + 1);
    }
}
