/*
 * @(#)GenerateParser.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : XMLt@C̉
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/05/13
 */
package jp.co.nri.rid.generator;


import java.io.*;
import java.util.*;
import org.w3c.dom.*;
import org.apache.xpath.XPathAPI;

import jp.co.nri.rid.mapper.*;

import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;

/* t3-nishimura@nri added */
import jp.co.nri.rid.xml.elementBooster;

/**
 * XMLt@C̉
 */
public class GenerateParser {

    /* RCS ID */
    private static final String RCSID =
        "$Id: GenerateParser.java,v 1.3 2003/01/24 15:21:18 nsmr Exp $";

    // Project Information
    class ProjectInfo {
        ZoneInfo      zone;                 // _top ZoneUnit
    }

    // Zone Information
    class ZoneInfo {
        boolean       top;                  // TOP_ZONE̔f(true:top / false :topȊO)
        String        name;                 // fBNg
        String        file;                 // HTMLfBNg̑΃pX
        String        title;                // ^Cg
        String        template1;            // ev[gt@CP
        String        template2;            // ev[gt@CQ
        String        parent;               // TOPւ̃pX
        Vector        attr_lst;             // S̃Xg
        Vector        page_lst;             // page_info Xg
        Vector        zone_lst;             // zone_info Xg
        Vector        resource_lst;         // resource_info Xg
        Vector        document_lst;         // resource_info Xg

	// t3-nishimura@nri added
	elementBooster element;             // element ̎
    }

    // Page Information
    class PageInfo {
        String        name;                 // y[W
        String        file;                 // HTMLfBNg̑΃pX
        String        title;                // ^Cg
        String        url;                  // URLiuEUŕ\ۂ̃pXj
        String        path;                 // [HTML]fBNgւ̃pX
        String        svg;                  // SVGt@C Data\_svgfBNg̃t@C
        String        doc;                  // t@C Data\_svgfBNg̃t@C
        Vector        attr_lst;             // S̃Xg

	// t3-nishimura@nri added
	elementBooster element;             // element ̎
    }

    // Resource Information
    class ResourceInfo {
        Vector        attr_lst;             // S̃Xg
    }

    // Document Information
    class DocumentInfo {
        Vector        attr_lst;             // S̃Xg
    }

    // Attribute Information
    class Attribute {
        String        name;                 // 
        String        value;                // l
    }

    /** w̃fBNg **/
    static final String puProductDir      = "PortalTeam";
    /** ŋ̃fBNg **/
    static final String puPresentDir      = "PortalPublic";

    /** t[ev[giwj**/
    static final String puTemplProFrame   = "_frameProduct.html";
    /** t[ev[giŋj**/
    static final String puTemplPreFrame   = "_framePresent.html";
    /** irev[g**/
    static final String puTemplNavi       = "_navi.html";
    /** |`Gev[g**/
    static final String puTemplSample     = "_sample.html";
    /** y[Wev[g**/
    static final String puTemplInfo       = "_info.html";
    /** y[Wev[g**/
    static final String puTemplPage       = "_page.html";
    /** TCg}bvev[g**/
    static final String puTemplSitemap    = "_sitemap.html";
    /** tbVev[g**/
    static final String puTemplRefresh    = "_refresh.html";

    /** 󔒃t[  **/
    static final String puBlank           = "Blank";

    /** MAPt@C t[l`o **/
    static final String puMapFrame        = "_frame_map.xml";
    /** MAPt@C frame_data  **/
    static final String puMapFrameData    = "frame_data";
    /** MAPt@C name **/
    static final String puMapFrameDataKey = "name";
    /** MAPt@C src **/
    static final String puMapFrameInTag   = "src";

    /** o͎̕tit[o̓t@Cj **/
    static final String puOutFrame        = "_frame.html";
    /** o͎̕tiiro̓t@Cj **/
    static final String puOutNavi         = "_navi.html";
    /** o͎̕ti|`Go̓t@Cj **/
    static final String puOutSample       = "_sample.html";
    /** o͎̕tiSVGo̓t@Cj **/
    static final String puOutSvg          = "_svg.svg";
    /** o͎̕tiy[Wo̓t@Cj **/
    static final String puOutInfo         = "_info.html";
    /** o͎̕titbVt@Cj **/
    static final String puOutRefresh      = "html_navi.html";
    /** o͎̕tiTCg}bvt@Cj **/
    static final String puOutSitemap      = "_ridSitemap.html";

    /** Mapper[Data.xml]root^O  **/
    static final String puRootTag         = "RidProject";         

    /**@RidProject̒` **/
    private static final String pf_rootTag      = "RidProject";
    /**@ZoneUnit̒` **/
    private static final String prZoneUnit      = "ZoneUnit";
    /**@PageUnit̒` **/
    private static final String prPageUnit      = "PageUnit";
    /**@ResourceUnit̒` **/
    private static final String prResourceUnit  = "ResourceUnit";
    /**@DocumentUnit̒` **/
    private static final String prDocumentUnit  = "DocumentUnit";
    /**@Name̒` **/
    private static final String prNameAttr      = "Name";
    /**@File̒` **/
    private static final String prFileAttr      = "File";
    /**@Title̒` **/
    private static final String prTitleAttr     = "Title";
    /**@Svg̒` **/
    private static final String prSvgAttr       = "Svg";
    /**@Doc̒` **/
    private static final String prDocAttr       = "Doc"; 
    /**@Template1̒` **/
    private static final String prTemplate1Attr = "Template1";
    /**@Template2̒` **/
    private static final String prTemplate2Attr = "Template2";
    /**@PageType̒` **/
    private static final String prPageTypeAttr  = "PageType";

    /** efBNg̃pX  **/
    private static final String prParentPath   = "..";

    /** ǔ΂̐擪  **/
    private String[] prIgnoreLst;

/**
  * ftHgRXgN^
  */
    public GenerateParser() { }


/**
  * hLg
  *
  * @param  Document    doc             hLg
  * @param  String      parent          o̓fBNg
  * @param  String      path            HTMLfBNg
  * @return void
  */
    public  ProjectInfo documentParser(Document doc, String parent, String path) throws Exception {

        // Project General Information
        ProjectInfo  project_info = new ProjectInfo();

        ZoneInfo zone_info = new  ZoneInfo();
        boolean ret = false;

        // ǔ΂擾
        prIgnoreLst = getIgnore();

        //[g̃Gg擾
        Element root_elem = doc.getDocumentElement();
        ret = checkRootElement(root_elem, pf_rootTag);
        if (ret){

            // TOP Zone̎擾
            Element zone_elem = (Element)XPathAPI.selectSingleNode(root_elem, prZoneUnit);
            if ( zone_elem != null) {
                // ZoneUnit̉
                // RidProject̔zɂ ZONEUNIT1݂Ȃ̂łꂪ TOP
                zone_info = zoneParser(zone_elem, parent, path, true);
                // Top ZoneUnit̐ݒ
                project_info.zone = zone_info;
            }
        }
        return project_info;
   }

/**

  * String^mtkkf
  *
  * @param  String      str           t@C
  * @return boolean     true (null)/false(not null)
  */
    public boolean isNullString(String str) throws Exception {

        boolean ret;
        if ( (str == null) || (str.equals("")) ) {
            ret = true;
        } else {
            ret = false;
        } 
        return ret;
    }

/**
  * VXeftHg̃pX̋؂蕶"/"ɕϊ
  *
  * @param  String      navitePath      pX
  * @return void
  */
    public String replaceWebFileSeparator(String path) {
        return path.replace(File.separatorChar, '/');
    }

/**
  * [o̓fBNg][HTML]ւ̃pX
  *
  * @param  String      outDir          o̓fBNg
  * @param  String      htmlDir         HTMLfBNg
  * @return String      [o̓fBNg][HTML]ւ̃pX
  */
    public String parentPath(String outDir, String htmlDir) throws Exception {

        int i, pos, p_out, p_html;
        String  outDirUpper  = outDir.toUpperCase();
        String  htmlDirUpper = htmlDir.toUpperCase();
        String  htmlPath = "", outPath = "", outParentPath = "";

        p_out   = outDirUpper.length();
        p_html  = htmlDirUpper.length();
        if ( p_out < p_html) {
            pos = p_out;
        } else {
            pos = p_html;
        }

        for ( i = 0; i < pos; i++ ) {
            if(  outDirUpper.charAt(i) != htmlDirUpper.charAt(i)) {
                break;
            }
        }
        htmlPath = htmlDir.substring(i);
        outPath  = outDir.substring(i);

        if (outPath.length() != 0) {
            outParentPath = prParentPath;
            for ( i = 0; i < outPath.length(); i++ ) {
                if(outPath.charAt(i) == File.separatorChar) {
                    outParentPath = outParentPath + File.separator + prParentPath;
                }
            }
            outParentPath = outParentPath + File.separator + htmlPath;
        }

        return outParentPath;
   }

/**
  * ZoneUnit̉
  *
  * @param  Element     elem            ZoneUnitElement
  * @return ZoneInfo    ZoneUnit̏
  */
    private ZoneInfo zoneParser(Element elem, String parent, String path, boolean top) throws Exception {

        //ZoneUnit̑擾
        Vector attr_lst = setAttributes(elem, prZoneUnit);

        //qZoneUnit̎擾
        Vector  zone_lst = new Vector();
        NodeList zone_elem_lst = XPathAPI.selectNodeList(elem, prZoneUnit);
        for ( int n = 0; n < zone_elem_lst.getLength(); n++ ) {
            Element zone_elem = (Element)zone_elem_lst.item(n);
            ZoneInfo zone = zoneParser(zone_elem, (prParentPath + File.separator + parent), (prParentPath + File.separator + path), false);
            if (zone != null) zone_lst.add(zone);
        }

        ZoneInfo zone_info = new  ZoneInfo();
        String name = getAttributeValue(attr_lst, prNameAttr);
        if ( !(IsIgnore(name)) ) {
            zone_info.top          = top;
            zone_info.name         = name;
            zone_info.file         = getAttributeValue(attr_lst, prFileAttr);
            zone_info.title        = getAttributeValue(attr_lst, prTitleAttr);
            zone_info.template1    = getAttributeValue(attr_lst, prTemplate1Attr);
            zone_info.template2    = getAttributeValue(attr_lst, prTemplate2Attr);
            zone_info.parent       = parent;
            zone_info.attr_lst     = attr_lst;
            zone_info.page_lst     = pageLst(elem, path);
            zone_info.zone_lst     = zone_lst;
            zone_info.resource_lst = resourceLst(elem);
            zone_info.document_lst = documentLst(elem);
	    zone_info.element      = new elementBooster(elem);
        } else {
            zone_info =null;
        }

        return zone_info;
   }

/**
  * PageUnit̃Xg
  *
  * @param  Element     elem            PageUnitElement
  * @return PageInfo    PageUnit̏
  */
    private Vector pageLst(Element elem, String path) throws Exception {

        //PageUnit̃Xg
        Vector page_lst = new Vector();

        //Top Pagě
        Element topPage = zoneTopPageUnit(elem);

        //PageUnit̎擾
        NodeList page_elem_lst = XPathAPI.selectNodeList(elem, prPageUnit);
        for ( int i = 0; i < page_elem_lst.getLength(); i++ ) {
            Element page_elem = (Element)page_elem_lst.item(i);
            PageInfo page = pageParser(page_elem, path);

            if (page != null) {
                //top PageUnit̏ꍇ͐擪ɒǉ
                if (page_elem == topPage) {
                    page_lst.add(0, page);
                } else {
                    page_lst.add(page);
                }
            }
        }

        return page_lst;
    }
/**
  * PageUnit̉
  *
  * @param  Element     elem            PageUnitElement
  * @return PageInfo    PageUnit̏
  */
    private PageInfo pageParser(Element elem, String path) throws Exception {

        // PageUnit̑l擾
        Vector  attr_lst = new Vector(); 
        attr_lst = setAttributes(elem, prPageUnit);

        PageInfo page = new  PageInfo();
        String name  = getAttributeValue(attr_lst, prNameAttr);
        String ptype = getAttributeValue(attr_lst, prPageTypeAttr);

        // NameIgnoreL[łȂAPageType"server"Ŗ
        if ( !(IsIgnore(name)) && !(ptype.equals("server"))) {
            page.name     = name;
            page.attr_lst = attr_lst;
            page.file     = getAttributeValue(attr_lst, prFileAttr);
            page.title    = getAttributeValue(attr_lst, prTitleAttr);
            page.svg      = elem.getAttribute(prSvgAttr);
            if (page.svg == null) page.svg = "";
            page.doc      = elem.getAttribute(prDocAttr);
            if (page.doc == null) page.doc = "";
            page.path     = path;
	    page.element  = new elementBooster(elem);
        } else {
            page = null;
        } 
        return page;
   }

/**
  * ResourceUnit̃Xg
  *
  * @param  Element     elem            Element
  * @return ResourceInfo    ResourceInfõXg
  */
    private Vector resourceLst(Element elem) throws Exception {

        //ResourcẽXg
        Vector  resource_lst  = new Vector();

        //Resource̎擾
        NodeList resource_elem_lst = XPathAPI.selectNodeList(elem, prResourceUnit);
        for ( int i = 0; i < resource_elem_lst.getLength(); i++ ) {
            Element resource_elem = (Element)resource_elem_lst.item(i);
            ResourceInfo resource = resourceParser(resource_elem);
            resource_lst.add(resource);
        }
        return resource_lst;
    }


/**
  * ResourceUnit̉
  *
  * @param  Element     elem            ResourceUnitElement
  * @return ResourceInfo    ResourceInfȍ
  */
    private ResourceInfo resourceParser(Element elem) throws Exception {

        // ResourceUnit̑l擾
        ResourceInfo resource = new  ResourceInfo();
        resource.attr_lst = setAttributes(elem, prResourceUnit);
        return resource;
   }


/**
  * DocumentUnit̃Xg
  *
  * @param  Element     elem            PageUnitElement
  * @return Vector      DocumentUnit̃Xg
  */
    private Vector documentLst(Element elem) throws Exception {

        //Document̃Xg
        Vector  document_lst  = new Vector();

        //Document̎擾
        NodeList document_elem_lst = XPathAPI.selectNodeList(elem, prDocumentUnit);
        for ( int i = 0; i < document_elem_lst.getLength(); i++ ) {
            Element document_elem = (Element)document_elem_lst.item(i);
            DocumentInfo document = documentParser(document_elem);
            document_lst.add(document);
        }
        return document_lst;
    }

/**
  * DocumentUnit̉
  *
  * @param  Element     elem            PageUnitElement
  * @return DocumentUnit    DocumentUnit̏
  */
    private DocumentInfo documentParser(Element elem) throws Exception {

        // DocumentUnit̑l擾
        DocumentInfo document = new  DocumentInfo();
        document.attr_lst = setAttributes(elem, prDocumentUnit);
        return document;
   }


/**
  * UNIT̑擾
  *
  * @param  Element     elem            UNITElement
  * @param  String      unit_name       Unit
  * @return Vector      ̃Xg
  */
    private Vector setAttributes(Element elem, String unit_name) throws Exception {

        Vector  attr_lst = new Vector(); 

        // UNIT̑ꗗ擾
        ZProperties prop  = DocManager.loadProperty( DocManager.ELEMENT );
        String[] attrs = ZString.tokenize(prop.getProperty(unit_name + ".attributes"));

        // Alݒ
        for (int nAt = 0 ; nAt < attrs.length ; nAt++) {

            Attribute Attr = new Attribute();
            Attr.name   = attrs[nAt];
            Attr.value  = elem.getAttribute(attrs[nAt]);

            if (-1 == attr_lst.indexOf(Attr))
                attr_lst.add((Attr));
        }
        return attr_lst;
    }

/**
  * ̃Xgw肳ꂽ̒l擾(啶̋ʂȂ)
  *
  * @param  Vector      attr_lst        ̃Xg
  * @param  String      attr_name       
  * @return String      w肳ꂽ̒l / ݂Ȃꍇ""
  */
    private String getAttributeValue(Vector attr_lst, String attr_name) throws Exception {

        String attrValue = "";
        for ( int i = 0; i < attr_lst.size(); i++ ) {
            Attribute attr = (Attribute)attr_lst.elementAt(i);
            if (attr.name.equalsIgnoreCase(attr_name)) {
                attrValue = attr.value;
                break;
            }
        }

        return attrValue;
    }

/**
  * XMLt@CRIDpXMLt@CA[g^OŃ`FcNs
  *
  * @param  Element     root_elem       [gGg
  * @param  String      root_tag        [g^O
  *
  * @return boolean true / false
  */
    private boolean checkRootElement(Element root_elem, String root_tag) throws IOException, Exception {

        if ( root_elem.getNodeName().compareTo(root_tag) != 0 ) {
            ZDebug.trace("is not XML file for RID...");
            return false;
        }
        return true;
    }


/**
  * ZoneTop@PageUniť
  *
  * @param  Element     elem            ZoneUnitElement
  * @return ZoneInfo    ZoneUnit̏
  */
    private Element zoneTopPageUnit(Element elem) throws Exception {

        Element  pageElem = null;

        // ZoneUnitElement̒ 
        String  top = elem.getAttribute("Top");
        
        //Top Attribute݂Ȃꍇ́A
        if ( !isNullString(top) ) {
            //Top݂ꍇ
            pageElem = (Element)XPathAPI.selectSingleNode(elem, "PageUnit[@File='" + top + "']");
        } else {
            //FileName[index.html]̃y[W擾
            pageElem = (Element)XPathAPI.selectSingleNode(elem, "PageUnit[@Name='index.html']");

            //null ̏ꍇ FileName[index.html]̃y[W擾
            if (pageElem == null){
                //FileName[index.html]̃y[W擾
                pageElem = (Element)XPathAPI.selectSingleNode(elem, "PageUnit[@Name='index.htm']");
            }
        }

        return pageElem;
    }


/**
  * Resourcet@C[rid.ignore.prefix]擾
  *
  * @return String[]    Xg
  */
    private String[] getIgnore() throws Exception {

        ZResource res = ZApp.getTheApp().getResource();
        String ignore = res.getString("rid.ignore.prefix");
        String[] ignore_lst = ZString.tokenize(ignore);
        return (ignore_lst);
    }


/**
  * [ignore.prefix]̔f
  *
  * @param  String      unitname        UNIT
  * @return boolean     true(ignore.prefix) / false(ignore.prefixȂ)
  */
    private boolean IsIgnore(String unitname) throws Exception {
        for (int n = 0 ; n < prIgnoreLst.length ; n++) {
            if (unitname.startsWith(prIgnoreLst[n])) {
                return true;
            }
        }
        return false;
    }

}
