/*
 * @(#)ExportDialog.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : ExportDialog
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/11/07
 */
package jp.co.nri.rid.export;

import java.io.*;
import java.util.*;
import java.text.*;
import java.net.URL;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

/**
 * Rid Export Dialog
 */
public class ExportDialog extends JDialog {

    public JFrame mFrame;
    public String mDialogName ;
    public boolean mIsOK = false ;
    protected JComponent mComponent = null ;
    protected JButton    mOk     = null ;

    /**
      * RXgN^
      * @param app     AvP[V
      * @param szName  _CAO
      */
      public ExportDialog(JFrame frame, String title) {

          super(frame, false);

          // AvP[V̐ݒ
          mFrame      = frame ;
          mDialogName = title;

          //^Cg\
          setTitle();
          setLayout();
      }

    /**
      * [_s
      */
    public boolean doModal() {
      setModal(true);

      // ʒɕ\
      pack();
      Dimension dim = getToolkit().getScreenSize();
      setLocation( dim.width/2 - getWidth()/2, dim.height/2 - getHeight()/2 );
      
      //ʕ\
      show();
  
      // OK{^ꂽH
      return isOK() ;
    }

    /**
      * OK{^ꂽH
      */
    public boolean isOK() {
      return mIsOK;
    }

  //## EBhEݒ ###############################################
  /**
     * ^Cg̕\,ACR̕\
   */
  protected void setTitle() {
    // ^Cg̕\
    setTitle( mDialogName );
  }

  /**
   * _CAȌI
   * ~{^ꂽƂɌĂяoB
   */
  public void hide() {
    super.hide();
  }

  public void setLayout(){
      
  }


    //## ANV ###################################################
    /**
      * uOKv{^
      */
      public void onOK() {
        mIsOK = true;
        setVisible(false);
      }

    /**
      * ʐݒ
      * @param szItem {^
      */
      public void setControlPanel(JComponent cmp) {

          JPanel control = createControlPanel();

          getContentPane().setLayout(new BorderLayout());
          getContentPane().add(cmp,     BorderLayout.CENTER );
          getContentPane().add(control, BorderLayout.SOUTH );
      }

    /**
      * ʐݒ
      * @param szItem {^
      */
      public JPanel createControlPanel() {

          JPanel  panel     = new JPanel();

          mOk     = new JButton("Ok");
          mOk.addActionListener(
              new ActionListener() {
                  public void actionPerformed(ActionEvent e) { onOK(); }
              }
          );
          panel.add( mOk );
          return panel;
      }


  //## vpeB擾 ###############################################

  /**
     * _CAO̎擾
   */
  public String getDialogName() {
      return mDialogName;
  }

  /**
   * OK{^̎擾
   */
  public JButton getOKButton() {
  return mOk;
  }

  /**
   * OK{^̕ݒ
   */
  public void setOkText(String value) {
      mOk.setText(value);
  }

  /**
   * OK{^̕ݒ
   */
  public String getOkText() {
      return mOk.getText();
  }

  /**
     * R|[lg̎擾
   */
  public JComponent getComponent() {
  return mComponent;
  }

}

