/*
 * @(#)EnvRadioText.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : WI{^
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/01/29
 */
package jp.co.nri.rid.environment;

import java.util.Enumeration;
import jp.co.iti.fagot.ZApp;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

import java.io.File;

/**
 *  WI{^t̂Q̃eLXg̓IuWFNg
 */
public class EnvRadioText extends JPanel {

    /** pl **/
    protected JPanel        mPanel = null;
    /** ̓GAP**/
    protected JTextField    mText1 = null;
    /** ̓GAQ**/
    protected JTextField    mText2 = null;
    /** {^P**/
    protected JButton       mBCmd1 = null;
    /** {^Q**/
    protected JButton       mBCmd2 = null;
    /** {^O[v **/
    protected ButtonGroup   mGroup = new ButtonGroup();
 
   /**
      *  WI{^t̂Q̃eLXg̓IuWFNg
      * 
      * @param  String      value1          eLXgP
      * @param  String      value2          eLXgQ
      */
    public EnvRadioText(String value1,  String value2) {

        // pl̐
        mPanel = new JPanel();

        // LayoutuGridBagLayoutvɂ
        GridBagLayout mLayout = new GridBagLayout();
        mPanel.setLayout(mLayout);

        // Layout̍쐬
        GridBagConstraints gbc = new GridBagConstraints();

        // JRadioButton̐
        JRadioButton radio1 = new JRadioButton();
        mGroup.add(radio1);
        mPanel.add(radio1);
        gbc.anchor  = GridBagConstraints.NORTHWEST;
        gbc.weightx = 0.0;
        gbc.gridy   = 0;
        gbc.gridx   = 0;
        mLayout.setConstraints(radio1, gbc);

        // TextField̐
        mText1 = new JTextField(value1);
        mPanel.add(mText1);

        gbc.fill    = GridBagConstraints.BOTH;
        gbc.weightx = 1.0;
        gbc.gridx   = 1;
        gbc.gridy   = 0;
        mLayout.setConstraints(mText1, gbc);

        //Command fileChooser
        gbc.weightx = 0.0 ;
        gbc.gridx   = 2;
        gbc.gridy   = 0;
        mBCmd1 = new JButton("...");
        mLayout.setConstraints(mBCmd1, gbc);
        mPanel.add( mBCmd1 );
        mBCmd1.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent e) { fileChooser(1); }
            }
        );

        // JRadioButton̐
        JRadioButton radio2 = new JRadioButton();
        mGroup.add(radio2);
        mPanel.add(radio2);
        gbc.anchor  = GridBagConstraints.NORTHWEST;
        gbc.weightx = 0.0;
        gbc.gridy   = 1;
        gbc.gridx   = 0;
        mLayout.setConstraints(radio2, gbc);


        // TextField̐
        mText2 = new JTextField(value2);
        mPanel.add(mText2);

        gbc.fill    = GridBagConstraints.BOTH;
        gbc.weightx = 1.0;
        gbc.gridx   = 1;
        gbc.gridy   = 1;
        mLayout.setConstraints(mText2, gbc);

        //Command fileChooser
        gbc.weightx = 0.0 ;
        gbc.gridx   = 2;
        gbc.gridy   = 1;
        mBCmd2 = new JButton("...");
        mLayout.setConstraints(mBCmd2, gbc);
        mPanel.add( mBCmd2 );
        mBCmd2.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent e) { fileChooser(2); }
            }
        );
    }


    /**
      *  WI{^ݒ肷
      * 
      * @param  int         selected        
      * @return void
      */
    public void setSelected( int selected ){
      int i = 0;
      Enumeration elm = mGroup.getElements();
      while ( elm.hasMoreElements() ) {
          JRadioButton radio = (JRadioButton)elm.nextElement();
          if (i == selected) {
              radio.setSelected( true ) ;
          } else {
              radio.setSelected( false ) ;
          }
          i++;
      }
    }

    /**
      *  WI{^̏Ԃ擾
      *
      * @return 0:Text1 / 1:Text2
      */
    public int getSelected(){
        int i = 0;
        Enumeration elm = mGroup.getElements();
        while ( elm.hasMoreElements() ) {
            JRadioButton radio = (JRadioButton)elm.nextElement();
            if ( radio.isSelected() ) return i;
            i++;
        }
        return i;
    }


    /**
      *  Text1ɒlݒ肷
      * 
      * @param  String      szValue         eLXg
      * @return void
      */
      public void setString1( String szValue ){
          mText1.setText( szValue );
      }

    /**
      *  Text1ɒl擾
      * 
      * @return String      
      */
      public String getString1(){
          String szTmp = mText1.getText();
          if ( szTmp == null || szTmp.equals("") ) {  return null;  }
          return szTmp;
      }


    /**
      *  Text2ɒlݒ肷
      * 
      * @param  String      szValue         eLXg
      * @return void
      */
      public void setString2( String szValue ){
          mText2.setText( szValue );
      }

    /**
      *  Text2ɒl擾
      * 
      * @return String      
      */
      public String getString2(){
          String szTmp = mText2.getText();
          if ( szTmp == null || szTmp.equals("") ) {  return null;  }
          return szTmp;
      }

    /**
      *  Text1JTextField擾
      * 
      * @return JTextField
      */
    public JTextField getTextFieldl1(){
        return mText1;
    }

    /**
      *  Text2JTextField擾
      * 
      * @return JTextField
      */
    public JTextField getTextFieldl2(){
        return mText2;
    }

    /**
      *  plJPanel擾
      * 
      * @return JPanel
      */
    public JPanel getPanel(){
        return mPanel;
    }

    /**
      *  fileChooser𐶐
      * 
      * @param  int         index           1:Text1/2:Text2
      * @return void
      */
    public void fileChooser(int index) {

        String value = "";
        if (index == 1)
            value = getString1();
        else
            value = getString2();

        // FileChooser
        EnvFileChooser fileChooser = new EnvFileChooser();
        String szFile = fileChooser.show(ZApp.getTheApp().getFrame(), value, JFileChooser.FILES_AND_DIRECTORIES);
        if (szFile != null) {
            // [OK]{^̏ꍇA
            if (index == 1) {
                setString1( szFile );
            } else {
                setString2( szFile );
            }
        }
    }
}
