/*
 * @(#)EnvRadioButton.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : WI{^
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/01/29
 */
package jp.co.nri.rid.environment;

import java.util.Enumeration;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

/**
  * WI{^
  **/
public class EnvRadioButton extends JPanel {

    /** pl**/
    protected JPanel        mPanel = null;
    /** {^O[v **/
    protected ButtonGroup   mGroup = new ButtonGroup();
 
  /**
    * WI{^
    */
    public EnvRadioButton() {
        //pl̐
        mPanel = new JPanel();
        FlowLayout  layout = new FlowLayout(FlowLayout.LEFT);
        mPanel.setLayout(layout);
    }

  /**
    * WI{^̏Ԃݒ肷
    *
    * @param  String      value           WI{^̃x
    * @return void
    */
    public void setString( String value ){
      if ( value == null ) {
          value = "None";
      }
      Enumeration elm = mGroup.getElements();
      while ( elm.hasMoreElements() ) {
          JRadioButton radio = (JRadioButton)elm.nextElement();
          if ( radio.getText().equals( value ) ) {
              radio.setSelected( true ) ;
          } else {
              radio.setSelected( false ) ;
          }
      }
    }

  /**
    * WI{^̏Ԃ擾
    *
    * @return IĂ{^̃x
    */
    public String getString(){
        Enumeration elm = mGroup.getElements();
        while ( elm.hasMoreElements() ) {
            JRadioButton radio = (JRadioButton)elm.nextElement();
            if ( radio.isSelected() ) {
                if ( radio.getText().equals("None") ) {
                    return null;
                } else {
                    return radio.getText() ;
                }
            }
        }
        return null;
    }

  /**
    * WI{^ǉ
    *
    * @param  String      szLabel         WI{^̃x
    * @return void
    */
    public void addItem(String szLabel){
        JRadioButton radio = new JRadioButton( szLabel );
        mGroup.add(radio);
        mPanel.add(radio);
    }

  /**
    * pl擾
    *
    * @return JPanel
    */
    public JPanel getPanel(){
        return mPanel;
    }


}
