/*
 * @(#)EnvDocmentList.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : w̃TvhLg
 *
 * @author  Intelligent Technology Inc.
 * @version 1.00 2002/05/07
 */
package jp.co.nri.rid.environment;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.util.*;

import jp.co.nri.rid.error.*;


import javax.swing.JComponent;
import javax.swing.JColorChooser;
import jp.co.iti.fagot.util.ZGraphicUtil;

import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.util.ZResource;

/**
  *w̃TvhLg
  **/
public class EnvDocumentList extends JPanel {

    /** pl **/
    protected JPanel              mPanel    = null;
    /** Xgpl **/
    protected JScrollPane         mSPanel   = null;
    /** {^pl **/
    protected JPanel              mBPanel   = null;
    /** Xg **/
    protected JList               mList     = null;
    /** VK{^ **/
    protected JButton             mJBNew    = null;
    /** ҏW{^ **/
    protected JButton             mJBEdit   = null;
    /** 폜{^ **/
    protected JButton             mJBDel    = null;
    /** hLgz **/
    protected Vector              mDtLst    = null;
    /** [h **/
    protected DefaultListModel    mModel    = null;
    /** ύXǑ **/
    protected int                 mListCnt  = 0;

/**
  *  hLgXg̐
  */
    public EnvDocumentList() throws Exception {

        // pl̐
        mPanel = new JPanel();

        // LayoutuGridBagLayoutvɂ
        GridBagLayout mLayout = new GridBagLayout();
        mPanel.setLayout(mLayout);

        // Layout̍쐬
        GridBagConstraints gbc = new GridBagConstraints();

        //Document List
        crtDocList();
        gbc.anchor  = GridBagConstraints.NORTHWEST;
        gbc.fill    = GridBagConstraints.BOTH;
        gbc.gridx   = 0;
        gbc.gridy   = 0;
        gbc.weightx = 1.0;
        mLayout.setConstraints(mSPanel, gbc);
        mPanel.add(mSPanel);

        //{^pl
        crtButtonPanel(mLayout, gbc);
        gbc.gridx   = 1;
        gbc.gridy   = 0;
        mLayout.setConstraints(mBPanel, gbc);
        mPanel.add(mBPanel);

    }


/**
  * LIST̐
  *
  */
    public void crtDocList() throws Exception {

        // Xg̐
        mModel = new DefaultListModel();
        mList = new JList(mModel);
        mList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);  //Ɉ̍sIłȂ

        // hLgXgɔf
        mDtLst = getDocList();
        mListCnt = mDtLst.size();

        for (int n = 0; n < mDtLst.size(); n++) {
            // hLg̎擾
            DocumentType dt = (DocumentType)mDtLst.elementAt(n);
            mModel.addElement(dt.app);
        }

        //XN[pl
        mSPanel = new JScrollPane();
        mSPanel.getViewport().setView(mList);
        mSPanel.setPreferredSize(new Dimension(200, 30));
    }


/**
  * {^pl̐
  *
  * @param  GridBagLayout         Layout(GridBagLayout)
  * @param  GridBagConstraints    Layout̍쐬
  * @return void
  */

    public void crtButtonPanel(GridBagLayout layout, GridBagConstraints gbc) throws Exception {

        // pl̐
        mBPanel = new JPanel();

        // LayoutuGridBagLayoutvɂ
        mBPanel.setLayout(layout);

        // New Button
        mJBNew = new JButton("New");
        mJBNew.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent e) { NewDocument(); }
            }
        );
        gbc.anchor  = GridBagConstraints.NORTHWEST;
        gbc.fill    = GridBagConstraints.BOTH;
        gbc.gridx   = 0;
        gbc.gridy   = 0;
        gbc.weightx = 0.0;
        layout.setConstraints(mJBNew, gbc);
        mBPanel.add(mJBNew);

        // Edit Button
        mJBEdit = new JButton("Edit");
        mJBEdit.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent e) { EditDocument(); }
            }
        );
        gbc.fill    = GridBagConstraints.BOTH;
        gbc.weightx = 0.0;
        gbc.gridx   = 0;
        gbc.gridy   = 1;
        layout.setConstraints(mJBEdit, gbc);
        mBPanel.add(mJBEdit);

        // Delete Button
        mJBDel = new JButton("Delete");
        mJBDel.addActionListener(
            new ActionListener() {
                public void actionPerformed(ActionEvent e) { DelDocument(); }
            }
        );
        gbc.fill    = GridBagConstraints.BOTH;
        gbc.weightx = 0.0;
        gbc.gridx   = 0;
        gbc.gridy   = 2;
        layout.setConstraints(mJBDel, gbc);
        mBPanel.add(mJBDel);

    }


/**
  * hLg̎擾
  *
  * @return Vector      hLgXg
  *
  *   command.doc.app.n   = AvP[V
  *   command.doc.cmd.n   = AvP[VR}h
  *   command.doc.ext.n   = gq
  *   command.doc.view.n  = wpgq(ȗ)
  */
    public Vector getDocList() throws Exception {

        //Document̃Xg
        Vector  doc_lst  = new Vector();
        
        String  command;

        //\[Xt@CuEUR}h̃Xgݒ肷
        ZResource res = ZApp.getTheApp().getResource();

        for ( int i = 1; ; i++ ) {

            //gq
            command = "command.doc.ext." + Integer.toString(i);
            String  doc_ext = res.getString(command);

            // gq̎w肪ꍇI
            if ( isNullString(doc_ext) ) break;

            //AvP[V
            command = "command.doc.app." + Integer.toString(i);
            String  doc_app = res.getString(command);
          
            //AvP[VR}h
            command = "command.doc.cmd." + Integer.toString(i);
            String  doc_cmd = res.getString(command);

            //wpgq(ȗ)
            command = "command.doc.view." + Integer.toString(i);
            String  doc_view = res.getString(command);

            DocumentType dt = new DocumentType();
            dt.app =doc_app;
            dt.cmd =doc_cmd;
            dt.ext =doc_ext;
            dt.view =doc_view;
            doc_lst.add(dt);
        }
        return doc_lst;
    }



/**
  * hLg̐ݒ
  *
  * @return void
  *
  *   command.doc.app.n   = AvP[V
  *   command.doc.cmd.n   = AvP[VR}h
  *   command.doc.ext.n   = gq
  *   command.doc.view.n  = wpgq(ȗ)
  */
    public void setDocList() throws Exception {

        String  cmd_app, cmd_ext, cmd_cmd, cmd_view;
        int max = Math.max(mListCnt,mDtLst.size());

        //\[Xt@CuEUR}h̃Xgݒ肷
        ZResource res = ZApp.getTheApp().getResource();

        for ( int i = 1; i <= max; i++ ) {
            cmd_app  = "command.doc.app."  + Integer.toString(i); //AvP[V
            cmd_cmd  = "command.doc.cmd."  + Integer.toString(i); //AvP[VR}h
            cmd_ext  = "command.doc.ext."  + Integer.toString(i); //gq
            cmd_view = "command.doc.view." + Integer.toString(i); //wpgq(ȗ)

            
            if (i <= mDtLst.size() ) {
                DocumentType dt = (DocumentType)mDtLst.elementAt(i-1);
                res.putString(cmd_app, dt.app);
                res.putString(cmd_cmd, dt.cmd);
                res.putString(cmd_ext, dt.ext);
                res.putString(cmd_view,dt.view);
            } else {
                res.putString(cmd_app, null);
                res.putString(cmd_cmd, null);
                res.putString(cmd_ext, null);
                res.putString(cmd_view,null);
            }
        }
    }

/**
  * JPanel̎擾
  *
  * @return JPanel
  */
    public JPanel getPanel(){
        return mPanel;
    }


/**
  *@VK{^ꂽƂ̏
  *
  * @return void
  */
    public void NewDocument()  {

        boolean ret;
        RidMessage ridMsg = new RidMessage();

        DocumentType  dt = new DocumentType();
        DocumentTypeDialog dtdlg = new DocumentTypeDialog();
        ret = dtdlg.newDocument(dt);

        if (ret) {
            // null
            if (isNullString(dt.app) || isNullString(dt.cmd) || isNullString(dt.ext) ){
                MessageDialog.showError(ridMsg.Warning("W4008",""));
            } else {
                //ǉ
                if (mDtLst.indexOf(dt) == -1) {
                    mDtLst.add(dt);
                    mModel.addElement(dt.app);
                }
            }
        }
    }

/**
  *@ҏW{^ꂽƂ̏
  *
  * @return void
  */
    public void EditDocument() {

        int pos;
        boolean ret;

        // I
        if ((pos = mList.getSelectedIndex()) > -1) {

            DocumentType dt = (DocumentType)mDtLst.elementAt(pos);

            DocumentTypeDialog dtdlg = new DocumentTypeDialog();
            
            ret = dtdlg.editDocument(dt);

            if (ret) {
  
                //폜Eǉ
                mDtLst.remove(pos);
                mModel.remove(pos);
                mDtLst.add(pos, dt);
                mModel.add(pos, dt.app);
            }

        }
    }
/**
  *@폜{^ꂽƂ̏
  *
  * @return void
  */
    public void DelDocument() {

        int pos;

        // I
        if ((pos = mList.getSelectedIndex()) > -1) {
            //
            mDtLst.remove(pos);
            mModel.remove(pos);
        }
    }


/**
  * String^mtkkf
  *
  * @param  String      str           t@C
  * @return boolean     true (null)/false(not null)
  */
    public boolean isNullString(String str) {

        boolean ret;
        if ( (str == null) || (str.equals("")) ) {
            ret = true;
        } else {
            ret = false;
        } 
        return ret;
    }

}
