/*
 * @(#)AccessLogDialog.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X FANZX_CAO
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/02/06
 */
package jp.co.nri.rid.environment;

import java.io.*;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;


import jp.co.iti.fagot.ZApp;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;
import jp.co.iti.fagot.util.ZFileFilter;


/**
 * ANZXO_CAO
 */

public class AccessLogDialog {

    /** accesslog.csvfilevpeB **/
    final static public String ACCESSLOG_CSVFILE    = "accesslog.csvfile";
    /** msg.accesslog.titlevpeB **/
    final static public String MSG_ACCESSLOG_TITLE  = "msg.accesslog.title";


    /**
      * ftHgRXgN^
      */
      public AccessLogDialog() {}

    /**
      * _CAO
      */
    public boolean show() {

        //\[Xt@C擾
        ZResource res = ZApp.getTheApp().getResource();

        String  accesslog_csvfile= res.getString(ACCESSLOG_CSVFILE);
        if ( accesslog_csvfile == null || accesslog_csvfile.equals("") ) {  accesslog_csvfile = ""; }

        String  accesslog_title= res.getString(MSG_ACCESSLOG_TITLE);
        if ( accesslog_title == null || accesslog_title.equals("") ) {  accesslog_title = ""; }


        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File(accesslog_csvfile));
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        jFileChooser.setDialogTitle(accesslog_title);
        jFileChooser.setFileFilter(new ZFileFilter( new String("CSV"), "CSV File"));
        int nRet = jFileChooser.showOpenDialog(ZApp.getTheApp().getFrame());

        // {^
        String szFile = null;
        if ( nRet == JFileChooser.APPROVE_OPTION) {
            // [OK]{^̏ꍇA
            File fFile = jFileChooser.getSelectedFile();
            try {
              szFile = fFile.getCanonicalPath();
            } catch ( java.io.IOException evt) {
              szFile = fFile.getAbsolutePath();
            }
            if ( szFile == null || szFile.equals("") ) {  szFile = null;  }
            res.putString(ACCESSLOG_CSVFILE, szFile);
            return true;
        } else {
            return false;
        }
    }

}
