/*
 * @(#)RidPageAction.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : Pagen Action
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/11/07
 */
package jp.co.nri.rid.doc;

import java.awt.event.ActionEvent;

import java.io.File;

import java.text.DecimalFormat;

import java.util.Vector;

import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JFileChooser;

import jp.co.iti.fagot.ZApp;

import jp.co.iti.fagot.action.ZAction;

import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocDocument;

import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZString;
import jp.co.iti.fagot.util.ZFile;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZFileFilter;

import jp.co.nri.Rid;

import jp.co.nri.rid.RUpdateManager;

import jp.co.nri.rid.snapshot.xcopy;

import jp.co.nri.rid.environment.MessageDialog;
import jp.co.nri.rid.error.RidMessage;
/**
 * Pagen Action
 */
public class RidPageAction extends RidAction {
	/**
	 * ANVs
	 */
	public void doAction(ActionEvent evt) {
//	ZDebug.trace("actionName:"+getActionName());
	String szPjDir = ZInstance.prop().getProperty(Rid.PJ_DIR);

	if ( getActionName().equals( VIEW_PAGE ) ) {
		// ݃pl̑IĂGOB擾
		RidElementPage page = (RidElementPage)getTarget();

		// hLg̎ނ̌
		ZResource res = ZApp.getTheApp().getResource();

		// @ Doc ݒ肳Ă΁AΉhLg
		String szFile = page.getAttribute("Doc");
		String szApp  = null;
		if ( szFile.length()!=0 ) {
			String szFileExt = ZFile.getExt( szFile );
			// AvP[V̌
			for ( int nAt=1 ; nAt<100 ; nAt++ ) {
				String szExt = res.getString("command.doc.ext."+nAt);
				if ( szExt == null ) {
					break;
				} else if ( szExt.equals( szFileExt ) ) {
					szApp = res.getString("command.doc.cmd."+nAt);
					break;
				}
			}
		}

		// AvP[VłȂꍇ́AI
//		ZDebug.trace("szApp:"+szApp);
		if ( szApp == null ) {
			Object[] msg = new Object[2];
			msg[0] = res.getString("msg.askdocumenttype");
			JComboBox cb = new JComboBox();
			int nAt = 1;
			for ( ; nAt<100 ; nAt++ ) {
				String szAppName = res.getString("command.doc.app."+nAt);
				if ( szAppName == null ) {
					break;
				} else {
					cb.addItem( szAppName );
				}
			}
			msg[1] = cb;

			// et[̎擾
			JFrame frame = (JFrame)ZInstance.map().get( Rid.FRAME );

			// bZ[W̕\
			int result = JOptionPane.showOptionDialog(frame,
				msg,"Ridual",JOptionPane.YES_NO_OPTION,JOptionPane.QUESTION_MESSAGE,null,null,null);
			if ( result == JOptionPane.YES_OPTION ) {
				nAt = cb.getSelectedIndex() + 1 ;	// SelectedIndex0IWȂ̂+1
				szFile = null;
				String szAppName = res.getString("command.doc.app."+nAt);
				String szExt     = res.getString("command.doc.ext."+nAt);

				// ev[gt@CpӂĂ邩H
				String szOrgFile = szPjDir + File.separator
								 + res.getString("rid.pagetemplate.dir") + File.separator
								 + "page." + szExt ;
//				ZDebug.trace("is Exist ?:" + szOrgFile );
				File fDoc = new File( szOrgFile ) ;
				if ( !fDoc.exists() ) {

					// ev[g݂Ȃ̂ŁAhLgJ
					JFileChooser dlg = new JFileChooser();
					dlg.setFileFilter(new ZFileFilter( new String(szExt), szAppName));

					// JgfBNg̐ݒ
					String szDir = szPjDir + File.separator + res.getString("rid.docs.dir");
					dlg.setCurrentDirectory(new File(szDir)) ;

					// _CAOJ
					int nRet = dlg.showOpenDialog(getApp().getFrame());
					if ( nRet == JFileChooser.APPROVE_OPTION) {
						// IWĩt@C擾
						File fFile = dlg.getSelectedFile();
						try {
							szOrgFile = fFile.getCanonicalPath();
					    } catch ( java.io.IOException io) {
							szOrgFile = fFile.getAbsolutePath();
						}
					} else {
						szOrgFile = null;
					}
				}

				if ( szOrgFile != null ) {
					// Vt@C̃ATC
					szFile = assignFileName(page,szExt);

					// t@CpX̎擾
					String szDocDir = res.getString("rid.pagesvg.dir");
					String szPath   = szPjDir + File.separator + szDocDir + File.separator + szFile ;

					// t@C̃Rs[
					try {
						xcopy xc = new xcopy();
//						ZDebug.trace("copy:"+szOrgFile+""+szPath);
						if ( xc.file( szOrgFile, szPath ) ) {
							// ʂɐ̂ŁAAvP[VDocAgr[gݒ
							szApp = res.getString("command.doc.cmd."+nAt);
							page.setAttribute("Doc",szFile);
							
							// pl̍XV
							RUpdateManager.update(RUpdateManager.PANEL_ACTIVE);
						}
					} catch ( Exception e ) {
					}
				}
			}
//			ZDebug.trace("Select:"+nAt);
		}

		// AvP[V̎s
		if ( szApp != null ) {
			String szFil = szPjDir+File.separator
						  +res.getString("rid.pagesvg.dir")+File.separator
						  +szFile;
			if ( !RidExecAction.exec( szApp, szFil ) ) {
				RidMessage ridMsg = new RidMessage();
				MessageDialog.showError(ridMsg.Error("E1901",szApp+" "+szFil));
			}
/*
			try {
				ZDebug.trace("exec:"+szTarget);
				Runtime.getRuntime().exec(szTarget);
			} catch ( Exception e ) {
				RidMessage ridMsg = new RidMessage();
				MessageDialog.showError(ridMsg.Error("E1901",szTarget));
			}
*/
		} else {
			ZDebug.trace("Open document:Application is null");
		}
	}
	}

	/**
	 * UIXV
	 */
	public void update() {
	boolean bState = true;

	if ( getActionName().equals( VIEW_PAGE ) ) {
		// vWFNgfBNg݂Ȃꍇ͑Is
		String szPjDir = ZInstance.prop().getProperty(Rid.PJ_DIR);
		if ( szPjDir == null ) {
			bState = false;
		}
		// ^[QbgIĂꍇ͑Is
		if ( getTargetsSize() != 1 ) {
			bState = false;
		}
		// AvP[VPݒ肳ĂȂꍇ͑Is
		ZResource res = ZApp.getTheApp().getResource();
		String szAppName = res.getString("command.doc.app.1");
		if ( szAppName == null ) {
			bState = false;
		};
	}

	firePropertyChange(ZAction.ENABLED,null,new Boolean(bState));
	}

	/**
	 * Doct@C̃ATC
	 * @param page y[Wjbg
	 * @param szExt 쐬Doct@C̊gq
	 */
	public String assignFileName(RidElementPage page,String szExt) {
	DocDocument doc = (DocDocument)page.getOwnerDocument();
	DocElement  root = (DocElement)doc.getDocumentElement();
	int nIndex=1;
	for (  ; nIndex<10000 ; nIndex++ ) {
		String szNum = new DecimalFormat("0000").format( nIndex );
		String[] szName = ZString.tokenize(page.getAttribute("Name"),".");
		String szDoc = szName[0]+"_"+szNum+"." + szExt;
		DocElement tmp = (DocElement)root.findChildElement("PageUnit","Doc="+szDoc);
		if ( tmp == null ) {
			// t@CpX̎擾
			ZResource res = ZApp.getTheApp().getResource();
			String szPjDir  = ZInstance.prop().getProperty(Rid.PJ_DIR);
			String szDocDir = res.getString("rid.pagesvg.dir");
			String szPath   = szPjDir + File.separator + szDocDir + File.separator + szDoc ;

			File fDoc = new File( szPath ) ;
			if ( !fDoc.exists() ) {
				return szDoc;
			}
		}
	}

	if ( nIndex == 10000 ) {
		RidMessage ridMsg = new RidMessage();
		MessageDialog.showError(ridMsg.Error("E1003",""));
	}
	return "";
	}


	//## Agr[g ###############################################
    /**
     * y[WڍאhLg̕\
     */
	final static public String VIEW_PAGE	= "view_page" ;
}
