/*
 * @(#)RidElementZone.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : Element
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/11/07
 */
package jp.co.nri.rid.doc;

import java.awt.Color;

import java.text.DecimalFormat;

import javax.swing.JComponent;
import javax.swing.JViewport;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.DOMException;

import jp.co.iti.fagot.ZApp;

import jp.co.iti.fagot.fob.FColor;
import jp.co.iti.fagot.fob.xml.XElementNS;

import jp.co.iti.fagot.geom.ZDimension;
import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZLine;
import jp.co.iti.fagot.geom.ZRectangle;
import jp.co.iti.fagot.geom.ZPath;

import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.GobManager;
import jp.co.iti.fagot.gob.GLine;
import jp.co.iti.fagot.gob.GOperation;
import jp.co.iti.fagot.gob.GString;
import jp.co.iti.fagot.gob.GRectangle;
import jp.co.iti.fagot.gob.PTransform;

import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.doc.DocGridControler;

import jp.co.iti.fagot.util.ZGraphicUtil;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZDebug;

import jp.co.nri.Rid;
import jp.co.nri.rid.RUpdateManager;

import jp.co.nri.rid.environment.MessageDialog;
import jp.co.nri.rid.error.RidMessage;
import jp.co.nri.rid.error.RidException;
/**
 * Rid Element(Zonep)
 */
public class RidElementZone extends RidElement {

	/**
	 * ftHgRXgN^
	 */
	public RidElementZone() throws DOMException {
	}

	/**
	 * ftHggbvy[W̎擾
	 */
	public RidElementPage getDefaultTopPage() {
	RidElementPage topPage = null;
	String szTop = getAttribute("Top");
	if ( szTop.length() > 0 ) {
		// gbvw肳Ăꍇ̓gbvy[W
//		topPage = (RidElementPage)findChildElement("PageUnit","File="+szTop);
		topPage = (RidElementPage)((RidDocumentSite)getOwnerDocument()).findChildElementInZone("PageUnit",szTop);
	}
	if ( topPage == null ) {
		// ݂Ȃꍇindex.html
		topPage = (RidElementPage)findChildElement(".PageUnit","Name=index.html");

		if ( topPage == null ) {
			// index.htm
			topPage = (RidElementPage)findChildElement(".PageUnit","Name=index.htm");
		}

		if ( topPage == null ) {
			// Ȃł̂łƂɂy[W
			// findChildElement(where=null)̓m[h̃LbVAĂ̂ŁA
			// ͂Ō
//			topPage = (RidElementPage)findChildElement(".PageUnit",null);
			NodeList list = getChildNodes();
			for ( int nAt=0 ; nAt<list.getLength() ; nAt++ ) {
				Node child = list.item(nAt);
				if ( child instanceof RidElementPage ) {
					topPage = (RidElementPage)child ;
//					ZDebug.trace("top:"+topPage.getAttribute("File"));
					break;
				}
			}
		}

		if ( topPage == null ) {
			// q̃y[Wł悢
			NodeList list = getChildNodes();
			for ( int nAt=0 ; nAt<list.getLength() ; nAt++ ) {
				Node child = list.item(nAt);
				if ( child instanceof RidElementZone ) {
					topPage = ((RidElementZone)child).getDefaultTopPage() ;
					if ( topPage != null ) {
						break;
					}
				}
			}
		}
	}
	return topPage;
	}

	//## IGobContainerFqbg ########################################
	/**
	 * _uNbN̓
	 * @param gob  NGXgGob
	 * @param mode NbNʒu
	 */
	public void verbDblClick(GElement gob,ZPoint pt) {
//	ZDebug.trace();
	String szActive = ZInstance.prop().getProperty( Rid.PANEL_ACTIVE );
	JComponent active = (JComponent)ZInstance.map().get(szActive);
	if ( !(active instanceof DocPane) ) {
		// ANeBupl`plłȂꍇ͕`悵Ȃ
		return;
	}
	DocPane editor = (DocPane)active;
	RidDocumentSite doc = (RidDocumentSite)editor.getDocument();
	RidElement top = doc.getTopZone();

//	PTransform trans = gob.getTransform();
//	ZRectangle rect = gob.getTransformedBounds();
	ZRectangle rect = gob.getBounds();

	ZPoint ptTTL = new ZPoint(0,getTitleHeight()+TTLIN*2);
//	ZPoint ptTTLTrans = trans.transform( ptTTL );
//	double dTTL = ptTTLTrans.getY();
	double dTTL = ptTTL.getY();

	// ^Cgs̃NbN̏ꍇ
	if ( pt.getY() < rect.getY()+dTTL ) {
		// VN{^ɂĂȂꍇ
		if ( pt.getX() < rect.getX()+rect.getWidth()-dTTL ) {
		  	RidElementZone parent = (RidElementZone)getParentNode();
			RidElementZone root   = (RidElementZone)((DocDocument)getOwnerDocument()).getRootElement(editor.getPanelId());
			if ( parent == root ) {
				// O̕ҏW
				rect.setHeight( dTTL );
				editor.setEditElement(this,rect,false);
			} else {
				// ][̕`(][̃^CgҏW͍sȂ)
				changeRoot( editor );
				top.setChildUnSelect();
				doc.setLinksUnSelect();
			}
		// VN{^
		} else {
//			ZDebug.trace("Omission");
			XElementNS elm = getChildElement(".ViewInfo."+editor.getPanelId(),null);
			boolean bValue = elm.getBooleanAttr("Omission",false);
			elm.setBooleanAttr("Omission",!bValue);
			editor.updateGobs();
		}
	} else {
		// ][̕`
		changeRoot( editor );
		top.setChildUnSelect();
		doc.setLinksUnSelect();
	}
	}

	/**
	 * [g̕ύX
	 * @param editor GfB^
	 */
	public void changeRoot(DocPane editor) {
	// [g̕ύX
	RidDocumentSite doc = (RidDocumentSite)getOwnerDocument();
	doc.setRootElement(editor.getPanelId(),this);

	// r[|[g̍Ĕzu
	editor.setPaintMode(false);
	JViewport port = (JViewport)editor.getParent();
	port.doLayout();
	editor.setPaintMode(true);

	// ĕ`
	editor.editRestart();

//	RUpdateManager.update(RUpdateManager.VIEWACTION_VIEWZONE, true );
	RUpdateManager.update(RUpdateManager.VIEWACTION_VIEWZONE );
	}

	//## IGobContainerFړ ##########################################
	/**
	 * ړPath̎擾
	 * @param gob  NGXgGob
	 * @param grid ObhRg[
	 */
	public ZPath getMovingPath(GElement gob,DocGridControler grid) {
	ZRectangle rect = null;

	if ( grid.getMoveMode() == GOperation.NEW ) {
		ZPoint ptSta= grid.getStartGrid();
		ZPoint ptMov= grid.getMoveGrid();
		if ( (ptMov.getX()-ptSta.getX()) < 10 ) { ptMov.setX(ptSta.getX()+200); }
		if ( (ptMov.getY()-ptSta.getY()) < 10 ) { ptMov.setY(ptSta.getY()+100); }
		ZPoint ptBR = new ZPoint( Math.max(ptMov.getX(),ptSta.getX()+30),
								  Math.max(ptMov.getY(),ptSta.getY()+30) );
		rect = new ZRectangle( ptSta, ptBR );
	} else {
		rect = ((GRectangle)gob).getMovingRectGob(grid);
	}
	return  new ZPath( rect );
	}

	//## ` #########################################################
	/**
	 * `Gg̎擾
	 *
	 * [g̏ꍇ́Ag`悵Ȃ
	 * @param szPanelId plʎq
	 * @param isRoot    [g̗L
	 */
	public Vector createGobs(String szPanelId,boolean isRoot) {
	Vector gobs = new Vector();

	// ȗL
	XElementNS vwi = getChildElement(".ViewInfo."+szPanelId,null);
	boolean bOmission = vwi.getBooleanAttr("Omission",false);

	// g̍쐬
	if ( !isRoot ) {
		if ( !hasRect(szPanelId) ) {
			// CAEg
			ZPoint pt = getSpace(szPanelId);
			ZRectangle rt = new ZRectangle( pt.getX(), pt.getY(), 200, 100 );
			setRect(szPanelId,rt);
		}
		GRectangle gRect = createMainGob(szPanelId);
		gRect.setSelect(isSelect());
		gRect.setContainer(this);
		gRect.setGobId("zone");
		gRect.setMinSize(new ZDimension(30,30));
		gobs.add(gRect);
		setMainGob(szPanelId,gRect);

		// e̕`
		gRect.addBackChildren( createShadowGobs( gRect ) );

		// O̕`
		gRect.addForeChildren( createTitleGobs( szPanelId ) );

		// ȗ}[N̕`
		double dTitleHeight = getTitleHeight();
		Vector omi = new Vector();
		ZRectangle rect = getRect(szPanelId);
		double dXStart = rect.getX()+rect.getWidth()-(dTitleHeight+TTLIN*2);
		double dYStart = rect.getY();
		double dZ      = dTitleHeight+TTLIN*2;
		// ̕\
		GLine gLine = new GLine();
		gLine.getStyle().setStrokeColor( new FColor( Color.black ));
		gLine.setLine( new ZLine(dXStart,dYStart,dXStart,dYStart+dZ) );
		omi.add(gLine);
		// 
		gLine = new GLine();
		gLine.getStyle().setStrokeColor( new FColor( Color.black ));
		gLine.setLine( new ZLine(dXStart+TTLIN,dYStart+dZ/2,dXStart+dZ-TTLIN,dYStart+dZ/2) );
		omi.add(gLine);
		// c
		if ( bOmission ) {
			gLine = new GLine();
			gLine.getStyle().setStrokeColor( new FColor( Color.black ));
			gLine.setLine( new ZLine(dXStart+dZ/2,dYStart+TTLIN,dXStart+dZ/2,dYStart+dZ-TTLIN) );
			omi.add(gLine);
		}
		gRect.addForeChildren( omi );

		// VN̕\
		if ( bOmission ) {
			Vector childPages = getPages(true);
			Vector childZones = getZones(true);
			Enumeration elm = childPages.elements();
			int nDone = 0;
			while( elm.hasMoreElements() ) {
				DocElement page = (DocElement)elm.nextElement();
				if ( page.getAttribute("Status").equals("done") ) {
					nDone++;
				}
			}
			ZRectangle canvas = new ZRectangle( rect.getX()+INSET,
												rect.getY()+INSET+dTitleHeight,
												rect.getWidth()-INSET*2,
												rect.getHeight()-INSET*2-dTitleHeight );
			// LoXꍇ͕`悵Ȃ
			if ( canvas.getWidth() >= 50 && canvas.getHeight() >= 20 ) {
				Color bgcol = getBackgroundColor();
				Color txtcol = (ZGraphicUtil.isBlackFamily(bgcol)?Color.white:Color.black);
				Vector children = new Vector();
				// Page
				GString gStr = new GString();
				gStr.setText( "Page@@@"+nDone+"/"+childPages.size() );
				gStr.getStyle().setFillColor( new FColor( txtcol ));
				gStr.setFormat( GString.CENTER|GString.MIDDLE );
				ZRectangle rtCanvas = new ZRectangle( canvas.getX(),canvas.getY(),canvas.getWidth(),canvas.getHeight()/2);
				gStr.setRect( rtCanvas );
				children.add(gStr);

				// Zone
				gStr = new GString();
				gStr.setText( "Zone@@@"+childZones.size() );
				gStr.getStyle().setFillColor( new FColor( txtcol ));
				gStr.setFormat( GString.CENTER|GString.MIDDLE );
				rtCanvas = new ZRectangle( canvas.getX(),canvas.getY()+canvas.getHeight()/2,canvas.getWidth(),canvas.getHeight()/2);
				gStr.setRect( rtCanvas );
				children.add(gStr);

				gRect.addForeChildren( children );
			}
		}
	}

	// qpGob̍쐬
	if ( isRoot || !bOmission ) {
		Vector children = createChildGobs(szPanelId);
		convertChildGobs( szPanelId, children ) ;
		gobs.addAll(children);
	} else {
		// qm[hɁAȗGobʒm
		for ( int nIndex=0; nIndex<getLength() ; nIndex++ ) {
			Node elm = (Node)item(nIndex);
			if ( elm instanceof RidElement ) {
				((RidElement)elm).setOmissionGob( szPanelId,getMainGob(szPanelId) );
			}
		}
	}

	return gobs;
	}

	/**
	 * `Gg̎擾
	 *
	 * [g̏ꍇ́Ag`悵Ȃ
	 * @param szPanelId plʎq
	 * @param isRoot    [g̗L
	 */
	public Vector createSkeltonGobs(String szPanelId,boolean isRoot) {
	Vector gobs = new Vector();

	// g̍쐬
	if ( isRoot ) {
		// qpGob̍쐬
		Vector children = new Vector();
		// qm[h̕`
		for ( int nIndex=0; nIndex<getLength() ; nIndex++ ) {
			Node elm = (Node)item(nIndex);
			if ( elm instanceof DocElement ) {
				children.addAll(((DocElement)elm).createSkeltonGobs( szPanelId,false ));
			}
		}
		convertChildGobs( szPanelId, children ) ;
		gobs.addAll(children);

	} else if ( hasRect(szPanelId) ) {
		GRectangle gRect = createMainGob(szPanelId);
		gRect.setPaintIfSmall(true);
		gobs.add(gRect);
	}

	return gobs;
	}

	/**
	 * `Gg̎擾
	 * @param szPanelId plʎq
	 */
	public GRectangle createMainGob(String szPanelId) {
	GRectangle gRect = new GRectangle();

	// `̐ݒ
	ZRectangle rect = getRect( szPanelId );
	gRect.setRect( rect );
	// wiF̐ݒ
	Color col = getBackgroundColor();
	gRect.getStyle().setFillColor( new FColor( col ));

	// gF̐ݒ
	ZResource res = ZApp.getTheApp().getResource();
	boolean isExist = getBooleanAttr("Exist", true );
	col = res.getColor("unit.color."+((isExist)?"":"Not")+"Exist");
	gRect.getStyle().setStrokeColor( new FColor( col ));
	return gRect;
	}

	/**
	 * q̃Gg̎擾
	 * @param szPanelId plʎq
	 */
	public void convertChildGobs(String szPanelId,Vector children) {
	// [gGgłȂ΁AZone̒ɓ悤Wϊ
	PTransform trans = null;
	if ( ((DocDocument)getOwnerDocument()).getRootElement(szPanelId)!=this && hasRect(szPanelId) ) {
		ZRectangle childRect = GobManager.getTransformedBounds(children);
		ZRectangle rect = getRect( szPanelId );
		if ( childRect != null ) {
			ZRectangle childRectMax = null;
			double dTitleHeight = getTitleHeight();
			ZRectangle canvas = new ZRectangle( rect.getX()+INSET,
												rect.getY()+INSET+dTitleHeight,
												rect.getWidth()-INSET*2,
												rect.getHeight()-INSET*2-dTitleHeight );

/* q̏kڃ][LȂ悤C
			if ( hasRect(szPanelId+".child") ) {
				ZRectangle oldChildRect = getRect(szPanelId+".child");
				childRect.union(oldChildRect);
			}
			setRect(szPanelId+".child",childRect);
*/
			trans = ZGraphicUtil.getNormalizeTransform( canvas, childRect );

			Enumeration elm = children.elements();
			while ( elm.hasMoreElements() ) {
				GElement item = (GElement)elm.nextElement();
				item.addTransform( trans );
			}
		}
	}

	// Wϊ[`̕ۑ
	if ( trans == null ) {
		mChildTransform.remove( szPanelId );
	} else {
		mChildTransform.put( szPanelId, trans );
	}
	}

	/**
	 * DOM Treeł̈ʒuύX
	 */
	public void treeChanged() {
	updateFileAttribute();
	}

	/**
	 * qpWϊ̎擾
	 * @param szPanelId plʎq
	 */
	public PTransform getChildTransform( String szPanelId ) {
	return (PTransform)mChildTransform.get( szPanelId );
	}

	//## OǗ #####################################################
	/**
	 * Gg̒ǉ
	 *
	 * ̒ڂ̎qłΎqǉ
	 * ڂ̎qłȂΎq][ɓn
	 *
	 * @param element Gg
	 */
	public void appendChild( DocElement element ) {

	super.appendChild(element);

	// ڂ̎qŁAOĂȂΖOt
	String szName = element.getAttribute("Name");
	if ( szName == null || szName.length()==0 ) {
		String szTag = element.getTagName();
		String szKey = szTag;
		if ( szTag.endsWith("Unit") ) {
			szKey = szTag.substring(0,szTag.length()-4);
		}

		// y[W̏ꍇ́At@C^Cvt^
		String szSuffix = null;
		if ( szTag.startsWith("Page") ) {
			szSuffix = getAttribute("FileType");
			if ( szSuffix == null || szSuffix.length()==0 ) {
				szSuffix = "html";	// vpeBݒ肳ĂȂꍇftHg
			}
		}

		int nIndex=1;
		for(  ; nIndex<10000 ; nIndex++ ) {
			String szNum = new DecimalFormat("0000").format( nIndex );
			szName = szKey + szNum;
			if ( szSuffix != null ) {
				szName += "." + szSuffix ;
			}
			// ݂邩`FbN
			if ( findChildElement("."+szTag,"Name="+szName)==null ) {
				break;
			}
		}
		
		if ( nIndex == 10000 ) {
			szName = "";
			RidMessage ridMsg = new RidMessage();
			MessageDialog.showError(ridMsg.Error("E1002",""));
		}
		element.setAttribute("Name", szName ) ;
//	} else {
//		ZDebug.trace("create:"+szName);
	}
	}

	/**
	 * y[Wjbg̎W
	 * @param isContainChild ][܂Ō邩H
	 */
	public Vector getPages( boolean isContainChild ) {
	Vector pages = new Vector();
	NodeList list = getChildNodes();
	for ( int nAt=0 ; nAt<list.getLength() ; nAt++ ) {
		Node child = list.item(nAt);
		if ( child instanceof RidElementZone && isContainChild ) {
			pages.addAll(((RidElementZone)child).getPages( isContainChild ));
		} else if ( child instanceof RidElementPage ) {
			pages.add( child );
		}
	}
	return pages;
	}

	/**
	 * ][jbg̎W
	 * @param isContainChild ][܂Ō邩H
	 */
	public Vector getZones( boolean isContainChild ) {
	Vector pages = new Vector();
	NodeList list = getChildNodes();
	for ( int nAt=0 ; nAt<list.getLength() ; nAt++ ) {
		Node child = list.item(nAt);
		if ( child instanceof RidElementZone ) {
			pages.add( child );
			if ( isContainChild ) {
				pages.addAll(((RidElementZone)child).getZones( isContainChild ));
			}
		}
	}
	return pages;
	}

	/**
	 * DOM폜
	 * qy[W̃NƂɍ폜邽
	 * qꍇ͎qꂼ폜Ă
	 */
	public void removeFromDocTree() {
	NodeList list = getChildNodes();
	for ( int nAt=0 ; nAt<list.getLength() ; ) {
		Node child = list.item(nAt);
		if ( child instanceof RidElement ) {
			((RidElement)child).removeFromDocTree();
		} else {
			nAt++;
		}
	}
	super.removeFromDocTree();
	}

	//## ҏW #########################################################
	/**
	 * ̐ݒ
	 */
	public void setText(String szText) {
	setAttribute("Name",szText);
	if ( !szText.equals( getAttribute("Name") ) ) {
		RidException err = (RidException)ZInstance.map().get("setAttribute");
		MessageDialog.showError(err.getMessage());
	}
	}

	/**
	 * ̎擾
	 */
	public String getText() {
	return 	getAttribute("Name");
	}

	//## Agr[g################################################
	/**
	 * qpWϊ
	 */
	protected Hashtable mChildTransform = new Hashtable();

	/**
	 * Zone Canvas̃CZbg
	 */
	final static public double INSET = 10;

}
