/*
 * @(#)RidElementScenarioItem.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : ScenarioItem
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/11/07
 */
package jp.co.nri.rid.doc;

import java.awt.Color;

import java.util.Enumeration;
import java.util.Vector;

import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

import jp.co.iti.fagot.fob.FColor;

import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZPath;
import jp.co.iti.fagot.geom.ZLine;
import jp.co.iti.fagot.geom.ZRectangle;

import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.GPath;
import jp.co.iti.fagot.gob.GLine;
import jp.co.iti.fagot.gob.GOperation;
import jp.co.iti.fagot.gob.GobManager;

import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.doc.DocGridControler;

import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZDebug;

import jp.co.nri.Rid;
/**
 * Rid Element(ScenarioItemp)
 */
public class RidElementScenarioItem extends RidElement {

	/**
	 * ftHgRXgN^
	 */
	public RidElementScenarioItem() throws DOMException {
	}

	//## IGobContainerFړ ##########################################
	/**
	 * vf̈ړ[h͂ȂɂH
	 * @param gob NGXgGob
	 * @param pt   _W
	 */
	public byte getPreMoveMode(GElement gob,ZPoint pt) {
	byte mode = super.getPreMoveMode(gob,pt);
	switch ( mode ) {
	  case GOperation.MOVE:		// ړ
		mode = GOperation.NONE;
		break;

	  case GOperation.NEW:		// VK쐬
		// qbgGg΁AIvViڑ\}[Nj\
		DocPane panel = (DocPane)ZInstance.map().get( Rid.PANEL_MAP );
		String szPanelId = panel.getPanelId();
		if ( findContainer(szPanelId,pt,null) ) {
			getContainer(1).setHighlight(szPanelId,GOperation.MOVE);
		}
		break;
	  case GOperation.POINT:	// ̃ACëړ
		break;
	}
	return mode;
	}

	/**
	 * ړ̊Jn
	 * @param gob  NGXgGob
	 * @param grid ObhRg[
	 */
	public void moveStart(GElement gob,DocGridControler grid) {
	}

	/**
	 * ړPath̎擾
	 * @param gob  NGXgGob
	 * @param grid ObhRg[
	 */
	public ZPath getMovingPath(GElement gob,DocGridControler grid) {
//	ZDebug.trace();
	DocPane editor = grid.getEditor();
	ZPoint ptMove = grid.getMovePoint();
	ZPath path = new ZPath();

	switch ( grid.getMoveMode() ) {
	  case GOperation.NEW:		// VK쐬
	  case GOperation.POINT:	// _̈ړ
		// ړ_ɐڑReiꍇ́AڑReiړ_擾
		if ( findContainer(editor.getPanelId(),ptMove,null) ) {
			RidElementPage page = getContainer(1);
			page.setHighlight(editor.getPanelId(),GOperation.MOVE);
			path = page.getMapScenarioPath(editor.getPanelId());
		}
		break;
	}

	return path;
	}

	/**
	 * ړ̊
	 * @param gob  NGXgGob
	 * @param grid ObhRg[
	 */
	public void moveEnd(GElement gob,DocGridControler grid) {
	DocPane editor = grid.getEditor();
	ZPoint ptMove = grid.getMovePoint();

	switch ( grid.getMoveMode() ) {
	  case GOperation.NEW:		// VK쐬
		if ( findContainer(editor.getPanelId(),ptMove,null) ) {
			updateContainer(editor.getPanelId());
			setSelect(gob,true);
			RidDocumentSite doc = (RidDocumentSite)editor.getDocument();
			setDocument( doc );
			RidElementScenario scene = doc.getScenario( doc.getScenarioName() );
			if ( scene != null ) {
				scene.appendChild(this);
			}
		}
		break;

	  case GOperation.POINT:	// _̈ړ
		break;
	}

	}

	//## ` #########################################################
	/**
	 * `Gg̎擾(Mappl)
	 *
	 * [g̏ꍇ́Ag`悵Ȃ
	 * @param szPanelId plʎq
	 */
	public Vector createGobs(String szPanelId) {
	Vector gobs = new Vector();

/*
	*** 20020404 updateKeyAttribute() ōXV悤C ***
	// y[W̐`FbN
	// ReiAړA폜ĂꍇA
	// hLgǂݍݒŃReiݒ肳ĂȂꍇ͂Ő
	if ( ! ( checkContainer(szPanelId) ) ) {
		removeFromDocTree();
		return gobs;
	}
*/

	RidElementPage page = getContainer(0);
	GElement gob = page.getMainGob( szPanelId );
	if ( gob != null ) {
		ZPath path = page.getMapScenarioPath(szPanelId);
		GPath gpath = new GPath();
		gpath.setPath( path );

		Color col = getBackgroundColor();
		gpath.getStyle().setFillColor( new FColor( col ));

		gpath.setSelect(isSelect());
		gpath.setGobId("map");
		gpath.setContainer( this );
		gobs.add(gpath);

		ZRectangle rt = new ZRectangle(gpath.getBounds());
		ZPoint pt0 = rt.getCenter();

		// ̃ViIACeւ̃pX`
		RidElementScenarioItem item = getNextItem(szPanelId);
		boolean direct = true;
		while ( item != null ) {
			page = item.getContainer(0);
			gob  = page.getMainGob( szPanelId ) ;
			if ( gob != null ) {
				// ̃ViIACe̂ŕ`
				GLine line = new GLine();

				rt = new ZRectangle(gob.getBounds());
				ZPoint pt1 = rt.getCenter();
				line.getStyle().setStrokeColor( new FColor( col ) );
				line.setLine( new ZLine(pt0,pt1) );
				line.getStyle().getStroke().getWidth().set(20.0f);
				if ( !direct ) {
					float[] dash = new float[1];
					dash[0] = 10;
					line.getStyle().getStroke().getDashArray().set(dash);
				}
				gpath.addBackChild( line );
				break;
			}
			item = item.getNextItem(szPanelId);
			direct = false;
		}
	}

	return gobs;
	}

	/**
	 * Reĩ`FbN
	 *
	 * @param szPanelId plʎq
	 */
/*
	*** 20020404 updateKeyAttribute() ōXV悤C ***
	public boolean checkContainer(String szPanelId) {
	String szKey   = getAttribute("Container");

	mContainer[0] = null;
	RidElement page = getContainer(0);
	if ( page == null ) {
		//y[W܂
		return false;
	} else if ( page.getStatus().equals("remove") ) {
		//y[W폜Ă܂
		return false;
	}
	return true;
	}
*/
	/**
	 * Rei̍XV
	 * @param oldValue ̂̒linull̏ꍇunit폜ꂽj
	 * @param unit XVꂽjbg
	 */
	public void updateKeyAttribute( String oldValue, RidElement unit ) {
	String newValue = unit.getAttribute("Key");
	String checkTarget = oldValue;
	if ( checkTarget == null ) {
		checkTarget = newValue;
	}

	if ( getAttribute("Container").equals( checkTarget ) ) {
		if ( oldValue == null ) {
			// 폜
			removeFromDocTree();
		} else {
			// O̕ύX
			setAttribute("Container", newValue);
			mContainer[0] = (RidElementPage)unit;
		}
	}
	}

	//## y[Wւ̃N #########################################
	/**
	 * ݒłReiTB
	 * ꍇAڑXg1Ԗ(ꎞ̈)ɕۑ
	 * @param szPanelId plʎq
	 * @param pt        W
	 * @param org       ̃y[W
	 */
	protected boolean findContainer(String szPanelId, ZPoint pt,RidElement org) {
	mContainer[1] = null;
	Enumeration elm = GobManager.elements(szPanelId,GobManager.ALL);
	while ( elm.hasMoreElements() ) {
		GElement item = (GElement)elm.nextElement();
		byte pos = item.getConnectMode(pt, this);
		if ( pos != 0 ) {
			RidElementPage container = (RidElementPage)item.getContainer();
			if ( container != null && container != org ) {
//				ZDebug.trace("find:"+pos);
				mContainer[1] = container;
				return true;
			}
		}
	}
	return false;
	}

	/**
	 * oς̐ڑłReiDOMɔf
	 * @param szPanelId plʎq
	 */
	protected void updateContainer(String szPanelId) {
	// IuWFNg̐ݒ
	// undoɃNAȂ̂ŁAnullɐݒ肷
	mContainer[0] = mContainer[1] ;

	// DOM̐ݒ
	String szKey = mContainer[0].getAttribute("Key");
//	ZDebug.trace("setKey:"+szKey);
	setAttribute("Container",szKey);

	mContainer[1] = null;
	}

	/**
	 * NΏۂ̎擾
	 * @param nIndex ʒuL[
	 */
	protected RidElementPage getContainer(int nIndex) {
	if ( nIndex == 0 && mContainer[nIndex] == null ) {
		String szKey   = getAttribute("Container");

		// |C^ZbgĂȂꍇ́ATop猟
		RidDocumentSite doc = (RidDocumentSite)ZInstance.map().get( Rid.DOCUMENT_SITE );
		mContainer[nIndex] = (RidElementPage)doc.findChildElementInZone("PageUnit",szKey);
//		ZDebug.trace("find:"+szKey+" ... "+mContainer[nIndex]);
	}
	return mContainer[nIndex];
	}

	//## Z #####################################################
	/**
	 * ̃ViIACeTB
	 * @param szPanelId plID
	 */
	protected RidElementScenarioItem getNextItem(String szPanelId) {
	Node node = getNextSibling();
	while ( node != null ) {
		if ( node instanceof RidElementScenarioItem ) {
			RidElementScenarioItem item = (RidElementScenarioItem)node;
			return (RidElementScenarioItem)node;
/*
			if ( item.checkContainer( szPanelId ) ) {
				return (RidElementScenarioItem)node;
			}
*/
		}
		node = node.getNextSibling();
	}
	return null;
	}

	//## Agr[g################################################
	/**
	 * y[WRei
	 * Rei͂PA2ڂ̗̈ҏWpꎞ̈Ƃėp
	 */
	protected RidElementPage[] mContainer = new RidElementPage[2] ;
}
