/*
 * @(#)RidElementPage.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : Element
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/11/07
 */
package jp.co.nri.rid.doc;

import java.awt.Color;
import java.awt.Shape;

import java.awt.geom.AffineTransform;

import java.util.Enumeration;
import java.util.Vector;

import javax.swing.JComponent;
import javax.swing.JViewport;

import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import jp.co.iti.fagot.ZApp;

import jp.co.iti.fagot.fob.FColor;
import jp.co.iti.fagot.fob.FInteger;

import jp.co.iti.fagot.fob.xml.XElementNS;

import jp.co.iti.fagot.geom.ZDimension;
import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZPath;
import jp.co.iti.fagot.geom.ZLine;
import jp.co.iti.fagot.geom.ZRectangle;

import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.GEllipse;
import jp.co.iti.fagot.gob.GOperation;
import jp.co.iti.fagot.gob.GobManager;
import jp.co.iti.fagot.gob.GRectangle;
import jp.co.iti.fagot.gob.GRectShape;
import jp.co.iti.fagot.gob.GPath;
import jp.co.iti.fagot.gob.GLine;
import jp.co.iti.fagot.gob.GString;
import jp.co.iti.fagot.gob.PTransform;

import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocGridControler;
import jp.co.iti.fagot.doc.DocPane;

import jp.co.iti.fagot.util.ZGraphicUtil;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZProperties;
import jp.co.iti.fagot.util.ZString;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZDebug;

import jp.co.nri.Rid;
import jp.co.nri.rid.RUpdateManager;

import jp.co.nri.rid.environment.MessageDialog;
import jp.co.nri.rid.error.RidException;
/**
 * Rid Element(Pagep)
 */
public class RidElementPage extends RidElement {

	/**
	 * ftHgRXgN^
	 */
	public RidElementPage() throws DOMException {
	}

	//## IGobContainerFqbg ########################################
	/**
	 * vf̈ړ[h͂ȂɂH
	 * @param gob NGXgGob
	 * @param pt   _W
	 */
	public byte getPreMoveMode(GElement gob,ZPoint pt) {
	byte mode = super.getPreMoveMode(gob,pt);
	// ړ^[QbgMapɂey[Wւ̐ł΁Aړ[hύX
	if ( isGobId(gob,"line") ) {
		switch ( mode ) {
		  case GOperation.MOVE:		// ړ
			mode = GOperation.NONE;
			break;

		  case GOperation.POINT:	// _̈ړ
			// I_̈ړł΁Ae̕ύX
			if ( ((GLine)gob).getMovePoint()!=1 ) {
				mode = GOperation.NONE;
				break;
			}

			// qbgGg΁AIvViڑ\}[Nj\
			String szTitle = ZInstance.prop().getProperty( Rid.PANEL_ACTIVE );
			DocPane editor = (DocPane)ZInstance.map().get(szTitle);
//			RidDocumentSite doc = (RidDocumentSite)getOwnerDocument();
//			Vector links = doc.getLinkFromPage(this);
			Enumeration elm = mFromPageForMoveGob.elements();
			while ( elm.hasMoreElements() ) {
				RidElementPage page = (RidElementPage)elm.nextElement();
				page.setHighlight(editor.getPanelId(),GOperation.NONE);
			}
			break;
		}
	}
	return mode;
	}

	/**
	 * vfɐڑ邩H
	 * @param gob  NGXgGob
	 * @param pt   _W
	 * @param obj  ڑΏ
	 */
	public byte getConnectMode(GElement gob,ZPoint pt,Object obj) {
	byte mode = GOperation.NONE;
	// MapC̏ꍇ
	if ( isGobId(gob,"map") ) {
		if ( ((GPath)gob).getPath().contains(pt) ) {
			mode = GOperation.MOVE;
		}
	} else if ( isGobId(gob,"zone") ) {
		mode = getConnectModeImpl(gob, pt, obj ) ;

	// 20020912 ǉGobɂN͂悤ɂ
	} else if ( isGobId(gob,"add") ) {
		mode = getConnectModeImpl(gob, pt, obj ) ;
	}
	return mode;
	}

	/**
	 * _uNbN̓
	 * @param gob  NGXgGob
	 * @param mode NbNʒu
	 */
	public void verbDblClick(GElement gob,ZPoint pt) {
	String szActive = ZInstance.prop().getProperty( Rid.PANEL_ACTIVE );
	JComponent active = (JComponent)ZInstance.map().get(szActive);
	if ( !(active instanceof DocPane) ) {
		// ANeBupl`plłȂꍇ͕`悵Ȃ
		return;
	}
	DocPane editor = (DocPane)active;

	if ( isGobId(gob,"zone") ) {
//		PTransform trans = gob.getTransform();
//		ZRectangle rect = gob.getTransformedBounds();
		ZRectangle rect = gob.getBounds();

		ZPoint ptTTL = new ZPoint(0,getTitleHeight()+TTLIN*2);
//		ZPoint ptTTLTrans = trans.transform( ptTTL );
//		double dTTL = ptTTLTrans.getY();
		double dTTL = ptTTL.getY();

		// ^Cgs̃NbN̏ꍇ
		if ( pt.getY() < rect.getY()+dTTL ) {
		  	RidElementZone parent = (RidElementZone)getParentNode();
			RidElementZone root   = (RidElementZone)((DocDocument)getOwnerDocument()).getRootElement(editor.getPanelId());
			if ( parent == root ) {
				// O̕ҏW
				rect.setHeight( dTTL );
				editor.setEditElement(this,rect,false);
			} else {
				// y[W̕`
//				changePanel();
			}
		} else {
			// y[W̕`
//			changePanel();
		}
	}
	}

	/**
	 * DOM Treeł̈ʒuύX
	 */
	public void treeChanged() {
	updateFileAttribute();
	}

	/**
	 * Gob̍폜
	 * @param gob 폜ꂽgob
	 */
	public void removeGob(GElement gob) {
	if ( isGobId(gob,"line") ) {
		// MAPʂɂĐ̍폜
		DocPane editor = (DocPane)ZInstance.map().get(Rid.PANEL_MAP);
		// eeɍ~i
		XElementNS elm = getChildElement(".ViewInfo."+editor.getPanelId(),null);
		elm.setAttribute("Type","Auto");
	} else {
		super.removeGob( gob );
	}
	}

	/**
	 * DOM폜
	 */
	public void removeFromDocTree() {
//	ZDebug.trace(":::"+getAttribute("Key"));
	super.removeFromDocTree();
	updateLink(null);
	updateScenarioItem(null);
	}

	/**
	 * gbvy[W̕ύX
	 * @param editor GfB^
	 */
	public void changeTop(DocPane editor) {
	// [g̕ύX
	RidDocumentSite doc = (RidDocumentSite)getOwnerDocument();
	doc.setTopPage(editor.getPanelId(),getAttribute("File"));

	// r[|[g̍Ĕzu
	editor.setPaintMode(false);
	JViewport port = (JViewport)editor.getParent();
	port.doLayout();
	editor.setPaintMode(true);

	// ANZXOől̐ݒ
	((RidDocumentSite)getOwnerDocument()).requestUpdateAccessCount();

	// [gGg̍ČvZtO"none"ɐݒ
	if ( editor.getPanelId().endsWith("Circle") ) {
		DocElement root = (DocElement)doc.getRootElement( editor.getPanelId() );
		DocElement map  = (DocElement)root.getChildElement(".ViewInfo."+editor.getPanelId(),null);
		map.setAttribute("Calc","none");
	}

	// ĕ`
	editor.editRestart();

	RUpdateManager.update(RUpdateManager.VIEWACTION_VIEWMAPPAGE, true);
	}


	//## IGobContainerFړ ##########################################
	/**
	 * ړ̊Jn
	 * @param gob  NGXgGob
	 * @param grid ObhRg[
	 */
	public void moveStart(GElement gob,DocGridControler grid) {
	if ( isGobId(gob,"line") ) {
		switch ( grid.getMoveMode() ) {
		  case GOperation.MOVE:		// ړ
			// ړ͂Ȃ
			break;

		  case GOperation.POINT:	// _̈ړ
			gob.moveStartGob( grid );
			break;
		}
	} else {
		super.moveStart(gob,grid);
	}
	}

	/**
	 * ړPath̎擾
	 * @param gob  NGXgGob
	 * @param grid ObhRg[
	 */
	public ZPath getMovingPath(GElement gob,DocGridControler grid) {
	if ( isGobId(gob,"line") ) {
		DocPane editor = grid.getEditor();
		ZPoint ptMove = grid.getMovePoint();
		ZPoint ptStop = ((GLine)gob).getLine().getP1Z();
		if ( grid.getMoveMode() == GOperation.POINT ) {
			// ړ_ɐڑReiꍇ́AڑReiړ_擾
			if ( findConnectPage(editor.getPanelId(),ptMove) ) {
				mConnectParent.setHighlight(editor.getPanelId(),GOperation.MOVE);
				ptMove = mConnectParent.getConnectPoint(editor.getPanelId(),GOperation.MOVE);
//				ZDebug.trace("Conn:"+ptMove);
			}

			// qbgGg΁AIvViڑ\}[Nj\
//			RidDocumentSite doc = (RidDocumentSite)getOwnerDocument();
//			Vector links = doc.getLinkFromPage(this);
			Enumeration elm = mFromPageForMoveGob.elements();
			while ( elm.hasMoreElements() ) {
				RidElementPage page = (RidElementPage)elm.nextElement();
				if ( mConnectParent != page ) {
					page.setHighlight(editor.getPanelId(),GOperation.NONE);
				}
			}
			return new ZPath( new ZLine( ptMove,ptStop ) );
		} else {
			// S̈ړ̏ꍇ͕`悵Ȃ
			return new ZPath( new ZLine( ptMove,ptMove ) );
		}
//  ***20020726*** PageSċ`ɕύX
//	} else if ( isGobId( gob,"zone") ) {
//		ZRectangle rect = ((GRectShape)gob).getMovingRectGob(grid);
//		// ^CvɂČ`قȂ
//		GRectShape gRect = new GRectShape();
//		gRect.setShape(getAttribute("PageType"));
//		gRect.setRect( rect );
//		return  gRect.getPath();

	} else if ( grid.getMoveMode() == GOperation.NEW ) {
		ZPoint ptSta= grid.getStartGrid();
		ZPoint ptMov= grid.getMoveGrid();
		if ( (ptMov.getX()-ptSta.getX()) < 10 ) { ptMov.setX(ptSta.getX()+100); }
		if ( (ptMov.getY()-ptSta.getY()) < 10 ) { ptMov.setY(ptSta.getY()+100); }
		ZPoint ptBR = new ZPoint( Math.max(ptMov.getX(),ptSta.getX()+30),
								  Math.max(ptMov.getY(),ptSta.getY()+20) );
		ZRectangle rect = new ZRectangle( ptSta, ptBR );

		// ^CvɂČ`قȂ
//  ***20020726*** PageSċ`ɕύX
//		GRectShape gRect = new GRectShape();
//		gRect.setShape(getAttribute("PageType"));
//		gRect.setRect( rect );
//		return  gRect.getPath();
		return  new ZPath( rect );
	}
	return super.getMovingPath(gob,grid);
	}

	/**
	 * ړ̊
	 * @param gob  NGXgGob
	 * @param grid ObhRg[
	 */
	public void moveEnd(GElement gob,DocGridControler grid) {
	DocPane editor = grid.getEditor();
	String szPanelId = editor.getPanelId();
	if ( isGobId(gob,"line") ) {
		// qbgGg΁AIvViڑ\}[Nj\
		if ( findConnectPage(editor.getPanelId(),grid.getMovePoint()) ) {
			updateConnectPage(editor.getPanelId());
		}
	} else if ( isGobId(gob,"map") ) {
		// ݈ʒu̎擾
		MapModel model = ((RidDocumentSite)getOwnerDocument()).getMapModel(szPanelId);
		double major = getMapPos( szPanelId, "Major" );
		// CircleMapŒ͈̎ړȂ
		if ( editor.getPanelId().endsWith("Circle") && major == 1 ) {
			return;
		}
		double minor = getMapPos( szPanelId, "Minor" );
		ZPoint ptOrg = new ZPoint(major,minor);
		ZPoint ptVw  = model.modelToView( ptOrg );
		
		// ݍWɃItZbgǉ
		ptVw.translate( grid.getOffsetGrid() );
		
		// ϊ̍W擾
		ZPoint ptTrans = model.viewToModel( ptVw );
		setMapPos( szPanelId, "Major", ptTrans.getX() );
		setMapPos( szPanelId, "Minor", ptTrans.getY() );

		// VNĂꍇ͈ړqy[W֔gy
		XElementNS vwi = getChildElement(".ViewInfo."+szPanelId,null);
		boolean bOmission = vwi.getBooleanAttr("Omission",false);
		if ( bOmission ) {
			Enumeration elm = mToLinksForCreateGob.elements();
			while ( elm.hasMoreElements() ) {

				// N̎擾
				RidElementLink toLink = (RidElementLink)elm.nextElement();
				RidElementPage toPage = (RidElementPage)toLink.getLinkToElement(this);
				toPage.moveEndOffset( szPanelId, grid.getOffsetGrid() );
			}
		}

	} else {
		super.moveEnd( gob, grid );
		switch ( grid.getMoveMode() ) {
		  case GOperation.NEW:		// VK쐬
			RidDocumentSite doc = (RidDocumentSite)getOwnerDocument();
			doc.requestRecalcMap();
			break;
		}
	}
	}

	/**
	 * ړ̊(MapplŃVNσy[WړꂽƂAqy[Ẅړ)
	 * @param szPanelId plʎq
	 * @param pt        ړItZbg
	 */
	public void moveEndOffset(String szPanelId, ZPoint offset) {
	MapModel model = ((RidDocumentSite)getOwnerDocument()).getMapModel(szPanelId);
	double major = getMapPos( szPanelId, "Major" );
	double minor = getMapPos( szPanelId, "Minor" );
	ZPoint ptOrg = new ZPoint(major,minor);
	ZPoint ptVw  = model.modelToView( ptOrg );
	
	// ݍWɃItZbgǉ
	ptVw.translate( offset );

	// ϊ̍W擾
	ZPoint ptTrans = model.viewToModel( ptVw );
	setMapPos( szPanelId, "Major", ptTrans.getX() );
	setMapPos( szPanelId, "Minor", ptTrans.getY() );

	// qy[W֔gy
	Enumeration elm = mToLinksForCreateGob.elements();
	while ( elm.hasMoreElements() ) {

		// N̎擾
		RidElementLink toLink = (RidElementLink)elm.nextElement();
		RidElementPage toPage = (RidElementPage)toLink.getLinkToElement(this);
		toPage.moveEndOffset( szPanelId, offset );
	}
	}

	//## I #########################################################
	/**
	 * I̕ύX
	 * @param gob  NGXgGob
	 * @param bSelect I
	 */
	public boolean setSelect( GElement gob,boolean bSelect ) {
	if ( isGobId(gob,"line") ) {
		mSelectLine = bSelect;
		return bSelect;
	}
	return super.setSelect(gob,bSelect);
	}

	/**
	 * q𖢑IԂɐݒ
	 */
	public void setChildUnSelect() {
	mSelectLine = false;
	super.setChildUnSelect();
	}

	/**
	 * lʂɂāAey[Wւ̃NIĂ邩H
	 */
	public boolean isSelectLine() {
	return mSelectLine;
	}

	//## ` #########################################################
	/**
	 * `Gg̎擾(Zonepl)
	 *
	 * [g̏ꍇ́Ag`悵Ȃ
	 * @param szPanelId plʎq
	 * @param isRoot    [g̗L
	 */
	public Vector createGobs(String szPanelId,boolean isRoot) {
	Vector gobs = new Vector();

	// g̍쐬
	if ( !isRoot ) {
		if ( !hasRect(szPanelId) ) {
			// CAEg
			ZPoint pt = getSpace(szPanelId);
			ZRectangle rt = new ZRectangle( pt.getX(), pt.getY(), 100, 100 );
			setRect(szPanelId,rt);
		}
		GRectangle gRect = createMainGob(szPanelId);
		gRect.setSelect(isSelect());
		gRect.setContainer(this);
		gRect.setGobId("zone");
		gRect.setMinSize(new ZDimension(30,20));
		gobs.add(gRect);
		setMainGob(szPanelId,gRect);

		// e̕`
		gRect.addBackChildren( createShadowGobs( gRect ) );

//		***20020726*** PageSċ`ɕύX
		String szPageType = getAttribute("PageType");
		if ( szPageType.length() > 0 && (!szPageType.equals("static")) ) {
			// RectShapePath擾
			GRectShape gShape = new GRectShape();
			gShape.setShape(getAttribute("PageType"));

			// 20020807 }[N`70%ɏk
			ZRectangle rt  = getRect( szPanelId );
			double dH  = rt.getHeight();
			double dW  = rt.getHeight();
			double par = 0.7;
			ZRectangle rtt = new ZRectangle( rt.getX()+dW*(1-par)/2,
											 rt.getY()+dH*(1-par)*3/4,
											 dW*par,dH*par);
			gShape.setRect( rtt );

			// Path쐬
			GPath gPath = new GPath();
			gPath.setPath( gShape.getPath() ) ;
			gPath.getStyle().setFillColor(   gRect.getStyle().getFillColor() );
			gPath.getStyle().setStrokeColor( gRect.getStyle().getStrokeColor() );

			gRect.getStyle().setFillColor(   new FColor( Color.white ) );
			gRect.addForeChild( gPath );
		}

		// O̕`
		gRect.addForeChildren( createTitleGobs( szPanelId ) );
	} else {
		
		// q̕`
		gobs.addAll(createChildGobs(szPanelId));
	}
	return gobs;
	}

	/**
	 * `Gg̎擾(Mappl)̑O
	 * NW߂
	 *
	 * @param szPanelId plʎq
	 */
	public void preCreateMapGobs(String szPanelId) {
	RidDocumentSite doc = (RidDocumentSite)getOwnerDocument();
	mToLinksForCreateGob = doc.getToLink(this,szPanelId);
	mFromPageForMoveGob  = doc.getFromPage(this);
	Enumeration elm = mToLinksForCreateGob.elements();
	while ( elm.hasMoreElements() ) {
		RidElementLink toLink = (RidElementLink)elm.nextElement();
		RidElementPage toPage = (RidElementPage)toLink.getLinkToElement(this);
		toPage.preCreateMapGobs( szPanelId );
	}
	}

	/**
	 * `Gg̎擾(Mappl)
	 *
	 * @param szPanelId plʎq
	 * @param nHierl    쐬Gobi[Kw
	 * @param gobAll    쐬Gobi[̈
	 */
	public void createMapGobs(String szPanelId,int nHier, Vector gobAll) {
	// 쐬Gobi[邽߂̗̈̐ݒ
	Vector lineGobs = (Vector)gobAll.elementAt(0);
	Vector gobs = null;
	if ( gobAll.size() > nHier ) {
		gobs = (Vector)gobAll.elementAt( nHier );
	} else {
		gobs = new Vector();
		gobAll.add( gobs );
	}
	RidDocumentSite doc = (RidDocumentSite)getOwnerDocument();

	// MainGob
	GPath gPath = createMapMainGob(szPanelId);
	gPath.setSelect(isSelect());
	gPath.setContainer(this);
	gPath.setGobId("map");
	setMainGob(szPanelId,gPath);
	gobs.add(gPath);

	// e̕`
	gPath.addBackChildren( createShadowGobs( gPath ) );

	//-------------------------------------------------------------
	// ^Cg̈
	//-------------------------------------------------------------
//	Vector foreChild = new Vector();
	MapModel model = doc.getMapModel(szPanelId);
	double major = getMapPos( szPanelId, "Major" );
	double minor = getMapPos( szPanelId, "Minor" );

	boolean isExist = getBooleanAttr("Exist", true );
	Shape shPage = model.createTitleShape( major,minor);
	ZPath titlePath = new ZPath( shPage );
	gPath.addForeChild( createMapTitleGob(titlePath,isExist) );

	//-------------------------------------------------------------
	// ~̕`
	//-------------------------------------------------------------
	ZRectangle rtMain = new ZRectangle( gPath.getPath().getBounds2D() );
	Color   bgColor = doc.getBackground(szPanelId);
	boolean bCircle = szPanelId.endsWith("Circle");
	if ( major == 1.0 && bCircle ) {
		XElementNS elm = findChildElement(".ViewInfo."+szPanelId,null);
		if ( elm != null ) {
			ZPoint     pt = rtMain.getCenter();
			int nDepth = elm.getIntAttr("Depth",0);
			double dOff = model.getCircleOffset();
			for ( int nIndex=nDepth-1 ; nIndex>=0 ; nIndex-- ) {
				GEllipse gEllipse = new GEllipse();
				double off = dOff*nIndex+dOff/2;
				ZPoint   ptTL = new ZPoint(pt.getX()-off,pt.getY()-off);
				ZPoint   ptBR = new ZPoint(pt.getX()+off,pt.getY()+off);
				gEllipse.setRect( new ZRectangle(ptTL,ptBR) );
				gEllipse.getStyle().setStrokeColor( new FColor( Color.white ) );
				gEllipse.setSelectable( false );
				lineGobs.add( gEllipse );
			}
		}
	}

	//-------------------------------------------------------------
	// O
	//-------------------------------------------------------------
	ZResource res = ZApp.getTheApp().getResource();
	String szTextType = res.getString("viewtext.Zone."+getTagName());
	String szText = getAttribute(szTextType);
	if ( szText.length() > 0 ) {
		double dIndent = 0;
		if ( getBooleanAttr("Indent",false) && szPanelId.endsWith("Hier") ) {
			dIndent = getTitleHeight();
		}
		ZRectangle rttxt = new ZRectangle( rtMain.getX(), rtMain.getY()+rtMain.getHeight()+6+dIndent,
										1000,getTitleHeight());
		GString str = new GString();
		str.setText( szText );
		str.getStyle().setFillColor( new FColor( Color.black ));
		str.setFormat( GString.SINGLE|GString.LEFT|GString.TOP );
		str.setRect( rttxt );
		gPath.addForeChild(str);
	}

	//-------------------------------------------------------------
	// VNL̔
	//-------------------------------------------------------------
	XElementNS vwi = getChildElement(".ViewInfo."+szPanelId,null);
	boolean bOmission = vwi.getBooleanAttr("Omission",false);
	
	if ( bOmission ) {

		FInteger[] childCount = new FInteger[2];
		childCount[0] = new FInteger(0);
		childCount[1] = new FInteger(0);
		getMapChildCount(szPanelId, childCount);
		int nTotal = childCount[0].get() + childCount[1].get();
		int nExist = childCount[0].get();


		Vector omiGobs    = new Vector();
		Vector omiShadows = new Vector();

		// VNe
		ZPath omiMainPath  = gPath.getPath();
		ZPath omiTitlePath = new ZPath(titlePath);

		for ( int nIndex=0 ; nIndex<nTotal ; nIndex++ ) {
			AffineTransform at = new AffineTransform(1,0,0,1,4,-3);
			ZPath transMain  = new ZPath(at.createTransformedShape(omiMainPath));
			ZPath transTitle = new ZPath(at.createTransformedShape(omiTitlePath));

			// ݃tO
			boolean bExist = true;
			if ( nIndex >= nExist ) {
				bExist = false;
			}

			// ^Cg
			omiGobs.add( 0,createMapTitleGob(transTitle,bExist) );
			// {
			GPath gOmiMan = createMapMainGob(transMain,bExist);
			omiGobs.add( 0,gOmiMan );
			// e
			omiShadows.addAll( createShadowGobs( gOmiMan ) );
			
			// pX̕ύX
			omiMainPath  = transMain;
			omiTitlePath = transTitle;
		}
		gPath.addBackChildren( omiShadows );
		gPath.addBackChildren( omiGobs );

	//-------------------------------------------------------------
	// qy[WƁÃN̕`
	//-------------------------------------------------------------
	} else {
		ZPoint ptStart = model.getLinkPoint( major,minor );
		ZPoint ptLink  = model.getLinkHarfPoint( major,minor );

		boolean bMeDraw = false;
		GLine line = null;
		Enumeration elm = mToLinksForCreateGob.elements();
		while ( elm.hasMoreElements() ) {

			// N̎擾
			RidElementLink toLink = (RidElementLink)elm.nextElement();
			RidElementPage toPage = (RidElementPage)toLink.getLinkToElement(this);

			Color colLine = toLink.getBackgroundColor();
			// x̒
			String szIntensity = toLink.getAttribute("Intensity");
			float width = 0f;
			if ( szIntensity.equals("Virtual") ) {
				colLine = res.getColor("unit.color.StrongLink");
				width =2.0f;
			}
			// [Uݒ̒
			if ( toPage.getChildElementAttribute(".ViewInfo."+szPanelId,null,"Type").equals("User") ) {
				colLine = Color.blue;
			}
			// ݂Ȃꍇ͐
			if ( !toLink.getBooleanAttr("Exist", true ) ) {
				colLine = res.getColor("unit.color.NotExist");
			}
			// T[NMap͒`
			if ( bCircle ) {
				double majorChild = toPage.getMapPos( szPanelId, "Major" );
				double minorChild = toPage.getMapPos( szPanelId, "Minor" );
				ZPoint ptStartChild = model.getLinkPoint( majorChild,minorChild );

				line = new GLine();
				line.getStyle().setStrokeColor( new FColor( colLine ));
				line.setLine( new ZLine(ptStartChild,ptStart) );
				line.setSelect(toPage.isSelectLine());
				line.setContainer(toPage);
				line.setGobId("line");
				lineGobs.add(line);
			} else {
				if ( !bMeDraw ) {
					// ̈o`
					line = new GLine();
					line.getStyle().setStrokeColor( new FColor( Color.black ));
					line.setLine( new ZLine(ptStart,ptLink) );
					line.setSelectable( false );
					lineGobs.add(line);
					bMeDraw = true;
				}
				double majorChild = toPage.getMapPos( szPanelId, "Major" );
				double minorChild = toPage.getMapPos( szPanelId, "Minor" );
				ZPoint ptStartChild = model.getLinkPoint( majorChild,minorChild );
				ZPoint ptLinkChild  = model.getLinkHarfPoint( major,minorChild);

				// q̈o`
				// I\GobƂēo^
				line = new GLine();
				line.getStyle().setStrokeColor( new FColor( colLine ));
				if ( width != 0f ) {
					line.getStyle().getStroke().getWidth().set(width);
				}
				line.setLine( new ZLine(ptStartChild,ptLinkChild) );
				line.setSelect(toPage.isSelectLine());
				line.setContainer(toPage);
				line.setGobId("line");
				lineGobs.add(line);

				// `
				line = new GLine();
				line.getStyle().setStrokeColor( new FColor( Color.black ));
				line.setLine( new ZLine(ptLink,ptLinkChild) );
				line.setSelectable( false );
				lineGobs.add(line);

			}
			// q`
			toPage.createMapGobs( szPanelId, nHier+1, gobAll );
		}
	}

	// ANZXO̒ǉL̔
	boolean bViewAccess = res.getBoolean("view.Page.AccessCount");
	if ( bViewAccess && szPanelId.endsWith("Site") ) {
		AccessCounts acc = new AccessCounts( getAttribute("AccessCount") );
		Shape[] sha = model.createAccessShapes( major,minor,acc );
		ZProperties prop = DocManager.loadProperty( DocManager.DOCUMENT );
		if ( sha != null ) {
			int nMaxColor = -1 ;
			Color col = res.getColor("unit.color.AccessCount");
			for ( int nAt=0 ; nAt < sha.length ; nAt++ ) {
				// F̌
				col = null;
				if ( nMaxColor == -1 ) {
					String szKey = "accesslog.color."+nAt;
					if ( prop.getProperty( szKey ) == null ) {
						nMaxColor = nAt;
					} else {
						col = prop.getColor(szKey);
					}
				}
				if ( col == null ) {
					if ( nMaxColor == 0 ) {
						col = res.getColor("unit.color.AccessCount");
					} else {
						int nColAt  = nAt % nMaxColor ;
						int nRotate = nAt / nMaxColor ;
						col = prop.getColor("accesslog.color."+nColAt);
					}
				}

				// pX̐
				GPath gAccess = new GPath();
				gAccess.setPath( new ZPath( sha[nAt] ) );
				gAccess.getStyle().setFillColor( new FColor( col ));
				gAccess.getStyle().setStrokeColor( new FColor( Color.white ));
				gPath.addForeChild( gAccess );
			}
		}
	}
	}

	/**
	 * ANZXől̎擾
	 * Ny[W܂߂ĊKwz̍ől߂
	 * @param szPanelId plʎq
	 * @param bLogList  \z
	 */
	public AccessCounts getMaxAccessCount(String szPanelId,boolean[] bLogList ) {
	AccessCounts acc = new AccessCounts(getAttribute("AccessCount"),bLogList);
	RidDocumentSite doc = (RidDocumentSite)getOwnerDocument();

	// VNL̔
	XElementNS vwi = getChildElement(".ViewInfo."+szPanelId,null);
	boolean bOmission = vwi.getBooleanAttr("Omission",false);
	
	if ( !bOmission ) {
		Enumeration elm = mToLinksForCreateGob.elements();
		while ( elm.hasMoreElements() ) {

			// N̎擾
			RidElementLink toLink = (RidElementLink)elm.nextElement();
			RidElementPage toPage = (RidElementPage)toLink.getLinkToElement(this);

			// qy[W擾
			AccessCounts acc2 = toPage.getMaxAccessCount( szPanelId,bLogList );
			acc.margeMax( acc2 );
		}
	}
	return acc;
	}

	/**
	 * `Gg̎擾
	 *
	 * [g̏ꍇ́AgwiƂĕ`悷
	 * @param szPanelId plʎq
	 * @param isRoot    [g̗L
	 */
	public Vector createSkeltonGobs(String szPanelId,boolean isRoot) {
	Vector gobs = new Vector();

	GRectangle gRect = createMainGob(szPanelId);
	gRect.setPaintIfSmall(true);
	gobs.add(gRect);

	return gobs;
	}

	/**
	 * `Gg̎擾
	 *
	 * [g̏ꍇ́AgwiƂĕ`悷
	 * @param szPanelId plʎq
	 * @param isRoot    [g̗L
	 */
	public Vector createMapSkeltonGobs(String szPanelId) {
	Vector gobs = new Vector();
	GPath gPath = createMapMainGob(szPanelId);
	gPath.setPaintIfSmall(true);
	gobs.add(gPath);

	XElementNS vwi = getChildElement(".ViewInfo."+szPanelId,null);
	boolean bOmission = vwi.getBooleanAttr("Omission",false);
	
	if ( !bOmission ) {
//		RidDocumentSite doc = (RidDocumentSite)getOwnerDocument();
//		Vector pages = doc.getLinkToPage(this);
		Enumeration elm = mToLinksForCreateGob.elements() ;
		while ( elm.hasMoreElements() ) {

			// N̎擾
			RidElementLink toLink = (RidElementLink)elm.nextElement();
			RidElementPage toPage = (RidElementPage)toLink.getLinkToElement(this);

			// ʏAtoPagenull̏ꍇ́AN폜͂A
			// ĕ`̃^C~OŒOmToLinksForCreateGobcĂꍇB
			if ( toPage != null ) {
				gobs.addAll(toPage.createMapSkeltonGobs(szPanelId));
			}
		}
	}
	return gobs;
	}

	/**
	 * `Gg̎擾
	 * @param szPanelId plʎq
	 */
	protected GRectangle createMainGob(String szPanelId) {
//  ***20020726*** PageSċ`ɕύX
//	GRectShape gRect = new GRectShape();
//	gRect.setShape(getAttribute("PageType"));
	GRectangle gRect = new GRectangle();

	// `̐ݒ
	ZRectangle rect = getRect( szPanelId );
	gRect.setRect( rect );
	// wiF̐ݒ
	Color col = getBackgroundColor();
	gRect.getStyle().setFillColor( new FColor( col ));

	// gF̐ݒ
	ZResource res = ZApp.getTheApp().getResource();
	boolean isExist = getBooleanAttr("Exist", true );
	col = res.getColor("unit.color."+((isExist)?"":"Not")+"Exist");
	gRect.getStyle().setStrokeColor( new FColor( col ) );
	return gRect;
	}

	/**
	 * ^Cg̍쐬
	 * @param szPanelId plʎq
	 */
	public Vector createTitleGobs(String szPanelId) {
	return super.createTitleGobs( szPanelId ) ;
	}

	/**
	 * `Gg̎擾(MappC)
	 * @param szPanelId plʎq
	 */
	protected GPath createMapMainGob(String szPanelId) {
	MapModel model = ((RidDocumentSite)getOwnerDocument()).getMapModel(szPanelId);
	double major = getMapPos( szPanelId, "Major" );
	double minor = getMapPos( szPanelId, "Minor" );

	Shape shPage = model.createPageShape( major,minor,getAttribute("PageType"));
	ZPath path = new ZPath(shPage);
	boolean isExist = getBooleanAttr("Exist", true );
	return createMapMainGob( path,isExist ) ;
	}

	/**
	 * `Gg̎擾(ViI)
	 * @param szPanelId plʎq
	 */
	protected ZPath getMapScenarioPath(String szPanelId) {
	MapModel model = ((RidDocumentSite)getOwnerDocument()).getMapModel(szPanelId);
	double major = getMapPos( szPanelId, "Major" );
	double minor = getMapPos( szPanelId, "Minor" );

	// pX̍쐬
	Shape shPage = model.createScenarioShape( major,minor);
	ZPath path = new ZPath(shPage);

	return path;
	}

	/**
	 * `Gg̎擾(MappC)
	 * @param path    `
	 * @param isExist ݗL
	 */
	protected GPath createMapMainGob( ZPath path, boolean isExist ) {
	GPath gpath = new GPath();
	// ̈̐ݒ
	gpath.setPath( path );
	// wiF̐ݒ
	Color col = getBackgroundColor();
	gpath.getStyle().setFillColor( new FColor( col ));

	// gF̐ݒ
	ZResource res = ZApp.getTheApp().getResource();
	col = res.getColor("unit.color."+((isExist)?"":"Not")+"Exist");
	gpath.getStyle().setStrokeColor( new FColor( col ));
	return gpath;
	}

	/**
	 * `Gg̎擾(Mapp^Cg)
	 * @param path    `
	 * @param isExist ݗL
	 */
	protected GPath createMapTitleGob( ZPath path, boolean isExist ) {
	GPath gTitle = new GPath();
	// ̈̐ݒ
	gTitle.setPath( path );
	// wiF̐ݒ
	Color col = ((RidElement)getParentNode()).getBackgroundColor();
	gTitle.getStyle().setFillColor( new FColor( col ));

	// gF̐ݒ
	ZResource res = ZApp.getTheApp().getResource();
	col = res.getColor("unit.color."+((isExist)?"":"Not")+"Exist");
	gTitle.getStyle().setStrokeColor( new FColor( col ));
	return gTitle;
	}

	/**
	 * MapʂɂqPage̐vZ
	 * @param szPanel plʎq
	 * @param count   qy[W̃JEg̔z(0Ԗ:exist=true,1Ԗ:exist=false)
	 */
	protected void getMapChildCount(String szPanelId, FInteger[] count ) {
	Enumeration elm = mToLinksForCreateGob.elements();
	while ( elm.hasMoreElements() ) {

		// N̎擾
		RidElementLink toLink = (RidElementLink)elm.nextElement();
		RidElementPage toPage = (RidElementPage)toLink.getLinkToElement(this);

		// q̂ŁAqɌvZ
		toPage.getMapChildCount(szPanelId,count);
		boolean isExist = toPage.getBooleanAttr("Exist", true );
		if ( isExist ) {
			count[0].increment();
		} else {
			count[1].increment();
		}
	}
	}

	//## l`oFČvZ ###############################################
	/**
	 * MAP̃NA
	 * @param szPanelId plʎq
	 */
	public void clearMap(String szPanelId) {
	wMajorCalcing = false;
	wMajorTmp = 0;
	wMinorTmp = 0;
	wTopId    = 0;
	wMajorPre = getMapPos( szPanelId, "Major" );
	wMinorPre = getMapPos( szPanelId, "Minor" );

	wFromLink  = null;
	wFromPage  = null;
	wUserSettingParent = null;
	wFromLinks = new Vector();
	// [Uݒ̐e΁A[Uݒ̐eۑAwFromLinksnullɐݒ
	RidDocumentSite doc = (RidDocumentSite)getOwnerDocument();
	String szParent = getMapParent( szPanelId, "User" );
	if ( szParent.length()>0 ) {
		wUserSettingParent = (RidElementPage)doc.findChildElementInZone("PageUnit",szParent);
	}
	
	wToLinksForRecalcMap = doc.getToLink( this, null );
	}

	/**
	 * Mapԍ̕t^ƁAe
	 * @param szPanelId  plʎq
	 * @param fromLink   ey[Wւ̃N
	 * @param isZoneBase ][DASY
	 * @param nTop       gbvxID
	 */
	public boolean recalcMapMajor(String szPanelId,RidElementLink fromLink, boolean isZoneBase, int nTop) {
	/*** Debug ***/	boolean bDebug = false;
//	/*** Debug ***/	if ( getAttribute("File").equals("map_osaki.html") ) bDebug = true;
	boolean calced = false;
	// vZ̏ꍇ́AČvZȂ
	if ( wMajorCalcing ) {
		return calced;
	}
	wMajorCalcing = true;

	// VW[ԍ̐ݒ
	// eȂ̏ꍇ́Amajor1ɐݒ eꍇ́Ae{P
	double         nMajor   = 1;
	RidElementPage fromPage = null;
	if ( fromLink != null ) {
		fromPage = (RidElementPage)fromLink.getLinkFromElement(this);
		nMajor   = fromPage.wMajorTmp+1;
	}

	// ĂяóAwMajorTmp == 0 Ȃ̂ŌvZ
	if ( wMajorTmp == 0 ) {
		calced = true;

	// łɃ[gɂȂĂ΁A 							wFromLink == null Ȃ̂Őe͕ςȂ
	// łɐe܂ĂāA[g̍ČĂяoł΁A	fromLink == null Ȃ̂Őe͕ςȂ
	} else if ( wFromLink != null && fromLink != null ) {
		if ( isZoneBase ) {
			RidElementLink newFromLink = null;
			if ( wFromLink == fromLink ) {
				// ݐeły[WԂ̕ύXꂽ
	/*** Debug ***/if(bDebug){ZDebug.trace("ꃊN̍ČvZ:"+nMajor+","+wMajorTmp);}
				// Kwς̂ŕKČvZixXgςȂꍇČvZj
				// KwςȂꍇ͍ČvZȂ
				if ( nMajor != wMajorTmp ) {
					newFromLink = recalcBestLink(wFromLinks);
					if ( newFromLink == null ) {
						newFromLink = fromLink;
					}
				}

			// ݂̐eւ̃NƈقȂ郊NĂяoꂽꍇ
			} else {
				// NXgɍ̃Nǉ
				if ( !wFromLinks.contains( fromLink ) ) {
					wFromLinks.add( fromLink );
				}

				RidElementPage oldParent = (RidElementPage)wFromLink.getLinkFromElement(this);
				RidElementPage newParent = (RidElementPage)fromLink.getLinkFromElement(this);
				if ( oldParent == newParent ) {
					// ey[W畡̃NĂꍇݐeły[WԂ̕ύXꂽ
					// KwςȂꍇ͍ČvZȂ
					if ( nMajor != wMajorTmp ) {
						// Kwς\̂ōČvZ
						newFromLink = recalcBestLink(wFromLinks);
						fromLink = null;
					}

				} else {
					// ݐeƂ͈قȂy[WeɂȂ̂ŁAݐẽNƁAVẽN̂ǂD悷邩
					Vector links = new Vector();
					links.add( fromLink );	// ̃N
					newFromLink = recalcBestLink(links);
				}
			}
			
			// ČvZꍇ
			if ( newFromLink != null ) {
				calced = true;
				fromLink = newFromLink;
				fromPage = (RidElementPage)fromLink.getLinkFromElement(this);
				nMajor   = fromPage.wMajorTmp+1;
	/*** Debug ***/if(bDebug){ZDebug.trace("xXge̍Đݒ:"+fromPage.getAttribute("File")+" nMajor:"+nMajor);}
			}

		} else {
			// VW[ԍ`ς݃W[ԍ菬͍ČvZ
			if ( nMajor < wMajorTmp ) {
				calced = true;
			}
		}
	}

	// MapԍČvZ
	if ( calced ) {
		// Majorԍ̐ݒ
		wMajorTmp = nMajor;
		wTopId    = nTop;
		wFromLink = fromLink;
		wFromPage = fromPage;
	/*** Debug ***/if(bDebug){ZDebug.trace("vZJn:"+nMajor+":"+((fromPage!=null)?fromPage.getAttribute("File"):""));}

		// Ñy[WMapԍݒ肷
//		Vector links = ((RidDocumentSite)getOwnerDocument()).getToLink(this);
		Enumeration elm = wToLinksForRecalcMap.elements() ;
		while ( elm.hasMoreElements() ) {
			RidElementLink toLink = (RidElementLink)elm.nextElement();
			RidElementPage toPage = (RidElementPage)toLink.getLinkToElement(this);
			toPage.recalcMapMajor(szPanelId,toLink,isZoneBase,nTop);
		}
//		ZDebug.trace("vZF"+getAttribute("Key")+"("+wMajorTmp+","+wMinorTmp+") ");
//		if ( wParent != null ) {
//			ZDebug.trace("     e"+wParent.getAttribute("File"));
//		}
	}
//	ZDebug.trace("vZς݁F"+getAttribute("Key")+"("+wMajorTmp+","+wMinorTmp+")");

	wMajorCalcing = false;
	return calced;
	}

	/**
	 * œKȃNvZ
	 * @param fromLinks  ey[W̃NQ
	 */
	public RidElementLink recalcBestLink(Vector links) {
	// ݒ
	String myZone   = ((DocElement)getParentNode()).getAttribute("File");
	RidElementLink oldLink   = wFromLink;
	RidElementPage oldParent = (RidElementPage)oldLink.getLinkFromElement(this);

	if ( wUserSettingParent == oldParent ) {
		// łɃ[Uݒ肪LɂȂĂ̂ŁAČvZȂ
		return null;
	}

	// ̃NƔr
	Enumeration elm = links.elements();
	while ( elm.hasMoreElements() ) {
		RidElementLink newLink   = (RidElementLink)elm.nextElement();
		RidElementPage newParent = (RidElementPage)newLink.getLinkFromElement(this);

		// [Uݒ̒
		if ( wUserSettingParent == newParent ) {
			return newLink;
		}

		// Nx̔r
		String szOldIntensity = oldLink.getAttribute("Intensity");
		String szNewIntensity = newLink.getAttribute("Intensity");
		int oldIntensity = 0;
		if ( szOldIntensity.equals("Virtual") )			{oldIntensity=1;}
		int newIntensity = 0;
		if ( szNewIntensity.equals("Virtual") )			{newIntensity=1;}
		if ( oldIntensity < newIntensity ) {
			oldLink = newLink;
		} else if ( oldIntensity == newIntensity ) {
			boolean bTopCheck = false;
			// x͓Ȃ̂ŁA][̔r
			oldParent = (RidElementPage)oldLink.getLinkFromElement(this);
			String oldZone = ((DocElement)oldParent.getParentNode()).getAttribute("File");
			String newZone = ((DocElement)newParent.getParentNode()).getAttribute("File");

			// xXgeƐVeƂɓ][̏ꍇ́AgbvxD
			if ( myZone.equals( oldZone ) && myZone.equals( newZone ) ) {
				bTopCheck = true;

			// xXgẽ][قȂAVeƃ][ł΁AČvZ
			} else if ( myZone.equals( newZone ) ) {
				oldLink = newLink;

			// ǂ][قȂ΁AgbvxD
			} else {
				bTopCheck = true;
			}

			// gbvx̔r
			if ( bTopCheck ) {
				if ( oldParent.wTopId > newParent.wTopId ) {
					oldLink = newLink;

				} else if ( oldParent.wTopId == newParent.wTopId ) {
					// gbvxłMajoȑD
					if ( oldParent.wMajorTmp > newParent.wMajorTmp ) {
						oldLink = newLink;
					}
				}
			}
		}
	}
	
	// ݂̃NœKȃNł΍ČvZȂ
	if ( oldLink == wFromLink ) {
		return null;
	}
	return oldLink;
	}

	/**
	 * Minorԍ̕t^
	 * @param szPanelId  plʎq
	 * @param nMinor     Jnminor ԍ
	 * @param bIndent    L
	 */
	public MapMinorTree recalcMapMinor(String szPanelId,double nMinor, boolean bIndent) {
	// ԖڂȂA^CgPi
	wTitleIndent = bIndent;
//	ZDebug.trace("Name:"+getAttribute("Name")+" No:"+nMinor+" ident:"+wTitleIndent);

	// q̃y[W
	Vector childPages = new Vector();
	Enumeration elm = wToLinksForRecalcMap.elements() ;
	while ( elm.hasMoreElements() ) {

		// N̎擾
		RidElementLink toLink = (RidElementLink)elm.nextElement();
		RidElementPage toPage = (RidElementPage)toLink.getLinkToElement(this);

		if ( toPage.wFromPage == this ) {
			childPages.add( toPage ) ;
		}
	}

	// }Ci[ԍt^
	MapMinorTree tree = null;
	if ( childPages.size() > 0 ) {
		tree = ((RidDocumentSite)getOwnerDocument()).recalcMapMinor(szPanelId, childPages, nMinor,bIndent);
		wMinorTmp = tree.getChildHarf();
	} else {
		tree = new MapMinorTree();
		tree.setLastIndent( bIndent );
		wMinorTmp = nMinor;
	}
	tree.add( wMinorTmp );
	return tree;
	}

	/**
	 * Minorԍ̈ړ
	 * @param szPanelId  plʎq
	 * @param offset     ړ
	 */
	public MapMinorTree recalcMapMinorMove(String szPanelId,double offset) {
	// q̃y[W
	Vector childPages = new Vector();
	MapMinorTree tree = null;
	Enumeration elm = wToLinksForRecalcMap.elements() ;
	while ( elm.hasMoreElements() ) {
		// N̎擾
		RidElementLink toLink = (RidElementLink)elm.nextElement();
		RidElementPage toPage = (RidElementPage)toLink.getLinkToElement(this);

		if ( toPage.wFromPage == this ) {
			MapMinorTree tree2 = toPage.recalcMapMinorMove(szPanelId,offset);
			if ( tree == null ) {
				tree = tree2;
			} else {
				tree.marge( tree2 );
			}
		}
	}

	wMinorTmp += offset;
	if ( tree == null ) {
		tree = new MapMinorTree();
	}
	tree.add( wMinorTmp );
	return tree;
	}

	/**
	 * Mapԍ̐ݒ(Ō)
	 * vZςmajor,minorposɐݒ肷
	 * @param szPanelId  plʎq
	 * @param dTotal minorԍ̍ől
	 */
	public ZRectangle recalcMapEnd(String szPanelId, double dTotal){
	setMapPos(szPanelId, "Major", wMajorTmp);
	if ( szPanelId.endsWith("Circle") ) {
//		setMapPos(szPanelId, "Minor", (2*Math.PI/(dTotal+1))*wMinorTmp );
		setMapPos(szPanelId, "Minor", (2*Math.PI/dTotal)*wMinorTmp );
	} else {
		setMapPos(szPanelId, "Minor", wMinorTmp-(dTotal/2) );
	}

	// e[Uw̐eł΁Aݒ肵Ȃ
	String szAttrParent = getMapParent( szPanelId, "User" );
	String szLinkParent = (wFromPage==null)?"root":wFromPage.getAttribute("File");
	if ( szAttrParent.length() == 0 || !szAttrParent.equals(szLinkParent) ) {
		setMapParent( szPanelId, "Auto", szLinkParent );
	}
//	ZDebug.trace("complete:"+getAttribute("File")+"("+wMajorTmp+","+wMinorTmp+")");

	// ̐ݒ
	setBooleanAttr("Indent", wTitleIndent );

	// vZA`悷`Ԃ
	// 20020305ǉ
	MapModel model = ((RidDocumentSite)getOwnerDocument()).getMapModel(szPanelId);
	double major = getMapPos( szPanelId, "Major" );
	double minor = getMapPos( szPanelId, "Minor" );
	Shape shPage = model.createPageShape( major,minor,getAttribute("PageType"));
	return new ZRectangle(shPage);
	}

	//## l`o #######################################################
	/**
	 * Mapʒu̎擾
	 * @param szPanelId plʎq
	 * @param szType    ^Cv
	 */
	public double getMapPos(String szPanelId, String szType) {
	XElementNS elm = findChildElement(".ViewInfo."+szPanelId,null);
	if ( elm != null ) {
		return elm.getDoubleAttr(szType,0);
	}
	return 0;
	}

	/**
	 * Mapʒu̐ݒ
	 * @param szPanelId plʎq
	 * @param szType    ^Cv
	 * @param value     l
	 */
	public void setMapPos(String szPanelId, String szType, double value) {
	XElementNS elm = getChildElement(".ViewInfo."+szPanelId,null);
	elm.setDoubleAttr(szType,value);
	}

	/**
	 * Mape̎擾
	 * @param szPanelId plʎq
	 * @param szType    ^Cv{"User|Auto"}
	 */
	public String getMapParent(String szPanelId, String szType) {
	XElementNS elm = findChildElement(".ViewInfo."+szPanelId,null);
	if ( elm != null ) {
		if ( szType == null ) {
			return elm.getAttribute("Parent");
		} else if ( elm.getAttribute("Type").equals(szType) ) {
			return elm.getAttribute("Parent");
		}
	}
	return "";
	}

	/**
	 * Mape̐ݒ
	 * @param szPanelId plʎq
	 * @param szType    ^Cv
	 * @param value     l
	 */
	public void setMapParent(String szPanelId, String szType, String value) {
	XElementNS elm = getChildElement(".ViewInfo."+szPanelId,null);
	elm.setAttribute("Type",szType);
	elm.setAttribute("Parent",value);
	}

	//## N ###################################################
	/**
	 * ڑłReiTB
	 * @param szPanelId plʎq
	 * @param pt        W
	 */
	protected boolean findConnectPage(String szPanelId, ZPoint pt) {
	RidDocumentSite doc = (RidDocumentSite)getOwnerDocument();
	// qbgRei݂邩H
	Enumeration elm = GobManager.elements(szPanelId,GobManager.ALL);
	while ( elm.hasMoreElements() ) {
		GElement item = (GElement)elm.nextElement();
		byte pos = item.getConnectMode(pt, this);
		if ( pos != 0 ) {
			RidElementPage container = (RidElementPage)item.getContainer();
			if ( container != null && container != this ) {

				DocElement linklist = (DocElement)((DocElement)doc.getDocumentElement()).findChildElement(".Link",null);
				if ( linklist != null ) {
					NodeList list = linklist.getChildNodes();
					for ( int nAt=0 ; nAt<list.getLength() ; nAt++ ) {
						Node child = list.item(nAt);
						if ( child instanceof RidElementLink ) {
							RidElementLink linkUnit = (RidElementLink)child;
							RidElement toPage = linkUnit.getLinkToElement(container);
							if ( toPage == this ) {
								mConnectParent = container;
								return true;
							}
						}
					}
				}
/*
				// qbgy[W玩ɌăN邩H
				Vector linkTos = doc.getLinkToPage( container );
				Enumeration elmLink = linkTos.elements();
				while ( elmLink.hasMoreElements() ) {
					if ( elmLink.nextElement() == this ) {
						mConnectParent = container;
						return true;
					}
				}
*/
			}
		}
	}
	mConnectParent = null;
	return false;
	}

	/**
	 * oς̐ڑłReiDOMɔf
	 * @param szPanelId plʎq
	 */
	protected void updateConnectPage(String szPanelId) {
	setMapParent(szPanelId,"User",mConnectParent.getAttribute("File"));
	}

	//## ҏW #########################################################
	/**
	 * ̐ݒ
	 */
	public void setText(String szText) {
	setAttribute("Name",szText);
	if ( !szText.equals( getAttribute("Name") ) ) {
		RidException err = (RidException)ZInstance.map().get("setAttribute");
		MessageDialog.showError(err.getMessage());
	}
	}

	/**
	 * ̎擾
	 */
	public String getText() {
	return 	getAttribute("Name");
	}

	//## SubTag #######################################################
	/**
	 * Tu^O̐ݒ
	 * Docbar琶ƂattributeŗL̂̂ɂ邽߂̃L[
	 * @param szText Tu^O
	 */
	public void setSubTag(String szText) {
	setAttribute("PageType",szText);
	}

	//## Agr[g################################################
	/**
	 * MapʂɂāAey[Wւ̃NCI̗L
	 */
	protected boolean mSelectLine = false;

	/**
	 * eύẌꎞeGg
	 */
	protected RidElementPage mConnectParent = null;

	/**
	 * CreateGobpnbVf[^
	 */
	protected Vector mToLinksForCreateGob = new Vector();

	/**
	 * MoveGobpnbVf[^
	 */
	protected Vector mFromPageForMoveGob = new Vector();

	//## Agr[gFČvZpꎞf[^ ###########################
	/**
	 * MapČvZtO
	 */
	public boolean wMajorCalcing = false;
	/**
	 * MapČvZMajorԍ
	 */
	public double wMajorTmp = 0;
	/**
	 * MapČvZMinorԍ
	 */
	public double wMinorTmp = 0;
	/**
	 * MapČvZTopLevelId
	 */
	public double wTopId = 0;
	/**
	 * MapČvZOMajorԍ
	 */
	public double wMajorPre = 0;
	/**
	 * MapČvZOMinorԍ
	 */
	public double wMinorPre = 0;
	/**
	 * MapČvZ̉eւ̃N
	 */
	public RidElementLink wFromLink = null;
	/**
	 * MapČvZ̉e
	 */
	public RidElementPage wFromPage = null;
	/**
	 * MapČvZ̉eւ̃NQ
	 */
	public Vector wFromLinks   = null;
	/**
	 * [Uw̐e
	 */
	public RidElementPage wUserSettingParent = null;
	/**
	 * HierMapɂ^Cg̎
	 */
	protected boolean wTitleIndent = false;

	/**
	 * RecalcMappnbVf[^
	 */
	protected Vector wToLinksForRecalcMap = new Vector();

}
