/*
 * @(#)RidElementLink.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : Element
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/11/07
 */
package jp.co.nri.rid.doc;

import java.awt.Color;

import java.io.File;

import java.util.Enumeration;
import java.util.Vector;

import org.w3c.dom.DOMException;

import jp.co.iti.fagot.ZApp;

import jp.co.iti.fagot.fob.FColor;
import jp.co.iti.fagot.fob.xml.XElementNS;

import jp.co.iti.fagot.geom.ZPoint;
import jp.co.iti.fagot.geom.ZPath;
import jp.co.iti.fagot.geom.ZLine;
import jp.co.iti.fagot.geom.ZRectangle;

import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.GLine;
import jp.co.iti.fagot.gob.GString;
import jp.co.iti.fagot.gob.GOperation;
import jp.co.iti.fagot.gob.GobManager;

import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocGridControler;
import jp.co.iti.fagot.doc.DocPane;

import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZDebug;
import jp.co.iti.fagot.util.ZString;

import jp.co.nri.Rid;
/**
 * Rid Element(Linkp)
 */
public class RidElementLink extends RidElement {

	/**
	 * ftHgRXgN^
	 */
	public RidElementLink() throws DOMException {
	for ( int nIndex=0 ; nIndex<2 ; nIndex++ ) {
		mConnectContainer[nIndex] = null;
	}
	}

	/**
	 * RlNgGg̎擾
	 * vpeBplŕ\邽߂̓ʑΉ
	 * 20020926
	 */
	public String getAttribute(String name) {
	if ( name.equals("Connect0.Key" ) ) {
		return getConnectElement(0).getAttribute("Key");
	} else if ( name.equals("Connect1.Key" ) ) {
		return getConnectElement(1).getAttribute("Key");
	}
	return super.getAttribute(name);
	}

	//## ` #########################################################
	/**
	 * `Gg̎擾
	 *
	 * @param szPanelId plʎq
	 * @param isRoot    [g̗L(˂false)
	 */
	public Vector createGobs(String szPanelId) {
	Vector gobs = new Vector();

	// `IvṼ`FbN
	String szIntensity = getAttribute("Intensity");
	boolean bDisplay = true;
	ZResource res = ZApp.getTheApp().getResource();
	if ( szIntensity.equals("Virtual") ) {
		// Virtual
		bDisplay = res.getBoolean("view.Link.Virtual",true);
	} else {
		// Real
		bDisplay = res.getBoolean("view.Link.Real",false);
	}
	if ( !bDisplay ) {
		return gobs;
	}

/*
	*** 20020404 updateKeyAttribute() ōXV悤C ***

	// N̐`FbN
	// NReiAړA폜ĂꍇA
	// hLgǂݍݒŃNReiݒ肳ĂȂꍇ͂Ő
	// \̂߁A`IvṼ`FbNƏԕύX
	if ( ! ( checkLink(szPanelId,0) && checkLink(szPanelId,1) ) ) {
		removeFromDocTree();
		return gobs;
	}
*/

	// ʂɕ\ׂNۂ̃`FbN
	boolean bZone = true;
	boolean bSelect = res.getBoolean("view.Link.Select",false);
	GElement main0 = getConnectElement(0).getMainGob(szPanelId);
	GElement main1 = getConnectElement(1).getMainGob(szPanelId);
	if ( szPanelId.equals(Rid.PANEL_ZONE) ) {
		// ZoneFN̑oƂ`悳ĂȂ̂ŁA`悵Ȃ
		if ( main0 == null && main1 == null ) {
				bDisplay = false;
		} else if ( bSelect ) {
			if ( !( ( main0 != null && main0.isSelect() ) ||
			        ( main1 != null && main1.isSelect() ) ) ) {
				bDisplay = false;
			}
		}
	} else {
		// MapFN̂ꂩ`悳ĂȂ̂ŁA`悵Ȃ
		if ( main0 == null || main1 == null ) {
			bDisplay = false;

		// NƃNꍇ͓_Ȃ̂ŕ`悵Ȃ
		} else if ( main0 == main1 ) {
			bDisplay = false;
		
		} else if ( bSelect ) {
			if ( !( main0.isSelect() || main1.isSelect() ) ) {
				bDisplay = false;
			}
		}
		bZone = false;
	}
	if ( !bDisplay ) {
		return gobs;
	}

	// Gob̍쐬
	ZPoint pt0 = getConnectPoint(szPanelId,0) ;
	ZPoint pt1 = getConnectPoint(szPanelId,1) ;

	GLine line = new GLine();

	// FƑ̎擾
	Color col = getColorAttr("PaintColor");
	if ( col == null ) {
		if ( szIntensity.equals("Virtual") ) {
			col = res.getColor("unit.color.StrongLink");
		} else {
			col = res.getColor("unit.color."+getTagName());
		}
	}
	if ( szIntensity.equals("Virtual") ) {
		line.getStyle().getStroke().getWidth().set(2.0f);
	}
	if ( !getBooleanAttr("Exist", true ) ) {
		col = res.getColor("unit.color.NotExist");
	}
	line.getStyle().setStrokeColor( new FColor( col ) );
	
	// Ɩ
	line.setLine( new ZLine(pt0,pt1) );
	line.setArrow(GLine.ARROW_FORWARD);

	line.setContainer(this);
	if ( bZone ) {
		line.setSelect(isSelect());
		line.setGobId("zone");
	} else {
		line.setGobId("map");
		line.setSelectable( false );
	}

	// condition̕`
	String szCond = getAttribute("Condition");
	if ( szCond.length() > 0 ) {
		ZRectangle rttxt = new ZRectangle( (pt0.getX()+pt1.getX())/2,
										   (pt0.getY()+pt1.getY())/2,
											1000,getTitleHeight());
		GString str = new GString();
		str.setText( szCond );
		str.getStyle().setFillColor( new FColor( Color.black ));
		str.setFormat( GString.SINGLE|GString.LEFT|GString.TOP );
		str.setRect( rttxt );
		line.addForeChild(str);
	}

	gobs.add( line );
	
	return gobs;
	}

	/**
	 * `Gg̎擾
	 *
	 * [g̏ꍇ́AgwiƂĕ`悷
	 * @param szPanelId plʎq
	 * @param isRoot    [g̗L
	 */
	public Vector createSkeltonGobs(String szPanelId,boolean isRoot) {
	return new Vector();
	}

	//## N̍XV ###############################################
	/**
	 * N̍XV
	 * @param oldValue ̂̒linull̏ꍇunit폜ꂽj
	 * @param unit XVꂽjbg
	 */
	public void updateKeyAttribute( String oldValue, RidElement unit ) {
	String newValue = unit.getAttribute("Key");
	String checkTarget = oldValue;
	if ( checkTarget == null ) {
		checkTarget = newValue;
	}

	// N^[Qbg̎擾
	XElementNS elm0 = getChildElement("Connect0",null);
	String szKey0   = elm0.getAttribute("Key");
	XElementNS elm1 = getChildElement("Connect1",null);
	String szKey1   = elm1.getAttribute("Key");

	if ( oldValue == null ) {
		// 폜
		if ( szKey0.equals(checkTarget) || szKey1.equals(checkTarget) ) {
			removeFromDocTree();
		}
	} else {
		// O̕ύX
		if ( szKey0.equals(checkTarget) ) {
			elm0.setAttribute("Key",newValue);
			mConnectContainer[0] = unit;
		}
		if ( szKey1.equals(checkTarget) ) {
			elm1.setAttribute("Key",newValue);
			mConnectContainer[1] = unit;
		}
	}
	}

	//## IGobContainerFړ ##########################################
	/**
	 * vf̈ړ[h͂ȂɂH
	 * @param gob NGXgGob
	 * @param pt   _W
	 */
	public byte getPreMoveMode(GElement gob,ZPoint pt) {
	byte mode = super.getPreMoveMode(gob,pt);
	switch ( mode ) {
	  case GOperation.MOVE:		// ړ
		mode = GOperation.NONE;
		break;

	  case GOperation.NEW:		// VK쐬
	  case GOperation.POINT:	// _̈ړ
		// qbgGg΁AIvViڑ\}[Nj\
		String szPanelId = ZInstance.prop().getProperty( Rid.PANEL_ACTIVE );
		if ( findConnectContainer(szPanelId,pt,null) ) {
			getConnectElement(2).setHighlight(szPanelId,mConnectPosition);
		}
	}
	return mode;
	}

	/**
	 * ړ̊Jn
	 * @param gob  NGXgGob
	 * @param grid ObhRg[
	 */
	public void moveStart(GElement gob,DocGridControler grid) {
	switch ( grid.getMoveMode() ) {
//	  case GOperation.MOVE:		// ړ
//		// Ŝ̈ړ͂Ȃ
//		grid.setMoveMode( GOperation.NONE ) ;
//		break;

	  case GOperation.NEW:		// VK쐬
	  case GOperation.POINT:	// _̈ړ
		gob.moveStartGob( grid );
		DocPane editor = grid.getEditor();
		// VK쐬̏ꍇAJn_ݒ
		if ( grid.getMoveMode() == GOperation.NEW ) {
			if ( findConnectContainer(editor.getPanelId(),grid.getStartPoint(),null) ) {
				if ( mConnectPosition != GOperation.MOVE ) {
					getConnectElement(2).setHighlight(editor.getPanelId(),mConnectPosition);
					updateConnectContainer(editor.getPanelId(),0);
				} else {
					grid.setMoveMode( GOperation.NONE ) ;
				}
			} else {
				// JnʒũRei݂Ȃ̂ŕ`悵Ȃ
				grid.setMoveMode( GOperation.NONE ) ;
				return ;
			}
		}
		break;
	}
	}

	/**
	 * ړPath̎擾
	 * @param gob  NGXgGob
	 * @param grid ObhRg[
	 */
	public ZPath getMovingPath(GElement gob,DocGridControler grid) {
//	ZDebug.trace();
	DocPane editor = grid.getEditor();
	ZPoint ptMove = grid.getMovePoint();
	ZPoint ptStop = grid.getMovePoint();	// ݒ

	switch ( grid.getMoveMode() ) {
	  case GOperation.NEW:		// VK쐬
	  case GOperation.POINT:	// _̈ړ
		// ړȂ̍W擾
		int nStopIndex = 0 ;
		if ( grid.getMoveMode() == GOperation.POINT ) {
			nStopIndex = (((GLine)gob).getMovePoint()==0)?1:0 ;
		}
//		ZDebug.trace("StopPoint:"+nStopIndex);
		ptStop = getConnectPoint(editor.getPanelId(),nStopIndex);

		// ړ_ɐڑReiꍇ́AڑReiړ_擾
		if ( findConnectContainer(editor.getPanelId(),grid.getMovePoint(),getConnectElement(nStopIndex)) ) {
			getConnectElement(2).setHighlight(editor.getPanelId(),mConnectPosition);
			if ( mConnectPosition != GOperation.MOVE ) {
				ptMove = getConnectPoint(editor.getPanelId(),2);
			}
		}
		break;
	}

	return new ZPath( new ZLine( ptMove,ptStop ) );
	}

	/**
	 * ړ̊
	 * @param gob  NGXgGob
	 * @param grid ObhRg[
	 */
	public void moveEnd(GElement gob,DocGridControler grid) {
	DocPane editor = grid.getEditor();

	switch ( grid.getMoveMode() ) {
	  case GOperation.NEW:		// VK쐬
		if ( findConnectContainer(editor.getPanelId(),grid.getMovePoint(),getConnectElement(0)) ) {
			if ( mConnectPosition != GOperation.MOVE ) {
				updateConnectContainer(editor.getPanelId(),1);
				// ǉ
				setAttribute("Intensity","Virtual");
				setAttribute("Creator","Operator");
				setSelect(gob,true);
				DocDocument doc = editor.getDocument();
				setDocument( doc );
				DocElement link = (DocElement)((DocElement)doc.getDocumentElement()).getChildElement("Link",null);
				link.appendChild(this);
			}
		}
		break;

	  case GOperation.POINT:	// _̈ړ
		// ړȂ̍W擾
		int nStopIndex = (((GLine)gob).getMovePoint()==0)?1:0 ;
		if ( findConnectContainer(editor.getPanelId(),grid.getMovePoint(),getConnectElement(nStopIndex)) ) {
			if ( mConnectPosition != GOperation.MOVE ) {
				updateConnectContainer(editor.getPanelId(),((GLine)gob).getMovePoint());
			}
		}
		break;
	}

	}

	//## N ###################################################
	/**
	 * ڑłReiTBꍇAڑXg2Ԗ(ꎞ̈)ɕۑ
	 * @param szPanelId plʎq
	 * @param pt        W
	 * @param pair      ڑƂȂGg
	 */
	protected boolean findConnectContainer(String szPanelId, ZPoint pt,RidElement pair) {
	mConnectContainer[2] = null;
	mConnectPosition     = 0;
	Enumeration elm = GobManager.elements(szPanelId,GobManager.ALL);
	while ( elm.hasMoreElements() ) {
		GElement item = (GElement)elm.nextElement();
		byte pos = item.getConnectMode(pt, this);
		if ( pos != 0 ) {
			RidElement container = (RidElement)item.getContainer();
			if ( container != null && container != pair ) {
//				ZDebug.trace("find:"+pos);
				mConnectContainer[2] = container;
				mConnectPosition     = pos;
				return true;
			}
		}
	}
	return false;
	}

	/**
	 * oς̐ڑłReiDOMɔf
	 * @param szPanelId plʎq
	 * @param nIndex ڑʒu
	 */
	protected void updateConnectContainer(String szPanelId, int nIndex) {
	// IuWFNg̐ݒ
	// undoɃNAȂ̂ŁAnullɐݒ肷
	mConnectContainer[nIndex] = mConnectContainer[2] ;

	// DOM̐ݒ
	XElementNS elm = getChildElement("Connect"+nIndex,null);
	String szKey = mConnectContainer[2].getAttribute("Key");
	elm.setAttribute("Key",szKey);
	elm.setByteAttr("Position",mConnectPosition);

	mConnectContainer[2] = null;
	}

	/**
	 * N̎擾
	 * @param szPanelId plʎq
	 * @param nIndex ʒuL[
	 */
	protected ZPoint getConnectPoint(String szPanelId,int nIndex) {
	// ʒu̎擾
	byte connectPosition = mConnectPosition;
	if ( nIndex != 2 ) {
		XElementNS elm = findChildElement(".Connect"+nIndex,null);
		if ( nIndex == 0 ) {
			connectPosition = elm.getByteAttr("Position",GOperation.ZOOMSW);
		} else if ( nIndex == 1 ) {
			connectPosition = elm.getByteAttr("Position",GOperation.ZOOMNE);
		}
	}

	return getConnectElement(nIndex).getConnectPoint(szPanelId, connectPosition);
	}

	/**
	 * NΏۂ̎擾
	 * @param nIndex ʒuL[
	 */
	protected RidElement getConnectElement(int nIndex) {
	if ( nIndex != 2 && mConnectContainer[nIndex] == null ) {
		XElementNS elm = getChildElement("Connect"+nIndex,null);
		String szKey   = elm.getAttribute("Key");

		// |C^ZbgĂȂꍇ́ATop猟
		RidDocumentSite doc = (RidDocumentSite)getOwnerDocument();
		RidElementZone root= doc.getTopZone();
		mConnectContainer[nIndex] = (RidElement)root.findChildElement(".UrlUnit","Name="+szKey);
		if ( mConnectContainer[nIndex] == null ) {
			mConnectContainer[nIndex] = doc.findChildElementInZone("PageUnit",szKey);
		}
		if ( mConnectContainer[nIndex] == null ) {
			ZDebug.err("Connect element find failed:"+szKey);
		}
	}
	return mConnectContainer[nIndex];
	}

	//## N ###################################################
	/**
	 * NyA̎擾
	 * @param from ڑƂȂGg
	 */
	protected RidElement getLinkToElement(RidElement from) {
	RidElement linkTo = null;

	if ( getConnectElement(0) == from ) {
		linkTo = getConnectElement(1);
	}

	if ( linkTo != null && linkTo.getStatus().equals("remove") ) {
		ZDebug.trace("no link");
		linkTo = null;
	}

	return linkTo;
	}

	/**
	 * NyA̎擾
	 * @param to ڑƂȂGg
	 */
	protected RidElement getLinkFromElement(RidElement to) {
	RidElement linkFrom = null;

	if ( getConnectElement(1) == to ) {
		linkFrom = getConnectElement(0);
	}

	if ( linkFrom != null && linkFrom.getStatus().equals("remove") ) {
		ZDebug.trace("no link");
		linkFrom = null;
	}

	return linkFrom;
	}

	//## Agr[g################################################
	/**
	 * ڑGg
	 * ڑ̂͂Q_A3ڂ̗̈ҏWpꎞ̈Ƃėp
	 */
	protected RidElement[] mConnectContainer = new RidElement[3] ;

	/**
	 * ҏWpꎞ̈(3)̐ڑʒu
	 */
	protected byte mConnectPosition = 0 ;
}
