/*
 * @(#)AccessCounts.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : Array of access count
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/10/29
 */
package jp.co.nri.rid.doc;

import java.util.Enumeration;
import java.util.Vector;

import jp.co.iti.fagot.geom.ZRectangle;

import jp.co.iti.fagot.util.ZString;
import jp.co.iti.fagot.util.ZDebug;
/**
 * ANZXJEg̔z
 */
public class AccessCounts {

	/**
	 * RXgN^
	 */
    public AccessCounts() {
    }

	/**
	 * RXgN^(lt)
	 * @param szCount AccessCountAgr[g
	 */
    public AccessCounts(String szCount) {
	setArray( szCount, null );
    }

	/**
	 * RXgN^(lt)
	 * @param szCount AccessCountAgr[g
	 * @param bLogList Lf[^z
	 */
    public AccessCounts(String szCount, boolean[] bLogList) {
	setArray( szCount, bLogList );
    }

	/**
	 * z̐ݒ
	 * @param szCount AccessCountAgr[g
	 * @param bLogList Lf[^z
	 */
	public void setArray( String szCount, boolean[] bLogList ) {
	mLogList = bLogList;
	mTotal = 0;
	String[] szArr = ZString.tokenize(szCount,",");
	mArray = new double[szArr.length] ;
	for ( int nAt=0 ; nAt<szArr.length ; nAt++ ) {
		double nTmp = ZString.parseDouble( szArr[nAt], 0 ) ;
		if ( bLogList == null ) {
			mTotal += nTmp ;
		} else if ( bLogList.length <= nAt ) {
			mTotal += nTmp ;
		} else if ( bLogList[nAt] ) {
			mTotal += nTmp ;
		}
		mArray[nAt] = nTmp ;
	}
	}

	/**
	 * ől̃}[W
	 */
	public void margeMax( AccessCounts dst ) {
	int nSrcArrayCount = getArrayCount();
	int nDstArrayCount = dst.getArrayCount();
	int nAt = 0 ;
	// dst̕z񂪑ꍇ
	if ( nSrcArrayCount < nDstArrayCount ) {
		// ̔zgTCY̔zɊi[
		double[] nArray = new double[nDstArrayCount] ;
		for ( ; nAt<nSrcArrayCount ; nAt++ ) {
			nArray[nAt] = mArray[nAt] ;
		}
		for ( ; nAt<nDstArrayCount ; nAt++ ) {
			nArray[nAt] = 0 ;
		}
		mArray = nArray;
	}

	// dst̃}[W
	for ( nAt=0 ; nAt<nDstArrayCount ; nAt++ ) {
		double nCnt = dst.getArrayData(nAt);
		if ( mArray[nAt] < nCnt ) {
			mArray[nAt] = nCnt ;
		}
	}

	// vl̃}[W
	double nTotal = dst.getTotalCount();
	if ( mTotal < nTotal ) {
		mTotal = nTotal ;
	}
	}

	/**
	 * Ot̍쐬
	 * MapModelɓo^Ăf[^IuWFNĝ݌Ă΂郁\bh
	 * @param rt  ``
	 * @param acc Ώۃf[^
	 */
	public ZRectangle[] createAccessRects( ZRectangle rt, AccessCounts dst ) {
//	ZDebug.trace("rtBase:"+rt);
	// Otf[^̒o
	Vector vec = new Vector();
	int nAt    = 0;
	double nTotal = 0;
	double nCount = 0;
	int nDataCount = 0;
	int nDstCount = dst.getArrayCount();
	if ( mLogList != null ) {
		// \Lݒ肳Ăꍇ́Aݒ肳ĂƂ܂Ŏwɂ
		for ( ; nAt < mLogList.length ; nAt++ ) {
			if ( mLogList[nAt] ) {
				if ( nAt < nDstCount ) {
					nCount = dst.getArrayData(nAt);
					vec.add( new Double(nCount) );
					if ( nCount > 0 ) {
						nTotal += nCount;
						nDataCount++;
					}
				} else {
					vec.add( new Double(0) );
				}
			}
		}
	}
	// \Lݒ肳ĂȂꍇ́ASĕ\
	for ( ; nAt < nDstCount ; nAt++ ) {
		nCount = dst.getArrayData(nAt);
		vec.add( new Double(nCount) );
		if ( nCount > 0 ) {
			nTotal += nCount;
			nDataCount++;
		}
	}
	// f[^ȂÃy[WɃf[^ꍇOǉ
	for ( ; nAt < getArrayCount() ; nAt++ ) {
		vec.add( new Double(0) );
	}

	ZRectangle[] rtList = null;
	if ( mLogType.equals("join") ) {
		// r[̏ꍇ͋`P
		if ( nTotal != 0 ) {
			double dHeight = rt.getHeight()*nTotal/mMax ;
			rtList = new ZRectangle[1] ;
			rtList[0] = new ZRectangle( rt.getX(), rt.getY()+rt.getHeight()-dHeight,
										rt.getWidth(), dHeight);
		}
	} else if ( nDataCount > 0 ) {
		rtList = new ZRectangle[nDataCount] ;
		Enumeration elm = vec.elements();
		nAt = 0;
		double dX = rt.getX();
		double dY = rt.getY();
		double dW = rt.getWidth();
		double dH = rt.getHeight();
		// ςݏグ̏ꍇ̃f[^
		double dB = 0;
		// ̏ꍇ̃f[^
		int nCnt  = 0;
		int nSize = vec.size();
		while ( elm.hasMoreElements() ) {
			Double val = (Double)elm.nextElement();
			double nVal = val.doubleValue();
			if ( nVal > 0 ) {
				double dHeight = dH*nVal/mMax ;
				if ( !mLogType.equals("parallel") ) {
					// ςݏグ̏ꍇ
					rtList[nAt] = new ZRectangle( dX, dY+dH-dB-dHeight, dW, dHeight);
//					ZDebug.trace("rt:"+rtList[nAt]);
					dB += dHeight;
				} else {
					// ̏ꍇ
					rtList[nAt] = new ZRectangle( dX+(dW/nSize)*nCnt, dY+dH-dHeight, dW/nSize, dHeight);
				}
				nAt++;
			}
			nCnt++;
		}
	}

	return rtList;
	}

	//## l ###########################################################
	/**
	 * őľvZ
	 */
	public void calcMaxCount() {
	if ( !mLogType.equals("parallel") ) {
		mMax = mTotal ;
	} else {
		mMax = 0;
		for ( int nAt=0 ; nAt < mArray.length ; nAt++ ) {
			if ( mLogList==null || mLogList.length<=nAt || mLogList[nAt] ) {
				if ( mMax == 0 ) {
					mMax = mArray[nAt] ;
				} else if ( mMax < mArray[nAt] ) {
					mMax = mArray[nAt] ;
				}
			}
		}
	}
	if ( mMax == 0 ) {
		mMax = 1000;
	}
	}

	//## l ###########################################################
	/**
	 * vl̎擾
	 */
	public double getTotalCount() {
	return mTotal;
	}

	/**
	 * z񒷂̎擾
	 */
	public int getArrayCount() {
	if ( mArray == null ) {
		return 0;
	}
	return mArray.length;
	}

	/**
	 * zf[^̎擾
	 * @param nAt zY
	 */
	public double getArrayData( int nAt ) {
	if ( mArray == null || mArray.length <= nAt ) {
		return 0;
	}
	return mArray[nAt];
	}

	/**
	 * O^Cv̐ݒ
	 * @param szLogType O^Cv { "serial" | "parallel" | "join" }
	 */
	public void setLogType( String szLogType ) {
	mLogType = szLogType ;
	}

	//## Agr[g ###############################################
	/**
	 * g[^
	 */
	protected double mTotal = 0;

	/**
	 * ől
	 */
	protected double mMax = 1000;

	/**
	 * ANZXJEg̔z
	 */
	protected double[] mArray = null;

	/**
	 * ANZXJEg\Lz
	 */
	protected boolean[] mLogList = null;

	/**
	 * ANZXÕ^Cv
	 */
	protected String mLogType = "";
}
