/*
 * @(#)RidGobAction.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : rid gob action
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/05/08
 */
package jp.co.nri.rid.action;

import java.awt.event.ActionEvent;

import java.io.File;
import	java.io.InputStream;
import	java.io.*;

import java.util.Enumeration;
import java.util.Vector;

import javax.swing.JComponent;
import javax.swing.JFileChooser;

import org.w3c.dom.Node;

import jp.co.iti.fagot.IZApp;
import jp.co.iti.fagot.action.ZAction;

import jp.co.iti.fagot.fob.xml.XElementNS;

import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.GobManager;

import jp.co.iti.fagot.xml.GRootSVG;

import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocDocument;

import jp.co.iti.fagot.util.ZFileFilter;
import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZReverseEnumeration;
import jp.co.iti.fagot.util.ZDebug;

import jp.co.nri.Rid;

import jp.co.nri.rid.doc.RidElement;
import jp.co.nri.rid.doc.RidElementZone;
import jp.co.nri.rid.doc.RidElementPage;

import jp.co.nri.rid.export.ExportSvgDialog;

import jp.co.nri.rid.generator.GenerateCSV;

import jp.co.nri.rid.xml.*;
import jp.co.nri.rid.RidMIT;


/**
 * Rid GobnANV`
 */
public class RidGobAction extends ZAction {
	/**
	 * B̃RXgN^łB
	 * @param app AvP[V
	 * @param szAction ANV
	 */
	public RidGobAction(IZApp app,String szAction) {
    super(app,szAction);
	}

	/**
	 * ANVs
	 */
	public void doAction(ActionEvent e) {
	ZResource res = getApp().getResource();

	// Grid́Aǂ̃plł\
	if ( getActionName().equals( GRID ) ) {
		boolean isGrid = res.getBoolean( "edit.grid", true );
		res.putBoolean("edit.grid",!isGrid);
	}

	String szTitle = ZInstance.prop().getProperty( Rid.PANEL_ACTIVE );
	JComponent active = (JComponent)ZInstance.map().get(szTitle);
	if ( !(active instanceof DocPane) ) {
		// ANeBupl`plłȂꍇ͂Ƃ肠삵Ȃ
		return;
	}
	DocPane editor = (DocPane)active;
	editor.getDocument().beginTransaction();

	// 
	if ( getActionName().equals( UP ) ) {
		Vector gobs = GobManager.getSelectedElement(szTitle);
		Enumeration elm = new ZReverseEnumeration(gobs);
		while ( elm.hasMoreElements() ) {
			GElement   gob = (GElement)elm.nextElement();
			DocElement dob = (DocElement)gob.getContainer();
			Node parent  = dob.getParentNode();
			Node ref     = dob.getNextSibling();
			// Gg邩H
			while ( ref != null && !(ref instanceof RidElement) ) {
				ref = ref.getNextSibling();
			}
			// Gg΁Ǎɒǉ
			if ( ref != null ) {
				ref = ref.getNextSibling();
				// Ue폜
				parent.removeChild(dob);
				parent.insertBefore(dob,ref);
			}
		}

		editor.updateGobs();
		editor.repaint();

	// 
	} else if ( getActionName().equals( DOWN ) ) {
		Vector gobs = GobManager.getSelectedElement(szTitle);
		Enumeration elm = gobs.elements();
		while ( elm.hasMoreElements() ) {
			GElement   gob = (GElement)elm.nextElement();
			DocElement dob = (DocElement)gob.getContainer();
			Node parent  = dob.getParentNode();
			Node ref     = dob.getPreviousSibling();
			// ZGg邩H
			while ( ref != null && !(ref instanceof RidElement) ) {
				ref = ref.getPreviousSibling();
			}
			// ZGg΁AZ̑Oɒǉ
			if ( ref != null ) {
				// Ue폜
				parent.removeChild(dob);
				parent.insertBefore(dob,ref);
			}
		}

		editor.updateGobs();
		editor.repaint();

	// ZoneplɂZoneUnit̃VN
	} else if ( getActionName().equals( OMISSION_ZONE_ZONE ) ) {
		Vector gobs = GobManager.getSelectedElement(editor.getPanelId());
		Enumeration elm = gobs.elements();
		while ( elm.hasMoreElements() ) {
			GElement   gob = (GElement)elm.nextElement();
			DocElement dob = (DocElement)gob.getContainer();
			if ( dob instanceof RidElementZone ) {
				XElementNS vwi = dob.getChildElement(".ViewInfo."+editor.getPanelId(),null);
				boolean bOmission = vwi.getBooleanAttr("Omission",false);
				vwi.setBooleanAttr("Omission",!bOmission);
			}
		}
		editor.updateGobs();
		editor.repaint();

	// MapplɂPageUnit̃VN
	} else if ( getActionName().equals( OMISSION_MAP_PAGE ) ) {
		Vector gobs = GobManager.getSelectedElement(editor.getPanelId());
		Enumeration elm = gobs.elements();
		while ( elm.hasMoreElements() ) {
			GElement   gob = (GElement)elm.nextElement();
			DocElement dob = (DocElement)gob.getContainer();
			if ( dob instanceof RidElementPage ) {
				XElementNS vwi = dob.getChildElement(".ViewInfo."+editor.getPanelId(),null);
				boolean bOmission = vwi.getBooleanAttr("Omission",false);
				vwi.setBooleanAttr("Omission",!bOmission);
			}
		}
		editor.updateGobs();
		editor.repaint();

	// SVGo
	} else if ( getActionName().equals( SVG ) ) {

		String szFile = openFileDialog("svg","SVG File","rid.svg.dir");
		if ( szFile != null ) {
			// wb_
			elementBooster header = null;
			switch(RidMIT.checkMIT()){
			case -3:	// NO	肦Ȃꉞ
			case -1:	// CZXُ
			case -2:	// trial
				try{
					InputStream in = getClass().getResourceAsStream("/jp/co/nri/resources/header.svg");
					documentBooster doc = new documentBooster(in);
					header = doc.root();
				}catch(Throwable t){}
				
				break;
			case 0:		// 
			default:
				File in = new File(ZInstance.prop().getProperty( Rid.PJ_DIR ) ,getApp().getResource().getString("rid.header.svg"));
				try{
					documentBooster doc = new documentBooster(new FileInputStream(in));
					header = doc.root();
				}catch(Throwable t) {
					ZDebug.err("Parse SVG failed:");
					t.printStackTrace();
				}

			}
			
			// Gob̎W
			Vector gobs = GobManager.list(editor.getPanelId(),GobManager.ALL);
			try {
				GRootSVG svg = new GRootSVG(gobs);
				if(null != header)	svg.setLogo(header.element());
				svg.writeto(szFile ,null);
			} catch ( Exception evt ) {
				ZDebug.err("Write svg failed:");
				evt.printStackTrace();
			}

			// o̓fBNg̊mF
			String szDocsDir = null;
			String szPjDir = ZInstance.prop().getProperty(Rid.PJ_DIR);
			if ( szPjDir != null ) {
				szDocsDir = szPjDir + File.separator + res.getString("rid.docs.dir");
				String szCompare = szFile.substring(0,Math.min(szFile.length(),szDocsDir.length()));
				if ( szCompare.equalsIgnoreCase(szDocsDir) ) {
                    // RǵuEU\LI_CAO
                    ExportSvgDialog svgd = new ExportSvgDialog();
                    svgd.show(szFile, true);

                } else {
                    ExportSvgDialog svgd = new ExportSvgDialog();
                    svgd.show(szFile, false);
				}
			}

		}
	}
	
	// R~bgĂ̂Œǉ 20020703
	editor.getDocument().commit();
	}

	/**
	 * UIXV
	 */
	public void update() {
	ZResource res = getApp().getResource();

	boolean bState = false;
	String szTitle = ZInstance.prop().getProperty( Rid.PANEL_ACTIVE );
	JComponent active = (JComponent)ZInstance.map().get(szTitle);
	if ( !(active instanceof DocPane) ) {
		// ANeBupl`plłȂꍇ͓삵Ȃ
		firePropertyChange(ZAction.ENABLED,null,new Boolean(bState));
		return;
	}
	DocPane editor = (DocPane)active;

	// ][pl̑IĂGOB擾
	if ( getActionName().equals( UP ) ) {
		Vector gobs = GobManager.getSelectedElement(szTitle);
		Enumeration elm = new ZReverseEnumeration(gobs);
		while ( elm.hasMoreElements() ) {
			GElement   gob = (GElement)elm.nextElement();
			DocElement dob = (DocElement)gob.getContainer();
			Node parent  = dob.getParentNode();
			Node ref     = dob.getNextSibling();
			// Gg邩H
			while ( ref != null && !(ref instanceof RidElement) ) {
				ref = ref.getNextSibling();
			}
			// Gg΁Ǎɒǉ
			if ( ref != null ) {
				bState = true;
				break;
			}
		}

	// ][pl̑IĂGOB擾
	} else if ( getActionName().equals( DOWN ) ) {
		Vector gobs = GobManager.getSelectedElement(szTitle);
		Enumeration elm = gobs.elements();
		while ( elm.hasMoreElements() ) {
			GElement   gob = (GElement)elm.nextElement();
			DocElement dob = (DocElement)gob.getContainer();
			Node parent  = dob.getParentNode();
			Node ref     = dob.getPreviousSibling();
			// ZGg邩H
			while ( ref != null && !(ref instanceof RidElement) ) {
				ref = ref.getPreviousSibling();
			}
			// ZGg΁AZ̑Oɒǉ
			if ( ref != null ) {
				bState = true;
				break;
			}
		}

	// Grid
	} else if ( getActionName().equals( GRID ) ) {
		boolean isGrid = res.getBoolean( "edit.grid", true );
		firePropertyChange(ZAction.CHECKED,null,new Boolean(isGrid));
		bState = true;

	// ZoneplɂZoneUnit̃VN
	} else if ( getActionName().equals( OMISSION_ZONE_ZONE ) ) {
		Vector gobs = GobManager.getSelectedElement(editor.getPanelId());
		if ( gobs.size() == 1 ) {
			GElement   gob = (GElement)gobs.firstElement();
			DocElement dob = (DocElement)gob.getContainer();
			if ( dob instanceof RidElementZone ) {
				XElementNS vwi = dob.getChildElement(".ViewInfo."+editor.getPanelId(),null);
				boolean bOmission = vwi.getBooleanAttr("Omission",false);
				firePropertyChange(ZAction.CHECKED,null,new Boolean(bOmission));
				bState = true;
			}
		}

	// MapplɂPageUnit̃VN
	} else if ( getActionName().equals( OMISSION_MAP_PAGE ) ) {
		Vector gobs = GobManager.getSelectedElement(editor.getPanelId());
		if ( gobs.size() == 1 ) {
			GElement   gob = (GElement)gobs.firstElement();
			DocElement dob = (DocElement)gob.getContainer();
			if ( dob instanceof RidElementPage ) {
				XElementNS vwi = dob.getChildElement(".ViewInfo."+editor.getPanelId(),null);
				boolean bOmission = vwi.getBooleanAttr("Omission",false);
				firePropertyChange(ZAction.CHECKED,null,new Boolean(bOmission));
				bState = true;
			}
		} else {
			ZDebug.trace("gob:"+gobs.size());
		}

	// SVGo
	} else if ( getActionName().equals( SVG ) ) {
		// Gob̎W
		Vector gobs = GobManager.list(editor.getPanelId(),GobManager.ALL);
		if ( gobs.size()>0 ) {
			bState = true;
		}
	}

	firePropertyChange(ZAction.ENABLED,null,new Boolean(bState));
	}

	//## _CAO ###################################################
	/**
	 * t@CI_CAO
	 * @param szExt
	 * @param szExtName
	 * @param szOutDir
	 */
	public String openFileDialog(String szExt, String szExtName, String szOutDir) {
	ZResource res = getApp().getResource();
	JFileChooser dlg = new JFileChooser();
	// t@CtB^̐ݒ
	dlg.setFileFilter(new ZFileFilter( new String(szExt), szExtName));

	// JgfBNg̐ݒ
	String szPjDir = ZInstance.prop().getProperty(Rid.PJ_DIR);
	String szDir = res.getString("app.install.path");
	if ( szPjDir != null ) {
		szDir = szPjDir + File.separator + res.getString(szOutDir);
	}
	dlg.setCurrentDirectory(new File(szDir)) ;

	// _CAOJ
	int nRet = dlg.showSaveDialog(getApp().getFrame());
	String szFile = null ;
	if ( nRet == JFileChooser.APPROVE_OPTION) {
		// t@C擾
		File fFile = dlg.getSelectedFile();
		try {
			szFile = fFile.getCanonicalPath();
	    } catch ( java.io.IOException evt) {
			szFile = fFile.getAbsolutePath();
		}

		if( szFile != null ){
			if ( !szFile.endsWith("."+szExt) ) {
				szFile += "."+szExt;
			}
		}
	}

	// t@C̍XV
	// ͍XVȂAdlg.setCurrentDirectorysăfBNg
	// ύXɂȂƃj[\ŃG[ł邽߁AŃt@CXV
	getApp().updateRecent( null );

	return szFile;
	}



	//## Agr[g ###############################################
    /**
     * ANV(ҏW)F
     */
	static final public String UP		= "move_up" ;

    /**
     * ANV(ҏW)F
     */
	static final public String DOWN		= "move_down" ;

    /**
     * ANV(ҏW)FObh
     */
	static final public String GRID		= "grid" ;

    /**
     * \̒F][pl̏ȗ
     */
	static final public String OMISSION_ZONE_ZONE  = "omission_zone_zone" ;

    /**
     * \̒F}bvpl̏ȗ
     */
	static final public String OMISSION_MAP_PAGE   = "omission_map_page" ;

    /**
     * ANV(o)
     */
	static final public String SVG		= "svg" ;
}
