/**
 * @(#)RidualLog.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-3 : sO
  *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/08/01
 */
package jp.co.nri;

import java.io.File;
import java.io.FileOutputStream;

import java.util.Enumeration;
import java.util.Vector;

import org.xml.sax.InputSource;

import org.apache.xerces.parsers.DOMParser;

import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.DOMSerializer;
import org.apache.xml.serialize.XMLSerializer;

import jp.co.iti.fagot.ZApp;

import jp.co.iti.fagot.doc.DocDocument;
import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocManager;

import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZString;
import jp.co.iti.fagot.util.ZDebug;

/**
 * Ridual sO
 * T[oŃob`NɁoNԁbIXe[^XpȂǂۑA
 * ob`N̎sL^cƂƂɁAob`N̔rs߂̃NX
 * ̃NX́ARidualScript̂݌Ă΂
 */
public class RidualLog {

	/**
	 * RXgN^
	 * @param szLog Ot@C
	 * @param szTrc g[Xt@C
	 * @param szTim Jn
	 */
	public RidualLog(String szLog, String szTrc, String szTim) {
	mLog = szLog;
	mTrc = szTrc;
	mTim = szTim;
	}

	//## JnEI ###################################################
	/**
	 * Jn
	 * @param szPrj vWFNg
	 * @return {|ُ}
	 */
	public boolean start( String szPrj ) {
	mPrj = szPrj;
	boolean bRet = false;
	DocDocument doc = loadDocument();
	ZResource res = ZApp.getTheApp().getResource();
	boolean bForce = res.getBoolean("rid.start.force",false);
	if ( doc != null ) {
		bRet = true;
		DocElement root = (DocElement)doc.getDocumentElement();
		Vector vec = root.findChildElements(".Log");
		Enumeration elm = vec.elements();
		while ( elm.hasMoreElements() ) {
			DocElement log = (DocElement)elm.nextElement();
			if ( log.getAttribute("Project").equals( mPrj ) &&
				 log.getAttribute("Status").equals("running") ) {
				if ( bForce ) {
					log.setAttribute("Status","stopped");
				} else {
					// 2dNG[
					ZDebug.trace("duplicate start");
					bRet = false;
				}
			}
		}
		DocElement cur = (DocElement)doc.createElement("Log");
		cur.setAttribute("Project", mPrj );
		cur.setAttribute("Trace"  , mTrc );
		cur.setAttribute("Start"  , mTim );
		cur.setAttribute("Status" , (bRet)?"running":"interrupt" );
		root.appendChild( cur );

		if ( saveDocument( doc ) == null ) {
			bRet = false;
		}
	}
	return bRet;
	}

	/**
	 * sԃ`FbN
	 * @param bRet {|ُ}
	 */
	public boolean check() {
	DocDocument doc = loadDocument();
	if ( doc != null ) {
		DocElement root = (DocElement)doc.getDocumentElement();
		Vector vec = root.findChildElements(".Log");
		Enumeration elm = vec.elements();
		while ( elm.hasMoreElements() ) {
			DocElement log = (DocElement)elm.nextElement();
			if ( log.getAttribute("Project").equals( mPrj ) &&
				 log.getAttribute("Trace").equals( mTrc )   &&
				 log.getAttribute("Start").equals( mTim )   &&
				 log.getAttribute("Status").equals("running") ) {
				return true;
			}
		}
	}
	return false;
	}

	/**
	 * I
	 * @param bRet {|ُ}
	 */
	public void end( boolean bRet ) {
	DocDocument doc = loadDocument();
	if ( doc != null ) {
		DocElement root = (DocElement)doc.getDocumentElement();
		Vector vec = root.findChildElements(".Log");
		Enumeration elm = vec.elements();
		while ( elm.hasMoreElements() ) {
			DocElement log = (DocElement)elm.nextElement();
			if ( log.getAttribute("Project").equals( mPrj ) &&
				 log.getAttribute("Trace").equals( mTrc )   &&
				 log.getAttribute("Start").equals( mTim )   &&
				 log.getAttribute("Status").equals("running") ) {
				// I̐ݒ
				log.setAttribute("End",ZString.getDateTime());
				log.setAttribute("Status",(bRet)?"done":"error");
				break;
			}
		}
		saveDocument( doc );
	}
	}

	//## DOM ##########################################################
	/**
	 * hLg̃[h
	 * @return hLg
	 */
	protected DocDocument loadDocument() {
	File fFile = new File(mLog);
	DocDocument doc = null;
	if ( fFile.isFile() ) {
		try {
			// p[X
			DOMParser parser = new DOMParser();
			parser.setProperty("http://apache.org/xml/properties/dom/document-class-name","jp.co.nri.rid.doc.RidDocument");
			parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd",false);
			InputSource in = DocManager.createInputSource(mLog);
			parser.parse(in);
			ZDebug.trace("open:"+mLog);
			doc = (DocDocument)parser.getDocument();
		} catch ( Throwable t ) {
			ZDebug.err("FileOpen failed:"+mLog);
			ZDebug.err("    "+t.toString());
		}
	}
	return doc;
	}

	/**
	 * hLg̃Z[u
	 */
	protected DocDocument saveDocument(DocDocument doc) {
	try {
		String  szEncoding = doc.getEncoding();
		boolean bIndenting = doc.getIndenting();
		// o
		ZDebug.trace("save:"+mLog);
		OutputFormat fm = new OutputFormat(doc,szEncoding,bIndenting);
		FileOutputStream out = new FileOutputStream(mLog);
		DOMSerializer ser = new XMLSerializer(out,fm).asDOMSerializer();
		ser.serialize(doc);
		return doc;
	} catch ( Throwable t ) {
		ZDebug.err("FileSave failed:"+mLog);
		ZDebug.err("    "+t.toString());
	}
	return null;
	}

	//## Agr[g ###############################################
	/**
	 * vWFNg
	 */
	protected String mPrj = null;

	/**
	 * Ot@C
	 */
	protected String mLog = null;

	/**
	 * g[Xt@C
	 */
	protected String mTrc = null;

	/**
	 * Jn
	 */
	protected String mTim = null;
}
