/**
 * @(#)RWindowManager.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : ChildWindowManager
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2001/05/08
 */
package jp.co.nri.rid;

import java.awt.Window;

import java.util.Vector;
import java.util.Enumeration;

import javax.swing.JComponent;

import org.w3c.dom.Element;

import jp.co.iti.fagot.IZApp;

import jp.co.iti.fagot.action.ZChildWindowAction;

import jp.co.iti.fagot.ui.UWindowManager;
import jp.co.iti.fagot.ui.UDialog;
import jp.co.iti.fagot.ui.UFrameChild;

import jp.co.iti.fagot.gob.GElement;
import jp.co.iti.fagot.gob.GobManager;

import jp.co.iti.fagot.doc.DocElement;
import jp.co.iti.fagot.doc.DocPane;
import jp.co.iti.fagot.doc.DocManager;

import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZResource;
import jp.co.iti.fagot.util.ZDebug;

import jp.co.nri.Rid;

import jp.co.nri.rid.RPanPanel;

import jp.co.nri.rid.doc.RidDocumentSite;

import jp.co.nri.rid.xml.PaneledElementFactory;

//import jp.co.nri.rid.action.RViewAction;

/**
 * ChildWindow Manager
 */
public class RWindowManager extends UWindowManager {

	/**
	 * RXgN^
	 * @param app AvP[V
	 */
	public RWindowManager(IZApp app) {
	super(app,WINDOW_COUNT);
	}

	//## I[oCh #################################################
	/**
	 * qEBhE̍쐬
	 * @param nIndex EBhEԍ
	 */
	public Window createWindow( int nIndex ) {
	Window win = null;
	switch ( nIndex ) {

	  case PROPERTY: // vpeB_CAO
		UDialog ppdialog = new UDialog(mApp,"property");
		updatePropertyDialog(ppdialog);
		win = ppdialog;
		break;

	  case PANPANEL: // L}
		UDialog pDialog = new UDialog(mApp,"panpanel");
		RPanPanel panpanel = new RPanPanel();
//		panpanel.setContainer( mPanel );
		pDialog.setComponent(panpanel,true);
		win = pDialog;
		break;
	}
	return win;
	}

	/**
	 * EBhE̍XV
	 * @param nIndex EBhEԍ
	 */
	public void updateWindow( int nIndex ) {
	// hLgݒ肳ĂȂꍇAWindownullłȂꍇɃEBhEXV
	//
	// \Jnɂ isVisibletrueł͂Ȃ̂ŁAisVisible͎gȂ
//	if ( mDoc == null || !isVisible(nIndex) ) {
	// EBhE\ĂȂꍇ͎sȂ
	Window win = getWindow(nIndex);
	if ( win == null ) {
		return ;
	}

	switch ( nIndex ) {
	  case PROPERTY: // vpeB_CAO
		UDialog ppdialog = (UDialog)win;
		updatePropertyDialog(ppdialog);
		break;

	  case PANPANEL: // L}
		RPanPanel panpanel = (RPanPanel)((UDialog)win).getComponent();
		panpanel.restract();
//		panpanel.setDocument( mDoc );
		break;
	}
	}

	/**
	 * qEBhE̕\
	 * @param nIndex t[ԍ
	 * @param bShow \L
	 */
	public void setVisible( int nIndex, boolean bShow ) {
	super.setVisible(nIndex,bShow);

	ZChildWindowAction action = (ZChildWindowAction)getApp().getAction(ZChildWindowAction.PREFIX+nIndex);
	if ( action != null ) {
		action.update();
	}
	}

	//## ʏ #####################################################
	/**
	 * vpeBEBhE̍XV
	 * @param dialog vpeB_CAO
	 */
	protected void updatePropertyDialog( UDialog dialog ) {
	// ANeBupl̎擾
	String szTitle = ZInstance.prop().getProperty( Rid.PANEL_ACTIVE );
	JComponent active = (JComponent)ZInstance.map().get(szTitle);
	if ( !(active instanceof DocPane) ) {
		// ANeBupl`plłȂꍇ͂Ƃ肠`悵Ȃ
		dialog.getContentPane().removeAll();
		dialog.validate();
		dialog.repaint();
		return;
	}

	// ANeBupl̑IĂGOB擾
	DocPane panel = (DocPane)active;
	DocElement target = null;
	Vector gobs = GobManager.getSelectedElement(panel.getPanelId());
	if ( gobs.size() != 1 ) {
		target = (DocElement)((RidDocumentSite)panel.getDocument()).getRootElement(panel.getPanelId());
	} else {
		GElement item = (GElement)gobs.firstElement();
		target = (DocElement)item.getContainer();
	}

	if ( target == null ) {
		// ^[Qbg݂Ȃꍇ͕`悵Ȃ
		dialog.getContentPane().removeAll();
		dialog.validate();
		dialog.repaint();
		return;
	}

	// vpeBpl̓\t
	dialog.getContentPane().removeAll();
	PaneledElementFactory pef = new PaneledElementFactory();
	Element layout = DocManager.createElementLayout(target.getTagName());
	dialog.setComponent( pef.PaneledElement(target,layout), true );
	dialog.validate();
	}

	//## Agr[g ###############################################
	/**
	 * EBhE`FvpeBEBhE
	 */
	final static public int PROPERTY	= 0 ;

	/**
	 * EBhE`FL}
	 */
	final static public int PANPANEL	= 1 ;

	/**
	 * EBhE`FqEBhE̐
	 */
	final static public int WINDOW_COUNT	= 2 ;

}
