/**
 * @(#)Menu.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * RID-X : Right button menu
 *
 * @author  Intelligent Technology Inc.
 * @version 1.01 2002/08/09
 */
package jp.co.nri.rid;

import java.awt.Point;
import java.awt.Dimension;
import java.awt.Window;

import java.awt.event.MouseEvent;

import java.util.Enumeration;
import java.util.Vector;

import javax.swing.JComponent;
import javax.swing.JPopupMenu;

import jp.co.iti.fagot.ZApp;

import jp.co.iti.fagot.action.ZAction;

import jp.co.iti.fagot.ui.UIFactory;

import jp.co.iti.fagot.doc.DocManager;
import jp.co.iti.fagot.doc.DocElement;

import jp.co.iti.fagot.util.ZInstance;
import jp.co.iti.fagot.util.ZUIUtil;
import jp.co.iti.fagot.util.ZDebug;
/**
 * E{^j[
 */
public class RMenu {

	/**
	 * E{^j[̍쐬
	 * @param evt     }EXCxg
	 * @param target  IĂGg
	 */
	static public void createContextMenu( MouseEvent evt, DocElement target ) {
	Vector targets = new Vector();
	targets.add( target );
	createContextMenu( evt, targets ) ;
	}

	/**
	 * E{^j[̍쐬
	 * @param evt     }EXCxg
	 * @param targets IĂGgQ
	 */
	static public void createContextMenu( MouseEvent evt, Vector targets ) {
	String     szPanelId = "List";
	JComponent invoker   = (JComponent)evt.getSource();

	UIFactory ui = DocManager.createUIFactory(DocManager.ELEMENT);
	Vector keys = new Vector();
	Enumeration elm = targets.elements();
	while ( elm.hasMoreElements() ) {
		DocElement target = (DocElement)elm.nextElement();
		keys.add( target.getContextKey(szPanelId) );
	}
	JPopupMenu popup = ui.createContextMenu(invoker,keys);
	ZInstance.map().put("doc.rmenu.target", targets );

	// \ʒǔvZ
	Dimension scrDim = popup.getToolkit().getScreenSize();
	Dimension popDim = popup.getPreferredSize();
	Window win = ZUIUtil.getParentWindow(invoker);
	Point  ptEditor = invoker.getLocationOnScreen();
	Point  ptWin = win.getLocationOnScreen();

	// EBhËʒuɏC
	int nX = (int)(evt.getX()+ptEditor.getX()-ptWin.getX());
	int nY = (int)(evt.getY()+ptEditor.getY()-ptWin.getY());
	// ʒu̕␳
	if ( nX+ptWin.getX()+popDim.getWidth() > (scrDim.getWidth()-40) ) {
		nX -= popDim.getWidth();
	}
	if ( nY+ptWin.getY()+popDim.getHeight() > (scrDim.getHeight()-40) ) {
		nY -= popDim.getHeight();
	}

	popup.show(win, nX, nY);
	}

	//## Agr[g ###############################################
}
