/**
 * @(#)RLMEncoder.java
 *
 * Copyright 2001 Nomura Research Institute, LTD. All rights reserved.
 *
 * Ridual : Ridual License Module Encoder
 *
 * @author  Intelligent Technology Inc.
 * @version 1.00 2003/04/21
 */
package jp.co.nri.rid.rhedgehog;

import	java.io.*;
import	jp.co.iti.hedgehog.Hedge;

/**
 */
public class RHedge{
	public String	name	= null;
	public String	mail	= null;
	public String	pages	= null;
	public String	target	= null;
	public String	limit	= null;
	
	public void save(File file) throws IOException {
		StringWriter	sw	= new StringWriter();
		PrintWriter		pw	= new PrintWriter(new BufferedWriter(sw));
		
		pw.println(name);
		pw.println(mail);
		pw.println(pages);
		pw.println(target);
		pw.println(limit);
		pw.println(name);
		pw.println(mail);
		pw.println(pages);
		pw.println(target);
		pw.println(limit);
		pw.close();
		
		byte[]	bytes	= new Hedge().act(sw.toString().getBytes());
		int		len		= bytes.length;
		
		
		FileOutputStream fos = new FileOutputStream(file);
		try{
			fos.write(len % 0x100);
			fos.write(len / 0x100);
			fos.write(bytes);
		}
		finally{ fos.close(); }
	}
}
